/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.isolation.Isolatable;

final class DefaultImmutableAttributes
implements ImmutableAttributes,
AttributeValue<Object> {
    private static final Comparator<Attribute<?>> ATTRIBUTE_NAME_COMPARATOR = Comparator.comparing(Attribute::getName);
    private final Map<Attribute<?>, Object> coercionCache = new ConcurrentHashMap();
    final Attribute<?> attribute;
    final Isolatable<?> value;
    private final ImmutableMap<Attribute<?>, DefaultImmutableAttributes> hierarchy;
    private final ImmutableMap<String, DefaultImmutableAttributes> hierarchyByName;
    private final int hashCode;
    private final String singleEntryName;
    private final DefaultImmutableAttributes singleEntryValue;

    DefaultImmutableAttributes() {
        this.attribute = null;
        this.value = null;
        this.hashCode = 0;
        this.hierarchy = ImmutableMap.of();
        this.hierarchyByName = ImmutableMap.of();
        this.singleEntryName = null;
        this.singleEntryValue = null;
    }

    DefaultImmutableAttributes(DefaultImmutableAttributes parent, Attribute<?> key, Isolatable<?> value) {
        this.attribute = key;
        this.value = value;
        LinkedHashMap hierarchy = new LinkedHashMap();
        hierarchy.putAll((Map<Attribute<?>, DefaultImmutableAttributes>)parent.hierarchy);
        hierarchy.put(this.attribute, this);
        this.hierarchy = ImmutableMap.copyOf(hierarchy);
        LinkedHashMap<String, DefaultImmutableAttributes> hierarchyByName = new LinkedHashMap<String, DefaultImmutableAttributes>();
        hierarchyByName.putAll((Map<String, DefaultImmutableAttributes>)parent.hierarchyByName);
        hierarchyByName.put(this.attribute.getName(), this);
        this.hierarchyByName = ImmutableMap.copyOf(hierarchyByName);
        int hashCode = parent.hashCode();
        hashCode = 31 * hashCode + this.attribute.hashCode();
        this.hashCode = hashCode = 31 * hashCode + value.hashCode();
        if (hierarchyByName.size() == 1) {
            Map.Entry entry = hierarchyByName.entrySet().iterator().next();
            this.singleEntryName = (String)entry.getKey();
            this.singleEntryValue = (DefaultImmutableAttributes)entry.getValue();
        } else {
            this.singleEntryName = null;
            this.singleEntryValue = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultImmutableAttributes that = (DefaultImmutableAttributes)o;
        if (this.hierarchy.size() != that.hierarchy.size()) {
            return false;
        }
        for (Map.Entry entry : this.hierarchy.entrySet()) {
            if (((DefaultImmutableAttributes)entry.getValue()).value.isolate().equals(that.getAttribute((Attribute)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        throw new UnsupportedOperationException("Mutation of attributes is not allowed");
    }

    @Override
    public ImmutableSet<Attribute<?>> keySet() {
        return this.hierarchy.keySet();
    }

    public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
        throw new UnsupportedOperationException("Mutation of attributes is not allowed");
    }

    public <T> T getAttribute(Attribute<T> key) {
        Isolatable<T> isolatable = this.getIsolatableAttribute(key);
        return (T)(isolatable == null ? null : isolatable.isolate());
    }

    @Nullable
    protected <T> Isolatable<T> getIsolatableAttribute(Attribute<T> key) {
        DefaultImmutableAttributes attributes = (DefaultImmutableAttributes)this.hierarchy.get(key);
        return (Isolatable)Cast.uncheckedCast(attributes == null ? null : attributes.value);
    }

    @Override
    public <T> AttributeValue<T> findEntry(Attribute<T> key) {
        DefaultImmutableAttributes attributes = (DefaultImmutableAttributes)this.hierarchy.get(key);
        return (AttributeValue)Cast.uncheckedNonnullCast((Object)(attributes == null ? MISSING : attributes));
    }

    @Override
    public AttributeValue<?> findEntry(String key) {
        if (this.singleEntryName == key) {
            return this.singleEntryValue;
        }
        DefaultImmutableAttributes attributes = (DefaultImmutableAttributes)this.hierarchyByName.get((Object)key);
        return attributes == null ? MISSING : attributes;
    }

    @Override
    public Object get() {
        return this.value.isolate();
    }

    @Nullable
    private String desugar() {
        if (Named.class.isAssignableFrom(this.attribute.getType())) {
            return ((Named)this.get()).getName();
        }
        if (Enum.class.isAssignableFrom(this.attribute.getType())) {
            return ((Enum)this.get()).name();
        }
        return null;
    }

    @Override
    @Nullable
    private <S> S coerce(Class<S> type) {
        if (this.value != null) {
            return (S)this.value.coerce(type);
        }
        return null;
    }

    @Override
    public <S> S coerce(Attribute<S> otherAttribute) {
        Object s = Cast.uncheckedCast((Object)this.coercionCache.get(otherAttribute));
        if (s == null) {
            s = this.uncachedCoerce(otherAttribute);
            this.coercionCache.put(otherAttribute, s);
        }
        return (S)s;
    }

    private <S> S uncachedCoerce(Attribute<S> otherAttribute) {
        Class otherAttributeType = otherAttribute.getType();
        if (otherAttributeType.isAssignableFrom(this.attribute.getType())) {
            return (S)Cast.uncheckedCast((Object)this.get());
        }
        Object converted = this.coerce(otherAttributeType);
        if (converted != null) {
            return converted;
        }
        if (otherAttributeType.isAssignableFrom(String.class) && (converted = Cast.uncheckedCast((Object)this.desugar())) != null) {
            return converted;
        }
        String foundType = this.get().getClass().getName();
        if (foundType.equals(otherAttributeType.getName())) {
            foundType = foundType + " with a different ClassLoader";
        }
        throw new IllegalArgumentException(String.format("Unexpected type for attribute '%s' provided. Expected a value of type %s but found a value of type %s.", this.attribute.getName(), otherAttributeType.getName(), foundType));
    }

    @Override
    public boolean isPresent() {
        return this.attribute != null;
    }

    public boolean isEmpty() {
        return this.attribute == null;
    }

    public boolean contains(Attribute<?> key) {
        return this.hierarchy.containsKey(key);
    }

    @Override
    public ImmutableAttributes asImmutable() {
        return this;
    }

    @Override
    public Map<Attribute<?>, ?> asMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Attribute attribute : this.keySet()) {
            builder.put((Object)attribute, Cast.uncheckedCast(this.getAttribute(attribute)));
        }
        return builder.build();
    }

    public AttributeContainer getAttributes() {
        return this;
    }

    public String toString() {
        TreeMap sorted = new TreeMap(ATTRIBUTE_NAME_COMPARATOR);
        for (Map.Entry entry : this.hierarchy.entrySet()) {
            sorted.put((Attribute)entry.getKey(), ((DefaultImmutableAttributes)entry.getValue()).value.isolate());
        }
        return ((Object)sorted).toString();
    }
}

