/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import java.io.File;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.ArchiveTaskBasedIvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.FileBasedIvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.PublishArtifactBasedIvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationCoordinates;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypedNotationConverter;

public class IvyArtifactNotationParserFactory
implements Factory<NotationParser<Object, IvyArtifact>> {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final IvyPublicationCoordinates publicationCoordinates;
    private final TaskDependencyFactory taskDependencyFactory;

    public IvyArtifactNotationParserFactory(Instantiator instantiator, FileResolver fileResolver, IvyPublicationCoordinates publicationCoordinates, TaskDependencyFactory taskDependencyFactory) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
        this.publicationCoordinates = publicationCoordinates;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    public NotationParser<Object, IvyArtifact> create() {
        FileNotationConverter fileNotationConverter = new FileNotationConverter(this.fileResolver);
        ArchiveTaskNotationConverter archiveTaskNotationConverter = new ArchiveTaskNotationConverter();
        PublishArtifactNotationConverter publishArtifactNotationConverter = new PublishArtifactNotationConverter();
        ProviderNotationConverter providerNotationConverter = new ProviderNotationConverter();
        NotationParser sourceNotationParser = NotationParserBuilder.toType(IvyArtifact.class).fromType(Provider.class, (NotationConverter)Cast.uncheckedCast((Object)providerNotationConverter)).converter((NotationConverter)archiveTaskNotationConverter).converter((NotationConverter)publishArtifactNotationConverter).converter((NotationConverter)fileNotationConverter).toComposite();
        IvyArtifactMapNotationConverter ivyArtifactMapNotationConverter = new IvyArtifactMapNotationConverter(sourceNotationParser);
        return NotationParserBuilder.toType(IvyArtifact.class).converter((NotationConverter)archiveTaskNotationConverter).converter((NotationConverter)publishArtifactNotationConverter).fromType(Provider.class, (NotationConverter)Cast.uncheckedCast((Object)providerNotationConverter)).converter((NotationConverter)ivyArtifactMapNotationConverter).converter((NotationConverter)fileNotationConverter).toComposite();
    }

    private static class IvyArtifactMapNotationConverter
    extends MapNotationConverter<IvyArtifact> {
        private final NotationParser<Object, IvyArtifact> sourceNotationParser;

        private IvyArtifactMapNotationConverter(NotationParser<Object, IvyArtifact> sourceNotationParser) {
            this.sourceNotationParser = sourceNotationParser;
        }

        protected IvyArtifact parseMap(@MapKey(value="source") Object source) {
            return (IvyArtifact)this.sourceNotationParser.parseNotation(source);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps containing a 'source' entry").example("[source: '/path/to/file', extension: 'zip']");
        }
    }

    private class FileNotationConverter
    implements NotationConverter<Object, IvyArtifact> {
        private final NotationParser<Object, File> fileResolverNotationParser;

        private FileNotationConverter(FileResolver fileResolver) {
            this.fileResolverNotationParser = fileResolver.asNotationParser();
        }

        public void convert(Object notation, NotationConvertResult<? super IvyArtifact> result) throws TypeConversionException {
            File file = (File)this.fileResolverNotationParser.parseNotation(notation);
            IvyArtifact ivyArtifact = (IvyArtifact)IvyArtifactNotationParserFactory.this.instantiator.newInstance(FileBasedIvyArtifact.class, new Object[]{file, IvyArtifactNotationParserFactory.this.publicationCoordinates, IvyArtifactNotationParserFactory.this.taskDependencyFactory});
            if (notation instanceof TaskDependencyContainer) {
                TaskDependencyContainer taskDependencyContainer = notation instanceof Provider ? context -> context.add(notation) : (TaskDependencyContainer)notation;
                ivyArtifact.builtBy(new Object[]{taskDependencyContainer});
            }
            result.converted((Object)ivyArtifact);
        }

        public void describe(DiagnosticsVisitor visitor) {
            this.fileResolverNotationParser.describe(visitor);
        }
    }

    private class ProviderNotationConverter
    implements NotationConverter<Provider<?>, IvyArtifact> {
        private ProviderNotationConverter() {
        }

        public void convert(Provider<?> publishArtifact, NotationConvertResult<? super IvyArtifact> result) throws TypeConversionException {
            IvyArtifact artifact = (IvyArtifact)IvyArtifactNotationParserFactory.this.instantiator.newInstance(PublishArtifactBasedIvyArtifact.class, new Object[]{new LazyPublishArtifact(publishArtifact, IvyArtifactNotationParserFactory.this.fileResolver, IvyArtifactNotationParserFactory.this.taskDependencyFactory), IvyArtifactNotationParserFactory.this.publicationCoordinates, IvyArtifactNotationParserFactory.this.taskDependencyFactory});
            result.converted((Object)artifact);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of Provider.");
        }
    }

    private class PublishArtifactNotationConverter
    extends TypedNotationConverter<PublishArtifact, IvyArtifact> {
        private PublishArtifactNotationConverter() {
            super(PublishArtifact.class);
        }

        protected IvyArtifact parseType(PublishArtifact publishArtifact) {
            return (IvyArtifact)IvyArtifactNotationParserFactory.this.instantiator.newInstance(PublishArtifactBasedIvyArtifact.class, new Object[]{publishArtifact, IvyArtifactNotationParserFactory.this.publicationCoordinates, IvyArtifactNotationParserFactory.this.taskDependencyFactory});
        }
    }

    private class ArchiveTaskNotationConverter
    extends TypedNotationConverter<AbstractArchiveTask, IvyArtifact> {
        private ArchiveTaskNotationConverter() {
            super(AbstractArchiveTask.class);
        }

        protected IvyArtifact parseType(AbstractArchiveTask archiveTask) {
            return (IvyArtifact)IvyArtifactNotationParserFactory.this.instantiator.newInstance(ArchiveTaskBasedIvyArtifact.class, new Object[]{archiveTask, IvyArtifactNotationParserFactory.this.publicationCoordinates, IvyArtifactNotationParserFactory.this.taskDependencyFactory});
        }
    }
}

