/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.extensions.ReplFactoryExtension;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.CreateReplStageStateAction;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckAction;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileAction;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreProjectEnvironment;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.daemon.KotlinJvmReplServiceBase;
import org.jetbrains.kotlin.daemon.KotlinRemoteReplServiceKt;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\fH\u0014J\u0010\u0010/\u001a\u00020-2\u0006\u0010.\u001a\u00020\fH\u0014J\u001c\u00100\u001a\u0002012\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\u0006\u00104\u001a\u000205H\u0016J\u001c\u00106\u001a\u0002072\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\u0006\u00104\u001a\u000205H\u0016J\u0014\u00108\u001a\u0006\u0012\u0002\b\u0003032\u0006\u00109\u001a\u00020)H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\u001f\u001a\u0004\u0018\u00010 8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001c\u001a\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/daemon/KotlinJvmReplServiceBase;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileAction;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckAction;", "Lorg/jetbrains/kotlin/cli/common/repl/CreateReplStageStateAction;", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "templateClasspath", "", "Ljava/io/File;", "templateClassName", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/daemon/common/CompilerId;Ljava/util/List;Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "getCompilerId", "()Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "getMessageCollector", "()Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "replCompiler", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiler;", "getReplCompiler", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiler;", "replCompiler$delegate", "stateIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getStateIdCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "statesLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getStatesLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "after", "", "s", "before", "check", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "state", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageState;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "compile", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "createState", "lock", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nKotlinRemoteReplService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinRemoteReplService.kt\norg/jetbrains/kotlin/daemon/KotlinJvmReplServiceBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
public abstract class KotlinJvmReplServiceBase
implements ReplCompileAction,
ReplCheckAction,
CreateReplStageStateAction {
    @NotNull
    private final CompilerId compilerId;
    @NotNull
    private final MessageCollector messageCollector;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final Lazy replCompiler$delegate;
    @NotNull
    private final ReentrantReadWriteLock statesLock;
    @NotNull
    private final AtomicInteger stateIdCounter;

    /*
     * WARNING - void declaration
     */
    public KotlinJvmReplServiceBase(@NotNull Disposable disposable, @NotNull CompilerId compilerId, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName, @NotNull MessageCollector messageCollector) {
        void it;
        void $this$configuration_u24lambda_u241;
        CompilerConfiguration compilerConfiguration;
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        this.compilerId = compilerId;
        this.messageCollector = messageCollector;
        this.log$delegate = LazyKt.lazy((Function0)log.2.INSTANCE);
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration = new CompilerConfiguration();
        KotlinJvmReplServiceBase kotlinJvmReplServiceBase = this;
        boolean bl = false;
        $this$configuration_u24lambda_u241.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)this.messageCollector);
        KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForCompiler();
        void var10_11 = $this$configuration_u24lambda_u241;
        boolean bl2 = false;
        Object[] objectArray = new File[]{it.getStdlibPath(), it.getReflectPath(), it.getScriptRuntimePath()};
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)var10_11, (List)CollectionsKt.listOf((Object[])objectArray));
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)$this$configuration_u24lambda_u241, templateClasspath);
        JvmContentRootsKt.configureJdkClasspathRoots((CompilerConfiguration)$this$configuration_u24lambda_u241);
        $this$configuration_u24lambda_u241.put(CommonConfigurationKeys.MODULE_NAME, (Object)"kotlin-script");
        CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)$this$configuration_u24lambda_u241, (LanguageVersionSettings)((LanguageVersionSettings)new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST_STABLE, MapsKt.mapOf((Pair)TuplesKt.to((Object)AnalysisFlags.getSkipMetadataVersionCheck(), (Object)true)), null, 8, null)));
        KotlinRemoteReplServiceKt.configureScripting((CompilerConfiguration)$this$configuration_u24lambda_u241, this.compilerId);
        kotlinJvmReplServiceBase.configuration = compilerConfiguration;
        this.replCompiler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ReplCompiler>(disposable, this, templateClassName, templateClasspath){
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ KotlinJvmReplServiceBase this$0;
            final /* synthetic */ String $templateClassName;
            final /* synthetic */ List<File> $templateClasspath;
            {
                this.$disposable = $disposable;
                this.this$0 = $receiver;
                this.$templateClassName = $templateClassName;
                this.$templateClasspath = $templateClasspath;
                super(0);
            }

            @NotNull
            public final ReplCompiler invoke() {
                ReplCompiler replCompiler2;
                try {
                    KotlinCoreEnvironment.ProjectEnvironment projectEnvironment = new KotlinCoreEnvironment.ProjectEnvironment(this.$disposable, KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(this.$disposable, this.this$0.getConfiguration()), this.this$0.getConfiguration());
                    MockProject mockProject = projectEnvironment.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"projectEnvironment.project");
                    ReplFactoryExtension.Companion.registerExtensionPoint((Project)mockProject);
                    projectEnvironment.registerExtensionsFromPlugins(this.this$0.getConfiguration());
                    MockProject mockProject2 = projectEnvironment.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)mockProject2, (String)"projectEnvironment.project");
                    List replFactories = ReplFactoryExtension.Companion.getInstances((Project)mockProject2);
                    if (replFactories.isEmpty()) {
                        throw new IllegalStateException("no scripting plugin loaded");
                    }
                    if (replFactories.size() > 1) {
                        throw new IllegalStateException("several scripting plugins loaded");
                    }
                    replCompiler2 = ((ReplFactoryExtension)CollectionsKt.first((List)replFactories)).makeReplCompiler(this.$templateClassName, this.$templateClasspath, this.this$0.getClass().getClassLoader(), this.this$0.getConfiguration(), (JavaCoreProjectEnvironment)projectEnvironment);
                }
                catch (Throwable ex) {
                    MessageCollector.report$default((MessageCollector)this.this$0.getMessageCollector(), (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)("Unable to construct repl compiler: " + ex.getMessage()), null, (int)4, null);
                    throw new IllegalStateException("Unable to use scripting/REPL in the daemon: " + ex.getMessage(), ex);
                }
                return replCompiler2;
            }
        }));
        this.statesLock = new ReentrantReadWriteLock();
        this.stateIdCounter = new AtomicInteger();
    }

    @NotNull
    public final CompilerId getCompilerId() {
        return this.compilerId;
    }

    @NotNull
    protected final MessageCollector getMessageCollector() {
        return this.messageCollector;
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    protected final CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    protected final ReplCompiler getReplCompiler() {
        Lazy lazy = this.replCompiler$delegate;
        return (ReplCompiler)lazy.getValue();
    }

    @NotNull
    protected final ReentrantReadWriteLock getStatesLock() {
        return this.statesLock;
    }

    @NotNull
    protected final AtomicInteger getStateIdCounter() {
        return this.stateIdCounter;
    }

    @NotNull
    public IReplStageState<?> createState(@NotNull ReentrantReadWriteLock lock) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        ReplCompiler replCompiler2 = this.getReplCompiler();
        if (replCompiler2 == null || (replCompiler2 = replCompiler2.createState(lock)) == null) {
            throw new IllegalStateException("repl compiler is not initialized properly");
        }
        return replCompiler2;
    }

    protected void before(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
    }

    protected void after(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ReplCheckResult check(@NotNull IReplStageState<?> state, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        this.before("check");
        try {
            ReplCompiler replCompiler2 = this.getReplCompiler();
            if (replCompiler2 == null || (replCompiler2 = replCompiler2.check(state, codeLine)) == null) {
                replCompiler2 = (ReplCheckResult)new ReplCheckResult.Error("Initialization error", null, 2, null);
            }
            ReplCompiler replCompiler3 = replCompiler2;
            return replCompiler3;
        }
        finally {
            this.after("check");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ReplCompileResult compile(@NotNull IReplStageState<?> state, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        this.before("compile");
        try {
            ReplCompiler replCompiler2 = this.getReplCompiler();
            if (replCompiler2 == null || (replCompiler2 = replCompiler2.compile(state, codeLine)) == null) {
                replCompiler2 = (ReplCompileResult)new ReplCompileResult.Error("Initialization error", null, 2, null);
            }
            ReplCompiler replCompiler3 = replCompiler2;
            return replCompiler3;
        }
        finally {
            this.after("compile");
        }
    }
}

