/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt$special$;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010\u0019\u001a\u00020\u0012*\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0001\u001a\n\u0010\u001b\u001a\u00020\u000f*\u00020\u0018\u001a\u0012\u0010\u001c\u001a\u00020\u0001*\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u001e\u001a\u00020\u0001*\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u001f\u001a\u00020\u0001*\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010 \u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010!\u001a\u00020\u0001*\u00020\"2\u0006\u0010#\u001a\u00020$\u001a\u0012\u0010%\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0002*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u001d\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001d\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\t*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r\u00a8\u0006&"}, d2={"isInstantiableEnum", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "parentEnumClassOrNull", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getParentEnumClassOrNull", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "typeArguments", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getTypeArguments", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Ljava/util/List;", "valueArguments", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getValueArguments", "getKotlinOrJsQualifier", "Lorg/jetbrains/kotlin/name/FqName;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "shouldIncludePackage", "irEmpty", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getFqNameWithJsNameWhenAvailable", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getVoid", "hasStrictSignature", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "isExportedClass", "isExportedInterface", "isExportedMember", "isTheLastReturnStatementIn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "target", "Lorg/jetbrains/kotlin/ir/symbols/IrReturnableBlockSymbol;", "jsConstructorReference", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrJsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrJsUtils.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrJsUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,101:1\n1#2:102\n31#3:103\n34#3:104\n473#4:105\n179#4,2:106\n*S KotlinDebug\n*F\n+ 1 IrJsUtils.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrJsUtilsKt\n*L\n42#1:103\n45#1:104\n80#1:105\n80#1:106,2\n*E\n"})
public final class IrJsUtilsKt {
    @NotNull
    public static final IrExpression jsConstructorReference(@NotNull IrClass $this$jsConstructorReference, @NotNull JsIrBackendContext context) {
        IrCall irCall;
        Intrinsics.checkNotNullParameter((Object)$this$jsConstructorReference, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrCall $this$jsConstructorReference_u24lambda_u240 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, context.getIntrinsics().getJsClass(), null, null, JsStatementOrigins.CLASS_REFERENCE.INSTANCE, null, 22, null);
        boolean bl = false;
        $this$jsConstructorReference_u24lambda_u240.putTypeArgument(0, IrUtilsKt.getDefaultType($this$jsConstructorReference));
        return irCall;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedMember(@NotNull IrDeclaration $this$isExportedMember, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isExportedMember, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!($this$isExportedMember instanceof IrDeclarationWithVisibility)) return false;
        if (!((IrDeclarationWithVisibility)$this$isExportedMember).getVisibility().isPublicAPI()) return false;
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull($this$isExportedMember);
        if (irClass2 == null) return false;
        if (!ExportModelGeneratorKt.isExported(irClass2, context)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedClass(@Nullable IrDeclaration $this$isExportedClass, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!($this$isExportedClass instanceof IrClass)) return false;
        ClassKind $this$isClass$iv = ((IrClass)$this$isExportedClass).getKind();
        boolean $i$f$isClass = false;
        if ($this$isClass$iv != ClassKind.CLASS) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!ExportModelGeneratorKt.isExported($this$isExportedClass, context)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedInterface(@Nullable IrDeclaration $this$isExportedInterface, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!($this$isExportedInterface instanceof IrClass)) return false;
        ClassKind $this$isInterface$iv = ((IrClass)$this$isExportedInterface).getKind();
        boolean $i$f$isInterface = false;
        if ($this$isInterface$iv != ClassKind.INTERFACE) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!ExportModelGeneratorKt.isExported($this$isExportedInterface, context)) return false;
        return true;
    }

    public static final boolean isTheLastReturnStatementIn(@NotNull IrReturn $this$isTheLastReturnStatementIn, @NotNull IrReturnableBlockSymbol target) {
        Intrinsics.checkNotNullParameter((Object)$this$isTheLastReturnStatementIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return CollectionsKt.lastOrNull(((IrReturnableBlock)target.getOwner()).getStatements()) == $this$isTheLastReturnStatementIn;
    }

    @NotNull
    public static final FqName getFqNameWithJsNameWhenAvailable(@NotNull IrDeclarationWithName $this$getFqNameWithJsNameWhenAvailable, boolean shouldIncludePackage) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameWithJsNameWhenAvailable, (String)"<this>");
        Name name = AnnotationUtilsKt.getJsNameOrKotlinName($this$getFqNameWithJsNameWhenAvailable);
        IrDeclarationParent parent2 = $this$getFqNameWithJsNameWhenAvailable.getParent();
        if (parent2 instanceof IrDeclarationWithName) {
            FqName fqName3 = IrJsUtilsKt.getFqNameWithJsNameWhenAvailable((IrDeclarationWithName)((Object)parent2), shouldIncludePackage).child(name);
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"parent.getFqNameWithJsNa\u2026cludePackage).child(name)");
        } else if (parent2 instanceof IrPackageFragment) {
            fqName2 = IrJsUtilsKt.getKotlinOrJsQualifier((IrPackageFragment)parent2, shouldIncludePackage);
            if (fqName2 == null || (fqName2 = fqName2.child(name)) == null) {
                fqName2 = new FqName(name.getIdentifier());
            }
        } else {
            fqName2 = new FqName(name.getIdentifier());
        }
        return fqName2;
    }

    public static final boolean hasStrictSignature(@NotNull IrConstructor $this$hasStrictSignature, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$hasStrictSignature, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrBuiltIns $this$hasStrictSignature_u24lambda_u241 = context.getIrBuiltIns();
        boolean bl = false;
        List primitives = CollectionsKt.plus($this$hasStrictSignature_u24lambda_u241.getPrimitiveTypesToPrimitiveArrays().values(), (Object)$this$hasStrictSignature_u24lambda_u241.getStringClass());
        IrClass $this$hasStrictSignature_u24lambda_u242 = IrUtilsKt.getParentAsClass($this$hasStrictSignature);
        boolean bl2 = false;
        return $this$hasStrictSignature_u24lambda_u242.isExternal() || $this$hasStrictSignature_u24lambda_u242.isExpect() || IrUtilsKt.isAnnotationClass($this$hasStrictSignature_u24lambda_u242) || context.getInlineClassesUtils().isClassInlineLike($this$hasStrictSignature_u24lambda_u242) || primitives.contains($this$hasStrictSignature_u24lambda_u242.getSymbol());
    }

    private static final FqName getKotlinOrJsQualifier(IrPackageFragment parent2, boolean shouldIncludePackage) {
        FqName fqName2;
        Object object = parent2 instanceof IrFile ? (IrFile)parent2 : null;
        if (object != null && (object = AnnotationUtilsKt.getJsQualifier((IrAnnotationContainer)object)) != null) {
            Object it = object;
            boolean bl = false;
            fqName2 = new FqName((String)it);
        } else {
            FqName fqName3;
            FqName it = fqName3 = parent2.getFqName();
            boolean bl = false;
            fqName2 = shouldIncludePackage ? fqName3 : null;
        }
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IrType> getTypeArguments(@NotNull IrFunctionAccessExpression $this$typeArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$typeArguments, (String)"<this>");
        int n = $this$typeArguments.getTypeArgumentsCount();
        ArrayList<IrType> arrayList = new ArrayList<IrType>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<IrType> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add($this$typeArguments.getTypeArgument((int)it));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IrExpression> getValueArguments(@NotNull IrFunctionAccessExpression $this$valueArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$valueArguments, (String)"<this>");
        int n = $this$valueArguments.getValueArgumentsCount();
        ArrayList<IrExpression> arrayList = new ArrayList<IrExpression>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<IrExpression> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add($this$valueArguments.getValueArgument((int)it));
        }
        return arrayList;
    }

    public static final boolean isInstantiableEnum(@NotNull IrClass $this$isInstantiableEnum) {
        Intrinsics.checkNotNullParameter((Object)$this$isInstantiableEnum, (String)"<this>");
        return IrUtilsKt.isEnumClass($this$isInstantiableEnum) && !$this$isInstantiableEnum.isExpect() && !IrUtilsKt.isEffectivelyExternal($this$isInstantiableEnum);
    }

    @Nullable
    public static final IrClass getParentEnumClassOrNull(@NotNull IrDeclaration $this$parentEnumClassOrNull) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$parentEnumClassOrNull, (String)"<this>");
            Sequence<IrDeclarationParent> $this$filterIsInstance$iv = LocalDeclarationsLoweringKt.getParents($this$parentEnumClassOrNull);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, (Function1)special$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$firstOrNull$iv = sequence2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrClass it = (IrClass)element$iv;
                boolean bl = false;
                if (!IrJsUtilsKt.isInstantiableEnum(it)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public static final IrExpression getVoid(@NotNull JsIrBackendContext $this$getVoid) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$getVoid, (String)"<this>");
        IrField irField = ((IrProperty)$this$getVoid.getIntrinsics().getVoid().getOwner()).getBackingField();
        if (irField != null) {
            IrField it = irField;
            boolean bl = false;
            irExpression = new IrGetFieldImpl(-1, -1, it.getSymbol(), $this$getVoid.getIrBuiltIns().getNothingNType(), null, null, 48, null);
        } else {
            irExpression = IrConstImpl.Companion.constNull(-1, -1, $this$getVoid.getIrBuiltIns().getNothingNType());
        }
        return irExpression;
    }

    @NotNull
    public static final IrExpression irEmpty(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return JsIrBuilder.INSTANCE.buildComposite(context.getDynamicType(), CollectionsKt.emptyList());
    }
}

