/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeAnnotationContainer;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiReferenceListImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class JavaClassReferenceListElementType
extends JavaStubElementType<PsiClassReferenceListStub, PsiReferenceList> {
    public JavaClassReferenceListElementType(@NotNull String id) {
        if (id == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(0);
        }
        super(id, true);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull PsiClassReferenceListStub stub) {
        if (stub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(1);
        }
        return this.getPsiFactory(stub).createClassReferenceList(stub);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(2);
        }
        return new PsiReferenceListImpl(node);
    }

    @Override
    @NotNull
    public PsiClassReferenceListStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        if (tree == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(3);
        }
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(4);
        }
        if (parentStub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(5);
        }
        JavaClassReferenceListElementType type2 = (JavaClassReferenceListElementType)node.getTokenType();
        return new PsiClassReferenceListStubImpl(type2, parentStub, JavaClassReferenceListElementType.getTexts(tree, node));
    }

    private static String @NotNull [] getTexts(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(6);
        }
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(7);
        }
        List<LighterASTNode> refs = LightTreeUtil.getChildrenOfType(tree, node, JavaElementType.JAVA_CODE_REFERENCE);
        String[] texts = ArrayUtil.newStringArray(refs.size());
        for (int i = 0; i < refs.size(); ++i) {
            texts[i] = LightTreeUtil.toFilteredString(tree, refs.get(i), null);
        }
        if (texts == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(8);
        }
        return texts;
    }

    @Override
    public void serialize(@NotNull PsiClassReferenceListStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        TypeInfo[] types2;
        boolean hasAnnotations;
        if (stub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(9);
        }
        if (dataStream == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(10);
        }
        dataStream.writeVarInt((hasAnnotations = ContainerUtil.exists(types2 = stub.getTypes(), info -> !info.getTypeAnnotations().isEmpty())) ? -types2.length : types2.length);
        for (TypeInfo info2 : types2) {
            dataStream.writeName(info2.text);
        }
        if (hasAnnotations) {
            for (TypeInfo info2 : types2) {
                TypeAnnotationContainer.writeTypeAnnotations(dataStream, info2.getTypeAnnotations());
            }
        }
    }

    @Override
    @NotNull
    public PsiClassReferenceListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        int i;
        int len;
        if (dataStream == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(11);
        }
        boolean hasAnnotations = (len = dataStream.readVarInt()) < 0;
        len = Math.abs(len);
        TypeInfo[] infos = new TypeInfo[len];
        for (i = 0; i < infos.length; ++i) {
            infos[i] = new TypeInfo(dataStream.readNameString());
        }
        if (hasAnnotations) {
            for (i = 0; i < len; ++i) {
                infos[i].setTypeAnnotations(TypeAnnotationContainer.readTypeAnnotations(dataStream));
            }
        }
        return new PsiClassReferenceListStubImpl(this, parentStub, infos);
    }

    @Override
    public void indexStub(@NotNull PsiClassReferenceListStub stub, @NotNull IndexSink sink) {
        PsiReferenceList.Role role;
        if (stub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(12);
        }
        if (sink == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(13);
        }
        if ((role = stub.getRole()) == PsiReferenceList.Role.EXTENDS_LIST || role == PsiReferenceList.Role.IMPLEMENTS_LIST) {
            StubElement parentStub;
            String[] names2;
            for (String name : names2 = stub.getReferencedNames()) {
                String shortName = PsiNameHelper.getShortClassName(name);
                if (StringUtil.isEmptyOrSpaces(shortName)) continue;
                sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, shortName);
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST && (parentStub = stub.getParentStub()) instanceof PsiClassStub) {
                PsiClassStub psiClassStub = (PsiClassStub)parentStub;
                if (psiClassStub.isEnum()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, "Enum");
                }
                if (psiClassStub.isAnnotationType()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, "Annotation");
                }
            }
        }
    }

    @NotNull
    public static PsiReferenceList.Role elementTypeToRole(@NotNull IElementType type2) {
        if (type2 == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(14);
        }
        if (type2 == JavaStubElementTypes.EXTENDS_BOUND_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(15);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.EXTENDS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.EXTENDS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(16);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.IMPLEMENTS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.IMPLEMENTS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(17);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.THROWS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.THROWS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(18);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.PROVIDES_WITH_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.PROVIDES_WITH_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(19);
            }
            return role;
        }
        if (type2 == JavaStubElementTypes.PERMITS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.PERMITS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(20);
            }
            return role;
        }
        throw new RuntimeException("Unknown element type: " + type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTexts";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "elementTypeToRole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTexts";
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "elementTypeToRole";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

