/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.toolchain;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.gradle.cache.FileLock;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.JdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.install.DefaultJdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.internal.install.SecureFileDownloader;
import org.gradle.jvm.toolchain.internal.install.exceptions.ToolchainDownloadException;
import org.gradle.jvm.toolchain.internal.install.exceptions.ToolchainProvisioningException;
import org.gradle.launcher.daemon.toolchain.ToolchainDownloadUrlProvider;
import org.gradle.platform.internal.CurrentBuildPlatform;

public class DaemonJavaToolchainProvisioningService
implements JavaToolchainProvisioningService {
    private static final Object PROVISIONING_PROCESS_LOCK = new Object();
    private final SecureFileDownloader downloader;
    private final DefaultJdkCacheDirectory cacheDirProvider;
    private final CurrentBuildPlatform buildPlatform;
    private final ToolchainDownloadUrlProvider toolchainDownloadUrlProvider;
    private final boolean isAutoDownloadEnabled;
    private final ProgressLoggerFactory progressLoggerFactory;

    public DaemonJavaToolchainProvisioningService(SecureFileDownloader downloader, JdkCacheDirectory cacheDirProvider, CurrentBuildPlatform buildPlatform, ToolchainDownloadUrlProvider toolchainDownloadUrlProvider, Boolean isAutoDownloadEnabled, ProgressLoggerFactory progressLoggerFactory) {
        this.downloader = downloader;
        this.cacheDirProvider = (DefaultJdkCacheDirectory)cacheDirProvider;
        this.buildPlatform = buildPlatform;
        this.toolchainDownloadUrlProvider = toolchainDownloadUrlProvider;
        this.isAutoDownloadEnabled = isAutoDownloadEnabled;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    public boolean isAutoDownloadEnabled() {
        return this.isAutoDownloadEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File tryInstall(JavaToolchainSpec spec) {
        if (!this.isAutoDownloadEnabled()) {
            throw new ToolchainProvisioningException(spec, "Toolchain auto-provisioning is not enabled.", new String[]{ToolchainProvisioningException.AUTO_DETECTION_RESOLUTION});
        }
        Object object = PROVISIONING_PROCESS_LOCK;
        synchronized (object) {
            File file;
            URI uri = this.getBuildPlatformToolchainUrl(spec);
            ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DaemonJavaToolchainProvisioningService.class);
            progressLogger.start("Installing toolchain", null);
            File downloadFolder = this.cacheDirProvider.getDownloadLocation();
            ExternalResource resource = this.downloader.getResourceFor(uri);
            File archiveFile = new File(downloadFolder, this.getFileName(uri, resource));
            FileLock fileLock = this.cacheDirProvider.acquireWriteLock(archiveFile, "Downloading toolchain");
            try {
                if (!archiveFile.exists()) {
                    this.downloader.download(uri, archiveFile, resource);
                }
                progressLogger.progress("Unpacking toolchain archive " + archiveFile.getName());
                File installedToolchainFile = this.cacheDirProvider.provisionFromArchive(spec, archiveFile, uri);
                progressLogger.completed("Installed toolchain", false);
                file = installedToolchainFile;
            }
            catch (Throwable throwable) {
                try {
                    fileLock.close();
                    throw throwable;
                }
                catch (Exception e) {
                    progressLogger.completed("Failed to installed toolchain", true);
                    throw new ToolchainDownloadException(spec, uri, (Throwable)e);
                }
            }
            fileLock.close();
            return file;
        }
    }

    private URI getBuildPlatformToolchainUrl(JavaToolchainSpec spec) {
        String stringUri = this.toolchainDownloadUrlProvider.getToolchainDownloadUrlByPlatform().get(this.buildPlatform.toBuildPlatform());
        try {
            return new URI(stringUri);
        }
        catch (NullPointerException e) {
            String cause = String.format("No defined toolchain download url for %s on %s architecture.", this.buildPlatform.getOperatingSystem(), this.buildPlatform.getArchitecture().toString().toLowerCase(Locale.ROOT));
            throw new ToolchainDownloadException(spec, stringUri, cause);
        }
        catch (URISyntaxException e) {
            String cause = String.format("Invalid toolchain download url %s for %s on %s architecture.", stringUri, this.buildPlatform.getOperatingSystem(), this.buildPlatform.getArchitecture().toString().toLowerCase(Locale.ROOT));
            throw new ToolchainDownloadException(spec, stringUri, cause);
        }
    }
}

