/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.AdditionalData;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.AdditionalDataBuilderFactory;
import org.gradle.api.problems.internal.AdditionalDataSpec;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

@NonNullApi
class DelegatingProblemBuilder
implements InternalProblemBuilder {
    private final InternalProblemBuilder delegate;

    DelegatingProblemBuilder(InternalProblemBuilder delegate) {
        this.delegate = delegate;
    }

    public InternalProblem build() {
        return this.delegate.build();
    }

    public InternalProblemBuilder id(ProblemId problemId) {
        return this.validateDelegate(this.delegate).id(problemId);
    }

    public InternalProblemBuilder id(String name, String displayName, ProblemGroup parent) {
        return this.validateDelegate(this.delegate).id(name, displayName, parent);
    }

    public InternalProblemBuilder contextualLabel(String contextualLabel) {
        return this.validateDelegate(this.delegate).contextualLabel(contextualLabel);
    }

    public InternalProblemBuilder documentedAt(DocLink doc) {
        return this.validateDelegate(this.delegate.documentedAt(doc));
    }

    public InternalProblemBuilder documentedAt(String url) {
        return this.validateDelegate(this.delegate.documentedAt(url));
    }

    public InternalProblemBuilder fileLocation(String path) {
        return this.validateDelegate(this.delegate.fileLocation(path));
    }

    public InternalProblemBuilder lineInFileLocation(String path, int line) {
        return this.validateDelegate(this.delegate.lineInFileLocation(path, line));
    }

    public InternalProblemBuilder lineInFileLocation(String path, int line, int column) {
        return this.validateDelegate(this.delegate.offsetInFileLocation(path, line, column));
    }

    public InternalProblemBuilder lineInFileLocation(String path, int line, int column, int length) {
        return this.validateDelegate(this.delegate.lineInFileLocation(path, line, column, length));
    }

    public InternalProblemBuilder offsetInFileLocation(String path, int offset, int length) {
        return this.validateDelegate(this.delegate.offsetInFileLocation(path, offset, length));
    }

    public InternalProblemBuilder stackLocation() {
        return this.validateDelegate(this.delegate.stackLocation());
    }

    public InternalProblemBuilder details(String details) {
        return this.validateDelegate(this.delegate.details(details));
    }

    public InternalProblemBuilder solution(@Nullable String solution) {
        return this.validateDelegate(this.delegate.solution(solution));
    }

    public InternalProblemBuilder taskPathLocation(String buildTreePath) {
        return this.validateDelegate(this.delegate.solution(buildTreePath));
    }

    public <U extends AdditionalDataSpec> InternalProblemBuilder additionalDataInternal(Class<? extends U> specType, Action<? super U> config) {
        return this.validateDelegate(this.delegate.additionalDataInternal(specType, config));
    }

    public <T extends AdditionalData> InternalProblemBuilder additionalData(Class<T> type, Action<? super T> config) {
        return this.validateDelegate(this.delegate.additionalData(type, config));
    }

    public <T extends AdditionalData> InternalProblemBuilder additionalDataInternal(T additionalDataInstance) {
        return this.validateDelegate(this.delegate.additionalDataInternal(additionalDataInstance));
    }

    public InternalProblemBuilder withException(Throwable t) {
        return this.validateDelegate(this.delegate.withException(t));
    }

    public InternalProblemBuilder severity(Severity severity) {
        return this.validateDelegate(this.delegate.severity(severity));
    }

    public AdditionalDataBuilderFactory getAdditionalDataBuilderFactory() {
        return this.delegate.getAdditionalDataBuilderFactory();
    }

    public Instantiator getInstantiator() {
        return this.delegate.getInstantiator();
    }

    public PayloadSerializer getPayloadSerializer() {
        return this.delegate.getPayloadSerializer();
    }

    private <T> T validateDelegate(T newDelegate) {
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return newDelegate;
    }
}

