/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.collect.ImmutableCollection;
import groovy.lang.GString;
import javax.annotation.Nullable;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.internal.Cast;

public class ValueSanitizers {
    private static final ValueSanitizer<Object> STRING_VALUE_SANITIZER = new ValueSanitizer<Object>(){

        @Override
        @Nullable
        public Object sanitize(@Nullable Object value) {
            if (value instanceof GString) {
                return value.toString();
            }
            return value;
        }
    };
    private static final ValueSanitizer<Object> LONG_VALUE_SANITIZER = new ValueSanitizer<Object>(){

        @Override
        @Nullable
        public Object sanitize(@Nullable Object value) {
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            return value;
        }
    };
    private static final ValueSanitizer<Object> IDENTITY_SANITIZER = new ValueSanitizer<Object>(){

        @Override
        @Nullable
        public Object sanitize(@Nullable Object value) {
            return value;
        }
    };
    private static final ValueCollector<Object> IDENTITY_VALUE_COLLECTOR = ValueSanitizers.valueCollectorWithValueSanitizer(IDENTITY_SANITIZER);
    private static final ValueCollector<Object> STRING_VALUE_COLLECTOR = ValueSanitizers.valueCollectorWithValueSanitizer(STRING_VALUE_SANITIZER);
    private static final ValueCollector<Object> LONG_VALUE_COLLECTOR = ValueSanitizers.valueCollectorWithValueSanitizer(LONG_VALUE_SANITIZER);

    public static <T> ValueSanitizer<T> forType(Class<? extends T> targetType) {
        if (String.class.equals(targetType)) {
            return (ValueSanitizer)Cast.uncheckedCast(STRING_VALUE_SANITIZER);
        }
        if (Long.class.equals(targetType)) {
            return (ValueSanitizer)Cast.uncheckedCast(LONG_VALUE_SANITIZER);
        }
        return (ValueSanitizer)Cast.uncheckedCast(IDENTITY_SANITIZER);
    }

    public static <T> ValueCollector<T> collectorFor(Class<? extends T> elementType) {
        if (String.class.equals(elementType)) {
            return (ValueCollector)Cast.uncheckedCast(STRING_VALUE_COLLECTOR);
        }
        if (Long.class.equals(elementType)) {
            return (ValueCollector)Cast.uncheckedCast(LONG_VALUE_COLLECTOR);
        }
        return (ValueCollector)Cast.uncheckedCast(IDENTITY_VALUE_COLLECTOR);
    }

    private static ValueCollector<Object> valueCollectorWithValueSanitizer(final ValueSanitizer<Object> sanitizer) {
        return new ValueCollector<Object>(){

            @Override
            public void add(@Nullable Object value, ImmutableCollection.Builder<Object> dest) {
                dest.add(sanitizer.sanitize(value));
            }

            @Override
            public void addAll(Iterable<?> values, ImmutableCollection.Builder<Object> dest) {
                for (Object value : values) {
                    this.add(value, dest);
                }
            }
        };
    }
}

