/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AbstractAttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValueIsolator;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.isolation.Isolatable;

final class DefaultMutableAttributeContainer
extends AbstractAttributeContainer
implements AttributeContainerInternal {
    private final Map<Attribute<?>, Isolatable<?>> attributes = new LinkedHashMap();
    private Map<Attribute<?>, Provider<?>> lazyAttributes = (Map)Cast.uncheckedCast((Object)Collections.EMPTY_MAP);
    private boolean realizingAttributes = false;
    private final AttributesFactory attributesFactory;
    private final AttributeValueIsolator attributeValueIsolator;
    private ImmutableAttributes immutableValue;

    public DefaultMutableAttributeContainer(AttributesFactory attributesFactory, AttributeValueIsolator attributeValueIsolator) {
        this.attributesFactory = attributesFactory;
        this.attributeValueIsolator = attributeValueIsolator;
    }

    public String toString() {
        this.maybeEmitRecursiveQueryDeprecation();
        TreeMap sorted = new TreeMap(Comparator.comparing(Attribute::getName));
        this.lazyAttributes.keySet().forEach(key -> sorted.put((Attribute)key, this.lazyAttributes.get(key).toString()));
        this.attributes.keySet().forEach(key -> sorted.put((Attribute)key, this.attributes.get(key).toString()));
        return ((Object)sorted).toString();
    }

    public Set<Attribute<?>> keySet() {
        this.maybeEmitRecursiveQueryDeprecation();
        return ImmutableSet.copyOf((Collection)Sets.union(this.attributes.keySet(), this.lazyAttributes.keySet()));
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        this.checkInsertionAllowed(key);
        this.doInsertion(key, value);
        return this;
    }

    private <T> void doInsertion(Attribute<T> key, T value) {
        this.assertAttributeValueIsNotNull(value);
        this.assertAttributeTypeIsValid(value.getClass(), key);
        this.immutableValue = null;
        this.attributes.put(key, this.attributeValueIsolator.isolate(value));
        this.removeLazyAttributeIfPresent(key);
    }

    private <T> void removeLazyAttributeIfPresent(Attribute<T> key) {
        this.lazyAttributes.remove(key);
    }

    public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
        Class valueType;
        this.checkInsertionAllowed(key);
        this.assertAttributeValueIsNotNull(provider);
        if (provider instanceof ProviderInternal && (valueType = ((ProviderInternal)Cast.uncheckedCast(provider)).getType()) != null) {
            this.assertAttributeTypeIsValid(valueType, key);
        }
        this.doInsertionLazy(key, provider);
        return this;
    }

    private <T> void checkInsertionAllowed(Attribute<T> key) {
        if (this.realizingAttributes) {
            throw new IllegalStateException("Cannot add new attribute '" + key.getName() + "' while realizing all attributes of the container.");
        }
        for (Attribute<?> attribute : this.keySet()) {
            String name = key.getName();
            if (!attribute.getName().equals(name) || attribute.getType() == key.getType()) continue;
            throw new IllegalArgumentException("Cannot have two attributes with the same name but different types. This container already has an attribute named '" + name + "' of type '" + attribute.getType().getName() + "' and you are trying to store another one of type '" + key.getType().getName() + "'");
        }
    }

    private <T> void assertAttributeTypeIsValid(Class<?> valueType, Attribute<T> attribute) {
        if (!attribute.getType().isAssignableFrom(valueType)) {
            throw new IllegalArgumentException(String.format("Unexpected type for attribute '%s' provided. Expected a value of type %s but found a value of type %s.", attribute.getName(), attribute.getType().getName(), valueType.getName()));
        }
    }

    private void assertAttributeValueIsNotNull(@Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Setting null as an attribute value is not allowed");
        }
    }

    public <T> T getAttribute(Attribute<T> key) {
        this.maybeEmitRecursiveQueryDeprecation();
        Isolatable<?> value = this.attributes.get(key);
        if (value == null) {
            if (this.lazyAttributes.containsKey(key)) {
                return this.realizeLazyAttribute(key);
            }
            return null;
        }
        return (T)Cast.uncheckedCast((Object)value.isolate());
    }

    @Override
    public ImmutableAttributes asImmutable() {
        this.maybeEmitRecursiveQueryDeprecation();
        this.realizeAllLazyAttributes();
        if (this.immutableValue == null) {
            this.immutableValue = this.attributesFactory.fromMap(this.attributes);
        }
        return this.immutableValue;
    }

    private void maybeEmitRecursiveQueryDeprecation() {
        if (this.realizingAttributes) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)"Querying the contents of an attribute container while realizing attributes of the container.").willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "attribute_container_recursive_query")).nagUser();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMutableAttributeContainer that = (DefaultMutableAttributeContainer)o;
        return Objects.equals(this.asImmutable(), that.asImmutable());
    }

    @Override
    public int hashCode() {
        return this.asImmutable().hashCode();
    }

    private <T> void doInsertionLazy(Attribute<T> key, Provider<? extends T> provider) {
        if (this.lazyAttributes == Collections.EMPTY_MAP) {
            this.lazyAttributes = new LinkedHashMap(1);
        }
        this.lazyAttributes.put(key, provider);
        this.removeAttributeIfPresent(key);
    }

    private <T> void removeAttributeIfPresent(Attribute<T> key) {
        this.immutableValue = null;
        this.attributes.remove(key);
    }

    private <T> T realizeLazyAttribute(Attribute<T> key) {
        Object value = this.lazyAttributes.get(key).get();
        this.doInsertion(key, value);
        return (T)value;
    }

    private void realizeAllLazyAttributes() {
        if (!this.lazyAttributes.isEmpty()) {
            LinkedHashSet savedKeys = new LinkedHashSet(this.lazyAttributes.keySet());
            try {
                this.realizingAttributes = true;
                savedKeys.forEach(key -> {
                    Provider<?> value = this.lazyAttributes.get(key);
                    if (value != null) {
                        this.doInsertion((Attribute)Cast.uncheckedNonnullCast((Object)key), value.get());
                    }
                });
            }
            finally {
                this.realizingAttributes = false;
            }
        }
    }
}

