/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Array;
import java.util.Collection;
import org.gradle.api.NonNullApi;
import org.gradle.api.attributes.Attribute;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.snapshot.impl.AbstractIsolatedMap;
import org.gradle.internal.snapshot.impl.ArrayOfPrimitiveValueSnapshot;
import org.gradle.internal.snapshot.impl.AttributeDefinitionSnapshot;
import org.gradle.internal.snapshot.impl.BooleanValueSnapshot;
import org.gradle.internal.snapshot.impl.FileValueSnapshot;
import org.gradle.internal.snapshot.impl.IntegerValueSnapshot;
import org.gradle.internal.snapshot.impl.IsolatedArray;
import org.gradle.internal.snapshot.impl.IsolatedEnumValueSnapshot;
import org.gradle.internal.snapshot.impl.IsolatedImmutableManagedValue;
import org.gradle.internal.snapshot.impl.IsolatedJavaSerializedValueSnapshot;
import org.gradle.internal.snapshot.impl.IsolatedList;
import org.gradle.internal.snapshot.impl.IsolatedManagedValue;
import org.gradle.internal.snapshot.impl.IsolatedMap;
import org.gradle.internal.snapshot.impl.IsolatedProperties;
import org.gradle.internal.snapshot.impl.IsolatedSet;
import org.gradle.internal.snapshot.impl.LongValueSnapshot;
import org.gradle.internal.snapshot.impl.MapEntrySnapshot;
import org.gradle.internal.snapshot.impl.NullValueSnapshot;
import org.gradle.internal.snapshot.impl.ShortValueSnapshot;
import org.gradle.internal.snapshot.impl.StringValueSnapshot;
import org.gradle.internal.state.Managed;
import org.gradle.internal.state.ManagedFactory;
import org.gradle.internal.state.ManagedFactoryRegistry;

@ServiceScope(value={Scope.UserHome.class})
public class IsolatableSerializerRegistry
extends DefaultSerializerRegistry {
    private static final byte STRING_VALUE = 0;
    private static final byte BOOLEAN_VALUE = 1;
    private static final byte SHORT_VALUE = 2;
    private static final byte INTEGER_VALUE = 3;
    private static final byte LONG_VALUE = 4;
    private static final byte ATTRIBUTE_VALUE = 5;
    private static final byte MANAGED_VALUE = 6;
    private static final byte IMMUTABLE_MANAGED_VALUE = 7;
    private static final byte FILE_VALUE = 8;
    private static final byte NULL_VALUE = 9;
    private static final byte SERIALIZED_VALUE = 10;
    private static final byte ENUM_VALUE = 11;
    private static final byte ISOLATED_MAP = 12;
    private static final byte ISOLATED_ARRAY = 13;
    private static final byte ISOLATED_LIST = 14;
    private static final byte ISOLATED_SET = 15;
    private static final byte ISOLATED_PROPERTIES = 16;
    private static final byte ISOLATED_ARRAY_OF_PRIMITIVE = 17;
    private static final byte ISOLATABLE_TYPE = 0;
    private static final byte ARRAY_TYPE = 1;
    private static final byte OTHER_TYPE = 2;
    private static final byte NULL_TYPE = 3;
    private final IsolatableSerializer<?>[] isolatableSerializers = new IsolatableSerializer[]{new StringValueSnapshotSerializer(), new BooleanValueSnapshotSerializer(), new ShortValueSnapshotSerializer(), new IntegerValueSnapshotSerializer(), new LongValueSnapshotSerializer(), new AttributeDefinitionSnapshotSerializer(), new IsolatedManagedValueSerializer(), new IsolatedImmutableManagedValueSerializer(), new FileValueSnapshotSerializer(), new NullValueSnapshotSerializer(), new IsolatedJavaSerializedValueSnapshotSerializer(), new IsolatedEnumValueSnapshotSerializer(), new IsolatedMapSerializer(), new IsolatedArraySerializer(), new IsolatedListSerializer(), new IsolatedSetSerializer(), new IsolatedPropertiesSerializer(), new IsolatedArrayOfPrimitiveSerializer()};
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ManagedFactoryRegistry managedFactoryRegistry;

    public IsolatableSerializerRegistry(ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ManagedFactoryRegistry managedFactoryRegistry) {
        super(false);
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.managedFactoryRegistry = managedFactoryRegistry;
        this.registerIsolatableSerializers();
    }

    private void registerIsolatableSerializers() {
        for (int i = 0; i < this.isolatableSerializers.length; ++i) {
            IsolatableSerializer<?> serializer = this.isolatableSerializers[i];
            assert (serializer.getSerializerIndex() == i);
            this.register(serializer.getIsolatableClass(), (Serializer)Cast.uncheckedCast(serializer));
        }
    }

    public static IsolatableSerializerRegistry create(ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ManagedFactoryRegistry managedFactoryRegistry) {
        return new IsolatableSerializerRegistry(classLoaderHierarchyHasher, managedFactoryRegistry);
    }

    public Isolatable<?> readIsolatable(Decoder decoder) throws Exception {
        byte serializerIndex = decoder.readByte();
        Class<?> isolatableClass = this.isolatableSerializers[serializerIndex].getIsolatableClass();
        return (Isolatable)this.build(isolatableClass).read(decoder);
    }

    public void writeIsolatable(Encoder encoder, Isolatable<?> isolatable) throws Exception {
        this.build(isolatable.getClass()).write(encoder, (Object)((Isolatable)Cast.uncheckedCast(isolatable)));
    }

    private void readIsolatableSequence(Decoder decoder, ImmutableCollection.Builder<Isolatable<?>> builder) throws Exception {
        int size = decoder.readInt();
        for (int i = 0; i < size; ++i) {
            builder.add(this.readIsolatable(decoder));
        }
    }

    private void writeIsolatableSequence(Encoder encoder, Collection<Isolatable<?>> elements) throws Exception {
        encoder.writeInt(elements.size());
        for (Isolatable<?> isolatable : elements) {
            this.writeIsolatable(encoder, isolatable);
        }
    }

    private Object readState(Decoder decoder) throws Exception {
        byte stateType = decoder.readByte();
        if (stateType == 3) {
            return null;
        }
        if (stateType == 0) {
            return this.readIsolatable(decoder);
        }
        if (stateType == 1) {
            return this.readArray(decoder);
        }
        String stateClassName = decoder.readString();
        Class<?> stateClass = IsolatableSerializerRegistry.fromClassName(stateClassName);
        this.useJavaSerialization(stateClass);
        return this.build(stateClass).read(decoder);
    }

    private void writeState(Encoder encoder, Object state) throws Exception {
        if (state == null) {
            encoder.writeByte((byte)3);
        } else if (state instanceof Isolatable) {
            encoder.writeByte((byte)0);
            this.writeIsolatable(encoder, (Isolatable)state);
        } else if (state.getClass().isArray()) {
            encoder.writeByte((byte)1);
            this.writeArray(encoder, state);
        } else {
            encoder.writeByte((byte)2);
            encoder.writeString((CharSequence)state.getClass().getName());
            this.useJavaSerialization(state.getClass());
            this.build(state.getClass()).write(encoder, Cast.uncheckedCast((Object)state));
        }
    }

    private Object readArray(Decoder decoder) throws Exception {
        String componentTypeName = decoder.readString();
        Class<?> componentType = IsolatableSerializerRegistry.fromClassName(componentTypeName);
        int length = decoder.readInt();
        Object state = Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            Array.set(state, i, this.readState(decoder));
        }
        return state;
    }

    private void writeArray(Encoder encoder, Object state) throws Exception {
        Class<?> componentType = state.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            throw new IllegalArgumentException("Unsupported state array type: " + state.getClass());
        }
        encoder.writeString((CharSequence)componentType.getName());
        Object[] array = (Object[])state;
        encoder.writeInt(array.length);
        for (Object o : array) {
            this.writeState(encoder, o);
        }
    }

    private static Class<?> fromClassName(String className) {
        return ClassLoaderUtils.classFromContextLoader((String)className);
    }

    private static abstract class IsolatableSerializer<T extends Isolatable<?>>
    implements Serializer<T> {
        private IsolatableSerializer() {
        }

        public abstract Class<T> getIsolatableClass();

        public abstract byte getSerializerIndex();

        protected abstract void serialize(Encoder var1, T var2) throws Exception;

        protected abstract T deserialize(Decoder var1) throws Exception;

        public final void write(Encoder encoder, T value) throws Exception {
            encoder.writeByte(this.getSerializerIndex());
            this.serialize(encoder, value);
        }

        public final T read(Decoder decoder) throws Exception {
            return this.deserialize(decoder);
        }
    }

    private static class StringValueSnapshotSerializer
    extends IsolatableSerializer<StringValueSnapshot> {
        private StringValueSnapshotSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, StringValueSnapshot value) throws Exception {
            encoder.writeString((CharSequence)value.getValue());
        }

        @Override
        protected StringValueSnapshot deserialize(Decoder decoder) throws Exception {
            return new StringValueSnapshot(decoder.readString());
        }

        @Override
        public Class<StringValueSnapshot> getIsolatableClass() {
            return StringValueSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 0;
        }
    }

    private static class BooleanValueSnapshotSerializer
    extends IsolatableSerializer<BooleanValueSnapshot> {
        private BooleanValueSnapshotSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, BooleanValueSnapshot value) throws Exception {
            encoder.writeBoolean(((Boolean)value.getValue()).booleanValue());
        }

        @Override
        protected BooleanValueSnapshot deserialize(Decoder decoder) throws Exception {
            return new BooleanValueSnapshot(Boolean.valueOf(decoder.readBoolean()));
        }

        @Override
        public Class<BooleanValueSnapshot> getIsolatableClass() {
            return BooleanValueSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 1;
        }
    }

    private static class ShortValueSnapshotSerializer
    extends IsolatableSerializer<ShortValueSnapshot> {
        private ShortValueSnapshotSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, ShortValueSnapshot value) throws Exception {
            encoder.writeInt((int)((Short)value.getValue()).shortValue());
        }

        @Override
        protected ShortValueSnapshot deserialize(Decoder decoder) throws Exception {
            return new ShortValueSnapshot(Short.valueOf((short)decoder.readInt()));
        }

        @Override
        public Class<ShortValueSnapshot> getIsolatableClass() {
            return ShortValueSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 2;
        }
    }

    private static class IntegerValueSnapshotSerializer
    extends IsolatableSerializer<IntegerValueSnapshot> {
        private IntegerValueSnapshotSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, IntegerValueSnapshot value) throws Exception {
            encoder.writeInt(((Integer)value.getValue()).intValue());
        }

        @Override
        protected IntegerValueSnapshot deserialize(Decoder decoder) throws Exception {
            return new IntegerValueSnapshot(Integer.valueOf(decoder.readInt()));
        }

        @Override
        public Class<IntegerValueSnapshot> getIsolatableClass() {
            return IntegerValueSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 3;
        }
    }

    private static class LongValueSnapshotSerializer
    extends IsolatableSerializer<LongValueSnapshot> {
        private LongValueSnapshotSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, LongValueSnapshot value) throws Exception {
            encoder.writeLong(((Long)value.getValue()).longValue());
        }

        @Override
        protected LongValueSnapshot deserialize(Decoder decoder) throws Exception {
            return new LongValueSnapshot(Long.valueOf(decoder.readLong()));
        }

        @Override
        public Class<LongValueSnapshot> getIsolatableClass() {
            return LongValueSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 4;
        }
    }

    private class AttributeDefinitionSnapshotSerializer
    extends IsolatableSerializer<AttributeDefinitionSnapshot> {
        private AttributeDefinitionSnapshotSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, AttributeDefinitionSnapshot value) throws Exception {
            encoder.writeString((CharSequence)((Attribute)value.getValue()).getType().getName());
            encoder.writeString((CharSequence)((Attribute)value.getValue()).getName());
        }

        @Override
        protected AttributeDefinitionSnapshot deserialize(Decoder decoder) throws Exception {
            String className = decoder.readString();
            Class attributeClass = IsolatableSerializerRegistry.fromClassName(className);
            String name = decoder.readString();
            return new AttributeDefinitionSnapshot(Attribute.of((String)name, (Class)attributeClass), IsolatableSerializerRegistry.this.classLoaderHierarchyHasher);
        }

        @Override
        public Class<AttributeDefinitionSnapshot> getIsolatableClass() {
            return AttributeDefinitionSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 5;
        }
    }

    private class IsolatedManagedValueSerializer
    extends IsolatableSerializer<IsolatedManagedValue> {
        private IsolatedManagedValueSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, IsolatedManagedValue value) throws Exception {
            encoder.writeInt(value.getFactoryId());
            encoder.writeString((CharSequence)value.getTargetType().getName());
            Isolatable state = (Isolatable)value.getState();
            IsolatableSerializerRegistry.this.writeIsolatable(encoder, state);
        }

        @Override
        protected IsolatedManagedValue deserialize(Decoder decoder) throws Exception {
            int factoryId = decoder.readInt();
            String publicClassName = decoder.readString();
            Class publicClass = IsolatableSerializerRegistry.fromClassName(publicClassName);
            Isolatable<?> state = IsolatableSerializerRegistry.this.readIsolatable(decoder);
            ManagedFactory factory = IsolatableSerializerRegistry.this.managedFactoryRegistry.lookup(factoryId);
            return new IsolatedManagedValue(publicClass, factory, state);
        }

        @Override
        public Class<IsolatedManagedValue> getIsolatableClass() {
            return IsolatedManagedValue.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 6;
        }
    }

    private class IsolatedImmutableManagedValueSerializer
    extends IsolatableSerializer<IsolatedImmutableManagedValue> {
        private IsolatedImmutableManagedValueSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, IsolatedImmutableManagedValue value) throws Exception {
            encoder.writeInt(((Managed)value.getValue()).getFactoryId());
            encoder.writeString((CharSequence)((Managed)value.getValue()).publicType().getName());
            IsolatableSerializerRegistry.this.writeState(encoder, ((Managed)value.getValue()).unpackState());
        }

        @Override
        protected IsolatedImmutableManagedValue deserialize(Decoder decoder) throws Exception {
            int factoryId = decoder.readInt();
            String publicClassName = decoder.readString();
            Class publicClass = IsolatableSerializerRegistry.fromClassName(publicClassName);
            ManagedFactory factory = IsolatableSerializerRegistry.this.managedFactoryRegistry.lookup(factoryId);
            Managed managed = (Managed)Cast.uncheckedCast((Object)factory.fromState(publicClass, IsolatableSerializerRegistry.this.readState(decoder)));
            assert (managed != null);
            return new IsolatedImmutableManagedValue(managed, IsolatableSerializerRegistry.this.managedFactoryRegistry);
        }

        @Override
        public Class<IsolatedImmutableManagedValue> getIsolatableClass() {
            return IsolatedImmutableManagedValue.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 7;
        }
    }

    private static class FileValueSnapshotSerializer
    extends IsolatableSerializer<FileValueSnapshot> {
        private FileValueSnapshotSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, FileValueSnapshot value) throws Exception {
            encoder.writeString((CharSequence)value.getValue());
        }

        @Override
        protected FileValueSnapshot deserialize(Decoder decoder) throws Exception {
            return new FileValueSnapshot(decoder.readString());
        }

        @Override
        public Class<FileValueSnapshot> getIsolatableClass() {
            return FileValueSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 8;
        }
    }

    private static class NullValueSnapshotSerializer
    extends IsolatableSerializer<NullValueSnapshot> {
        private NullValueSnapshotSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, NullValueSnapshot value) {
        }

        @Override
        protected NullValueSnapshot deserialize(Decoder decoder) {
            return NullValueSnapshot.INSTANCE;
        }

        @Override
        public Class<NullValueSnapshot> getIsolatableClass() {
            return NullValueSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 9;
        }
    }

    private static class IsolatedJavaSerializedValueSnapshotSerializer
    extends IsolatableSerializer<IsolatedJavaSerializedValueSnapshot> {
        private IsolatedJavaSerializedValueSnapshotSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, IsolatedJavaSerializedValueSnapshot value) throws Exception {
            encoder.writeString((CharSequence)value.getOriginalClass().getName());
            HashCode implementationHash = value.getImplementationHash();
            if (implementationHash == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                encoder.writeBinary(implementationHash.toByteArray());
            }
            encoder.writeBinary(value.getValue());
        }

        @Override
        protected IsolatedJavaSerializedValueSnapshot deserialize(Decoder decoder) throws Exception {
            String originalClassName = decoder.readString();
            Class originalClass = IsolatableSerializerRegistry.fromClassName(originalClassName);
            HashCode implementationHash = null;
            if (decoder.readBoolean()) {
                implementationHash = HashCode.fromBytes((byte[])decoder.readBinary());
            }
            byte[] serializedBytes = decoder.readBinary();
            return new IsolatedJavaSerializedValueSnapshot(implementationHash, serializedBytes, originalClass);
        }

        @Override
        public Class<IsolatedJavaSerializedValueSnapshot> getIsolatableClass() {
            return IsolatedJavaSerializedValueSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 10;
        }
    }

    public static class IsolatedEnumValueSnapshotSerializer
    extends IsolatableSerializer<IsolatedEnumValueSnapshot> {
        @Override
        protected void serialize(Encoder encoder, IsolatedEnumValueSnapshot value) throws Exception {
            encoder.writeString((CharSequence)value.getClassName());
            encoder.writeString((CharSequence)value.getName());
        }

        @Override
        protected IsolatedEnumValueSnapshot deserialize(Decoder decoder) throws Exception {
            String className = decoder.readString();
            String name = decoder.readString();
            Class enumClass = (Class)Cast.uncheckedCast((Object)IsolatableSerializerRegistry.fromClassName(className));
            return new IsolatedEnumValueSnapshot(Enum.valueOf((Class)Cast.uncheckedCast((Object)enumClass), name));
        }

        @Override
        public Class<IsolatedEnumValueSnapshot> getIsolatableClass() {
            return IsolatedEnumValueSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 11;
        }
    }

    private class IsolatedMapSerializer
    extends AbstractIsolatedMapSerializer<IsolatedMap> {
        private IsolatedMapSerializer() {
        }

        @Override
        public Class<IsolatedMap> getIsolatableClass() {
            return IsolatedMap.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 12;
        }

        @Override
        protected IsolatedMap getIsolatedObject(ImmutableList<MapEntrySnapshot<Isolatable<?>>> entries) {
            return new IsolatedMap(entries);
        }
    }

    private class IsolatedArraySerializer
    extends IsolatableSerializer<IsolatedArray> {
        private IsolatedArraySerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, IsolatedArray value) throws Exception {
            encoder.writeString((CharSequence)value.getArrayType().getName());
            IsolatableSerializerRegistry.this.writeIsolatableSequence(encoder, value.getElements());
        }

        @Override
        protected IsolatedArray deserialize(Decoder decoder) throws Exception {
            ImmutableList.Builder builder = ImmutableList.builder();
            Class arrayType = IsolatableSerializerRegistry.fromClassName(decoder.readString());
            IsolatableSerializerRegistry.this.readIsolatableSequence(decoder, (ImmutableCollection.Builder)builder);
            return new IsolatedArray(builder.build(), arrayType);
        }

        @Override
        public Class<IsolatedArray> getIsolatableClass() {
            return IsolatedArray.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 13;
        }
    }

    private class IsolatedListSerializer
    extends IsolatableSerializer<IsolatedList> {
        private IsolatedListSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, IsolatedList value) throws Exception {
            IsolatableSerializerRegistry.this.writeIsolatableSequence(encoder, value.getElements());
        }

        @Override
        protected IsolatedList deserialize(Decoder decoder) throws Exception {
            ImmutableList.Builder builder = ImmutableList.builder();
            IsolatableSerializerRegistry.this.readIsolatableSequence(decoder, (ImmutableCollection.Builder)builder);
            return new IsolatedList(builder.build());
        }

        @Override
        public Class<IsolatedList> getIsolatableClass() {
            return IsolatedList.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 14;
        }
    }

    private class IsolatedSetSerializer
    extends IsolatableSerializer<IsolatedSet> {
        private IsolatedSetSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, IsolatedSet value) throws Exception {
            IsolatableSerializerRegistry.this.writeIsolatableSequence(encoder, (Collection)value.getElements());
        }

        @Override
        protected IsolatedSet deserialize(Decoder decoder) throws Exception {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            IsolatableSerializerRegistry.this.readIsolatableSequence(decoder, (ImmutableCollection.Builder)builder);
            return new IsolatedSet(builder.build());
        }

        @Override
        public Class<IsolatedSet> getIsolatableClass() {
            return IsolatedSet.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 15;
        }
    }

    private class IsolatedPropertiesSerializer
    extends AbstractIsolatedMapSerializer<IsolatedProperties> {
        private IsolatedPropertiesSerializer() {
        }

        @Override
        protected IsolatedProperties getIsolatedObject(ImmutableList<MapEntrySnapshot<Isolatable<?>>> entries) {
            return new IsolatedProperties(entries);
        }

        @Override
        public Class<IsolatedProperties> getIsolatableClass() {
            return IsolatedProperties.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 16;
        }
    }

    @NonNullApi
    private static class IsolatedArrayOfPrimitiveSerializer
    extends IsolatableSerializer<ArrayOfPrimitiveValueSnapshot> {
        private IsolatedArrayOfPrimitiveSerializer() {
        }

        @Override
        protected void serialize(Encoder encoder, ArrayOfPrimitiveValueSnapshot value) throws Exception {
            value.encode(encoder);
        }

        @Override
        protected ArrayOfPrimitiveValueSnapshot deserialize(Decoder decoder) throws Exception {
            return ArrayOfPrimitiveValueSnapshot.decode((Decoder)decoder);
        }

        @Override
        public Class<ArrayOfPrimitiveValueSnapshot> getIsolatableClass() {
            return ArrayOfPrimitiveValueSnapshot.class;
        }

        @Override
        public byte getSerializerIndex() {
            return 17;
        }
    }

    private abstract class AbstractIsolatedMapSerializer<T extends AbstractIsolatedMap<?>>
    extends IsolatableSerializer<T> {
        private AbstractIsolatedMapSerializer() {
        }

        protected abstract T getIsolatedObject(ImmutableList<MapEntrySnapshot<Isolatable<?>>> var1);

        @Override
        protected void serialize(Encoder encoder, T value) throws Exception {
            ImmutableList entrySnapshots = value.getEntries();
            encoder.writeInt(entrySnapshots.size());
            for (MapEntrySnapshot entrySnapshot : entrySnapshots) {
                IsolatableSerializerRegistry.this.writeIsolatable(encoder, (Isolatable)entrySnapshot.getKey());
                IsolatableSerializerRegistry.this.writeIsolatable(encoder, (Isolatable)entrySnapshot.getValue());
            }
        }

        @Override
        protected T deserialize(Decoder decoder) throws Exception {
            int size = decoder.readInt();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                Isolatable<?> key = IsolatableSerializerRegistry.this.readIsolatable(decoder);
                Isolatable<?> value = IsolatableSerializerRegistry.this.readIsolatable(decoder);
                MapEntrySnapshot entry = new MapEntrySnapshot(key, value);
                builder.add((Object)entry);
            }
            return this.getIsolatedObject(builder.build());
        }
    }
}

