/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.codecs.dm;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.TransformedArtifactSet;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.serialize.codecs.dm.FixedFileArtifactSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lorg/gradle/internal/serialize/codecs/dm/CollectingArtifactVisitor;", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ArtifactVisitor;", "()V", "artifacts", "", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ResolvableArtifact;", "getArtifacts", "()Ljava/util/Set;", "elements", "", "", "getElements", "()Ljava/util/List;", "endVisitCollection", "", "source", "Lorg/gradle/api/internal/file/FileCollectionInternal$Source;", "prepareForVisit", "Lorg/gradle/api/internal/file/FileCollectionStructureVisitor$VisitType;", "requireArtifactFiles", "", "visitArtifact", "variantName", "Lorg/gradle/internal/DisplayName;", "variantAttributes", "Lorg/gradle/api/attributes/AttributeContainer;", "capabilities", "Lorg/gradle/internal/component/external/model/ImmutableCapabilities;", "artifact", "visitFailure", "failure", "", "dependency-management-serialization-codecs"})
final class CollectingArtifactVisitor
implements ArtifactVisitor {
    @NotNull
    private final List<Object> elements = new ArrayList();
    @NotNull
    private final Set<ResolvableArtifact> artifacts = new LinkedHashSet();

    @NotNull
    public final List<Object> getElements() {
        return this.elements;
    }

    @NotNull
    public final Set<ResolvableArtifact> getArtifacts() {
        return this.artifacts;
    }

    @NotNull
    public FileCollectionStructureVisitor.VisitType prepareForVisit(@NotNull FileCollectionInternal.Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source instanceof TransformedArtifactSet ? FileCollectionStructureVisitor.VisitType.NoContents : FileCollectionStructureVisitor.VisitType.Visit;
    }

    public boolean requireArtifactFiles() {
        return true;
    }

    public void visitFailure(@NotNull Throwable failure) {
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        this.elements.add(failure);
    }

    public void visitArtifact(@NotNull DisplayName variantName, @NotNull AttributeContainer variantAttributes, @NotNull ImmutableCapabilities capabilities, @NotNull ResolvableArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)variantAttributes, (String)"variantAttributes");
        Intrinsics.checkNotNullParameter((Object)capabilities, (String)"capabilities");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (this.artifacts.add(artifact)) {
            ComponentArtifactIdentifier componentArtifactIdentifier = artifact.getId();
            Intrinsics.checkNotNullExpressionValue((Object)componentArtifactIdentifier, (String)"artifact.id");
            File file = artifact.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifact.file");
            this.elements.add(new FixedFileArtifactSpec(componentArtifactIdentifier, variantAttributes, capabilities, variantName, file));
        }
    }

    public void endVisitCollection(@NotNull FileCollectionInternal.Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source instanceof TransformedArtifactSet) {
            this.elements.add(source);
        }
    }
}

