/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionByAttributesException;
import org.gradle.internal.component.resolution.failure.formatting.CapabilitiesDescriber;
import org.gradle.internal.component.resolution.failure.type.NoVariantsWithMatchingCapabilitiesFailure;

public abstract class NoVariantsWithMatchingCapabilitiesFailureDescriber
extends AbstractResolutionFailureDescriber<NoVariantsWithMatchingCapabilitiesFailure> {
    public VariantSelectionByAttributesException describeFailure(NoVariantsWithMatchingCapabilitiesFailure failure) {
        String message = NoVariantsWithMatchingCapabilitiesFailureDescriber.buildFailureMsg(failure);
        List<String> resolutions = this.buildResolutions(this.suggestReviewAlgorithm());
        return new VariantSelectionByAttributesException(message, failure, resolutions);
    }

    private static String buildFailureMsg(NoVariantsWithMatchingCapabilitiesFailure failure) {
        StringBuilder sb = new StringBuilder();
        Set<CapabilitySelector> capabilities = failure.getCapabilitySelectors();
        if (capabilities.size() == 1) {
            sb.append("Unable to find a variant with the requested capability: ");
            sb.append(capabilities.iterator().next().getDisplayName());
        } else {
            sb.append("Unable to find a variant with the requested capabilities: ");
            sb.append("[").append(capabilities.stream().map(Describable::getDisplayName).collect(Collectors.joining(", "))).append("]");
        }
        sb.append(":\n");
        for (ResolutionCandidateAssessor.AssessedCandidate candidate : failure.getCandidates()) {
            sb.append("   - Variant '").append(candidate.getDisplayName()).append("' provides ");
            sb.append(CapabilitiesDescriber.describeCapabilities(candidate.getCandidateCapabilities().asSet())).append("\n");
        }
        return sb.toString();
    }
}

