/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "extendThrowableFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getExtendThrowableFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "throwableConstructors", "", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "newThrowableFunction", "undefinedValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "extractThrowableArguments", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$ThrowableArguments;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "ThrowableArguments", "Transformer", "backend.js"})
public final class ThrowableLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrSimpleFunctionSymbol extendThrowableFunction;
    @NotNull
    private final List<IrConstructorSymbol> throwableConstructors;
    @NotNull
    private final IrSimpleFunctionSymbol newThrowableFunction;

    public ThrowableLowering(@NotNull JsIrBackendContext context, @NotNull IrSimpleFunctionSymbol extendThrowableFunction) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)extendThrowableFunction, (String)"extendThrowableFunction");
        this.context = context;
        this.extendThrowableFunction = extendThrowableFunction;
        this.throwableConstructors = this.context.getThrowableConstructors();
        this.newThrowableFunction = this.context.getNewThrowableSymbol();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSimpleFunctionSymbol getExtendThrowableFunction() {
        return this.extendThrowableFunction;
    }

    private final IrExpression undefinedValue() {
        return IrJsUtilsKt.getVoid(this.context);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrClass enclosingClass = IrUtilsKt.getParentClassOrNull(container);
        boolean bl = false;
        IrClass irClass = enclosingClass;
        irBody.transformChildren(new Transformer(), irClass != null ? (IrElement)irClass : (IrElement)IrUtilsKt.getFile(container));
    }

    private final ThrowableArguments extractThrowableArguments(IrFunctionAccessExpression $this$extractThrowableArguments) {
        ThrowableArguments throwableArguments;
        switch ($this$extractThrowableArguments.getValueArgumentsCount()) {
            case 0: {
                throwableArguments = new ThrowableArguments(this.undefinedValue(), this.undefinedValue());
                break;
            }
            case 2: {
                IrExpression irExpression = $this$extractThrowableArguments.getValueArgument(0);
                Intrinsics.checkNotNull((Object)irExpression);
                IrExpression irExpression2 = $this$extractThrowableArguments.getValueArgument(1);
                Intrinsics.checkNotNull((Object)irExpression2);
                throwableArguments = new ThrowableArguments(irExpression, irExpression2);
                break;
            }
            default: {
                IrExpression irExpression = $this$extractThrowableArguments.getValueArgument(0);
                Intrinsics.checkNotNull((Object)irExpression);
                IrExpression arg = irExpression;
                IrValueParameter parameter = ((IrFunctionSymbol)$this$extractThrowableArguments.getSymbol()).getOwner().getValueParameters().get(0);
                if (IrTypePredicatesKt.isNullableString(parameter.getType())) {
                    throwableArguments = new ThrowableArguments(arg, this.undefinedValue());
                    break;
                }
                boolean bl = IrTypeUtilsKt.isThrowable(IrTypesKt.makeNotNull(parameter.getType()));
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                throwableArguments = new ThrowableArguments(this.undefinedValue(), arg);
            }
        }
        return throwableArguments;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$ThrowableArguments;", "", "message", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "cause", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getMessage", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getCause", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.js"})
    public static final class ThrowableArguments {
        @NotNull
        private final IrExpression message;
        @NotNull
        private final IrExpression cause;

        public ThrowableArguments(@NotNull IrExpression message, @NotNull IrExpression cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            this.message = message;
            this.cause = cause;
        }

        @NotNull
        public final IrExpression getMessage() {
            return this.message;
        }

        @NotNull
        public final IrExpression getCause() {
            return this.cause;
        }

        @NotNull
        public final IrExpression component1() {
            return this.message;
        }

        @NotNull
        public final IrExpression component2() {
            return this.cause;
        }

        @NotNull
        public final ThrowableArguments copy(@NotNull IrExpression message, @NotNull IrExpression cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            return new ThrowableArguments(message, cause);
        }

        public static /* synthetic */ ThrowableArguments copy$default(ThrowableArguments throwableArguments, IrExpression irExpression, IrExpression irExpression2, int n, Object object) {
            if ((n & 1) != 0) {
                irExpression = throwableArguments.message;
            }
            if ((n & 2) != 0) {
                irExpression2 = throwableArguments.cause;
            }
            return throwableArguments.copy(irExpression, irExpression2);
        }

        @NotNull
        public String toString() {
            return "ThrowableArguments(message=" + this.message + ", cause=" + this.cause + ')';
        }

        public int hashCode() {
            int result2 = this.message.hashCode();
            result2 = result2 * 31 + this.cause.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowableArguments)) {
                return false;
            }
            ThrowableArguments throwableArguments = (ThrowableArguments)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)throwableArguments.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cause, (Object)throwableArguments.cause);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering;)V", "anyConstructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "data", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "backend.js"})
    public final class Transformer
    implements IrElementTransformer<IrDeclarationParent> {
        @NotNull
        private final IrConstructorSymbol anyConstructor;

        public Transformer() {
            this.anyConstructor = (IrConstructorSymbol)SequencesKt.first(IrUtilsKt.getConstructors(ThrowableLowering.this.getContext().getIrBuiltIns().getAnyClass()));
        }

        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitClass(this, declaration, declaration);
        }

        @Override
        @NotNull
        public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull IrDeclarationParent data) {
            IrCallImpl irCallImpl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            expression2.transformChildren(this, data);
            if (!ThrowableLowering.this.throwableConstructors.contains(expression2.getSymbol())) {
                return expression2;
            }
            ThrowableArguments throwableArguments = ThrowableLowering.this.extractThrowableArguments(expression2);
            IrExpression messageArg = throwableArguments.component1();
            IrExpression causeArg = throwableArguments.component2();
            IrConstructorCall irConstructorCall = expression2;
            ThrowableLowering throwableLowering = ThrowableLowering.this;
            IrConstructorCall $this$visitConstructorCall_u24lambda_u241 = irConstructorCall;
            boolean bl = false;
            int n = $this$visitConstructorCall_u24lambda_u241.getStartOffset();
            int n2 = $this$visitConstructorCall_u24lambda_u241.getEndOffset();
            IrType irType = $this$visitConstructorCall_u24lambda_u241.getType();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = throwableLowering.newThrowableFunction;
            IrCallImpl it = irCallImpl = new IrCallImpl(n, n2, irType, irSimpleFunctionSymbol, 0, 2, null, null, 192, null);
            boolean bl2 = false;
            it.putValueArgument(0, messageArg);
            it.putValueArgument(1, causeArg);
            return irCallImpl;
        }

        @Override
        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrDeclarationParent data) {
            IrExpression irExpression;
            IrCallImpl irCallImpl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            expression2.transformChildren(this, data);
            if (!ThrowableLowering.this.throwableConstructors.contains(expression2.getSymbol())) {
                return (IrExpression)expression2;
            }
            ThrowableArguments throwableArguments = ThrowableLowering.this.extractThrowableArguments((IrFunctionAccessExpression)expression2);
            IrExpression messageArg = throwableArguments.component1();
            IrExpression causeArg = throwableArguments.component2();
            IrClass klass = (IrClass)data;
            int n = expression2.getStartOffset();
            int n2 = expression2.getEndOffset();
            IrValueParameter irValueParameter = klass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            IrGetValueImpl thisReceiver = BuildersKt.IrGetValueImpl$default(n, n2, irValueParameter.getSymbol(), null, 8, null);
            Object[] objectArray = expression2;
            ThrowableLowering throwableLowering = ThrowableLowering.this;
            Object[] $this$visitDelegatingConstructorCall_u24lambda_u243 = objectArray;
            boolean bl = false;
            int n3 = $this$visitDelegatingConstructorCall_u24lambda_u243.getStartOffset();
            int n4 = $this$visitDelegatingConstructorCall_u24lambda_u243.getEndOffset();
            IrType irType = $this$visitDelegatingConstructorCall_u24lambda_u243.getType();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = throwableLowering.getExtendThrowableFunction();
            IrCallImpl it = irCallImpl = new IrCallImpl(n3, n4, irType, irSimpleFunctionSymbol, 0, 3, null, null, 192, null);
            boolean bl2 = false;
            it.putValueArgument(0, thisReceiver);
            it.putValueArgument(1, messageArg);
            it.putValueArgument(2, causeArg);
            IrCallImpl expressionReplacement = irCallImpl;
            if (!ThrowableLowering.this.getContext().getEs6mode()) {
                irExpression = expressionReplacement;
            } else {
                objectArray = new IrFunctionAccessExpression[]{new IrDelegatingConstructorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), ThrowableLowering.this.getContext().getIrBuiltIns().getAnyType(), this.anyConstructor, 0, 0), expressionReplacement};
                irExpression = JsIrBuilder.INSTANCE.buildComposite(ThrowableLowering.this.getContext().getIrBuiltIns().getUnitType(), CollectionsKt.listOf((Object[])objectArray));
            }
            return irExpression;
        }

        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitField(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        @NotNull
        public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitScript(@NotNull IrScript declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitScript(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        @NotNull
        public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitReturnableBlock(@NotNull IrReturnableBlock expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitReturnableBlock(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
        }

        @Override
        @NotNull
        public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        @NotNull
        public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitConst(@NotNull IrConst<?> expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitLoop(@NotNull IrLoop loop, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitLoop(this, loop, data);
        }

        @Override
        @NotNull
        public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop, data);
        }

        @Override
        @NotNull
        public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop, data);
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        @NotNull
        public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        @NotNull
        public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        @NotNull
        public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
        }
    }
}

