/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import javax.annotation.Nullable;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.steps.IncrementalCachingContext;
import org.gradle.internal.execution.steps.IncrementalChangesContext;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.ValidationFinishedContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveInputChangesStep<C extends IncrementalCachingContext, R extends Result>
implements Step<C, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveInputChangesStep.class);
    private final Step<? super InputChangesContext, ? extends R> delegate;

    public ResolveInputChangesStep(Step<? super InputChangesContext, ? extends R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        return this.delegate.execute(work, new InputChangesContext((ValidationFinishedContext)context, ResolveInputChangesStep.determineInputChanges(work, context), ((IncrementalCachingContext)context).getCachingState()));
    }

    @Nullable
    private static InputChangesInternal determineInputChanges(UnitOfWork work, IncrementalChangesContext context) {
        if (work.getExecutionBehavior() == UnitOfWork.ExecutionBehavior.NON_INCREMENTAL) {
            return null;
        }
        ExecutionStateChanges changes = context.getChanges().orElseThrow(() -> new IllegalStateException("Changes are not tracked, unable determine incremental changes."));
        InputChangesInternal inputChanges = changes.createInputChanges();
        if (!inputChanges.isIncremental()) {
            LOGGER.info("The input changes require a full rebuild for incremental {}.", (Object)work.getDisplayName());
        }
        return inputChanges;
    }
}

