/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.BuildScopeListenerRegistrationListener;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.execution.TaskExecutionAccessListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.execution.ExecutionAccessListener;
import org.gradle.internal.InternalListener;
import org.gradle.internal.buildoption.FeatureFlag;
import org.gradle.internal.buildoption.FeatureFlags;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.cc.impl.DeprecatedFeaturesListenerKt;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.service.scopes.ListenerService;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ListenerService
@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\"\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016J\"\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016J\"\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010#\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002J\u001a\u0010$\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gradle/internal/cc/impl/DeprecatedFeaturesListener;", "Lorg/gradle/api/internal/BuildScopeListenerRegistrationListener;", "Lorg/gradle/api/internal/tasks/execution/TaskExecutionAccessListener;", "Lorg/gradle/execution/ExecutionAccessListener;", "featureFlags", "Lorg/gradle/internal/buildoption/FeatureFlags;", "buildModelParameters", "Lorg/gradle/internal/buildtree/BuildModelParameters;", "(Lorg/gradle/internal/buildoption/FeatureFlags;Lorg/gradle/internal/buildtree/BuildModelParameters;)V", "disallowedAtExecutionInjectedServiceAccessed", "", "injectedServiceType", "Ljava/lang/Class;", "getterName", "", "consumer", "nagUserAbout", "action", "upgradeGuideMajorVersion", "", "upgradeGuideSection", "onBuildScopeListenerRegistration", "listener", "", "invocationDescription", "invocationSource", "onConventionAccess", "task", "Lorg/gradle/api/internal/TaskInternal;", "runningTask", "onProjectAccess", "onTaskDependenciesAccess", "shouldNag", "", "shouldNagAbout", "shouldNagFor", "shouldReportInContext", "throwUnsupported", "", "reason", "configuration-cache"})
public final class DeprecatedFeaturesListener
implements BuildScopeListenerRegistrationListener,
TaskExecutionAccessListener,
ExecutionAccessListener {
    @NotNull
    private final FeatureFlags featureFlags;
    @NotNull
    private final BuildModelParameters buildModelParameters;

    public DeprecatedFeaturesListener(@NotNull FeatureFlags featureFlags, @NotNull BuildModelParameters buildModelParameters) {
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        Intrinsics.checkNotNullParameter((Object)buildModelParameters, (String)"buildModelParameters");
        this.featureFlags = featureFlags;
        this.buildModelParameters = buildModelParameters;
    }

    public void onBuildScopeListenerRegistration(@NotNull Object listener2, @NotNull String invocationDescription, @NotNull Object invocationSource) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)invocationSource, (String)"invocationSource");
        if (Intrinsics.areEqual((Object)invocationDescription, (Object)"Gradle.useLogger") && !(listener2 instanceof InternalListener)) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(Gradle.class, (String)"useLogger(Object)").willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_use_logger")).nagUser();
        } else if (this.shouldNagAbout(listener2)) {
            this.nagUserAbout("Listener registration using " + invocationDescription + "()", 7, "task_execution_events");
        }
    }

    public void onProjectAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.shouldNagFor(task, runningTask)) {
            this.nagUserAbout("Invocation of " + invocationDescription + " at execution time", 7, "task_project");
        }
    }

    public void onTaskDependenciesAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.shouldNagFor(task, runningTask)) {
            this.throwUnsupported("Invocation of " + invocationDescription + " at execution time");
            throw new KotlinNothingValueException();
        }
    }

    public void onConventionAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.shouldNagFor(task, runningTask)) {
            this.nagUserAbout("Invocation of " + invocationDescription + " at execution time", 8, "task_convention");
        }
    }

    public void disallowedAtExecutionInjectedServiceAccessed(@NotNull Class<?> injectedServiceType, @NotNull String getterName, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter(injectedServiceType, (String)"injectedServiceType");
        Intrinsics.checkNotNullParameter((Object)getterName, (String)"getterName");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (this.shouldNag()) {
            this.throwUnsupported("Invocation of " + injectedServiceType + " at execution time");
            throw new KotlinNothingValueException();
        }
    }

    private final void nagUserAbout(String action, int upgradeGuideMajorVersion, String upgradeGuideSection) {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateAction((String)action).willBecomeAnErrorInGradle9().withUpgradeGuideSection(upgradeGuideMajorVersion, upgradeGuideSection)).nagUser();
    }

    private final boolean shouldNagFor(TaskInternal task, TaskInternal runningTask) {
        return this.shouldNag() && this.shouldReportInContext(task, runningTask);
    }

    private final boolean shouldNag() {
        return !this.buildModelParameters.isConfigurationCache() && this.featureFlags.isEnabled((FeatureFlag)FeaturePreviews.Feature.STABLE_CONFIGURATION_CACHE);
    }

    private final boolean shouldNagAbout(Object listener2) {
        return this.shouldNag() && !DeprecatedFeaturesListenerKt.isSupportedListener(listener2);
    }

    private final boolean shouldReportInContext(TaskInternal task, TaskInternal runningTask) {
        return runningTask == null || task == runningTask;
    }

    private final Void throwUnsupported(String reason) {
        throw new UnsupportedOperationException(reason + " is unsupported with the STABLE_CONFIGURATION_CACHE feature preview.");
    }
}

