/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.tasks.internal.XcodeSchemeFile;
import org.gradle.internal.serialization.Cached;
import org.gradle.plugins.ide.api.XmlGeneratorTask;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class GenerateSchemeFileTask
extends XmlGeneratorTask<XcodeSchemeFile> {
    private transient DefaultXcodeProject xcodeProject;
    private final Cached<SchemeFileSpec> spec = Cached.of(this::calculateSpec);

    @Internal
    public XcodeProject getXcodeProject() {
        return this.xcodeProject;
    }

    public void setXcodeProject(XcodeProject xcodeProject) {
        this.xcodeProject = (DefaultXcodeProject)xcodeProject;
    }

    private SchemeFileSpec calculateSpec() {
        ArrayList<TargetSpec> targets = new ArrayList<TargetSpec>();
        for (XcodeTarget target : this.xcodeProject.getTargets()) {
            targets.add(new TargetSpec(target.getName(), target.getId(), target.getProductName(), target.isRunnable(), target.isUnitTest(), (Provider<String>)target.getDefaultConfigurationName()));
        }
        return new SchemeFileSpec(this.getProject().getName(), targets);
    }

    protected void configure(XcodeSchemeFile schemeFile) {
        SchemeFileSpec spec = (SchemeFileSpec)this.spec.get();
        this.configureBuildAction(spec, schemeFile.getBuildAction());
        this.configureTestAction(spec, schemeFile.getTestAction());
        this.configureLaunchAction(spec, schemeFile.getLaunchAction());
        this.configureArchiveAction(schemeFile.getArchiveAction());
        this.configureAnalyzeAction(schemeFile.getAnalyzeAction());
        this.configureProfileAction(schemeFile.getProfileAction());
    }

    private void configureBuildAction(SchemeFileSpec spec, XcodeSchemeFile.BuildAction action) {
        for (TargetSpec xcodeTarget : spec.targets) {
            action.entry((Action<XcodeSchemeFile.BuildActionEntry>)((Action)buildActionEntry -> {
                buildActionEntry.setBuildForAnalysing(!xcodeTarget.unitTest);
                buildActionEntry.setBuildForArchiving(!xcodeTarget.unitTest);
                buildActionEntry.setBuildForProfiling(!xcodeTarget.unitTest);
                buildActionEntry.setBuildForRunning(!xcodeTarget.unitTest);
                buildActionEntry.setBuildForTesting(xcodeTarget.unitTest);
                buildActionEntry.setBuildableReference(this.toBuildableReference(spec, xcodeTarget));
            }));
        }
    }

    private void configureTestAction(SchemeFileSpec spec, XcodeSchemeFile.TestAction action) {
        action.setBuildConfiguration("Debug");
        for (TargetSpec xcodeTarget : spec.targets) {
            if (!xcodeTarget.unitTest) continue;
            action.setBuildConfiguration("__GradleTestRunner_Debug");
            action.entry((Action<XcodeSchemeFile.TestableEntry>)((Action)testableEntry -> {
                testableEntry.setSkipped(false);
                XcodeSchemeFile.BuildableReference buildableReference = this.toBuildableReference(spec, xcodeTarget);
                testableEntry.setBuildableReference(buildableReference);
            }));
        }
    }

    private void configureLaunchAction(SchemeFileSpec spec, XcodeSchemeFile.LaunchAction action) {
        block1: {
            action.setBuildConfiguration((String)spec.targets.iterator().next().defaultConfigurationName.get());
            Iterator<TargetSpec> iterator = spec.targets.iterator();
            if (!iterator.hasNext()) break block1;
            TargetSpec xcodeTarget = iterator.next();
            XcodeSchemeFile.BuildableReference buildableReference = this.toBuildableReference(spec, xcodeTarget);
            if (xcodeTarget.runnable) {
                action.setBuildableProductRunnable(buildableReference);
            }
            action.setBuildableReference(buildableReference);
        }
    }

    private void configureArchiveAction(XcodeSchemeFile.ArchiveAction action) {
        action.setBuildConfiguration("Debug");
    }

    private void configureProfileAction(XcodeSchemeFile.ProfileAction action) {
        action.setBuildConfiguration("Debug");
    }

    private void configureAnalyzeAction(XcodeSchemeFile.AnalyzeAction action) {
        action.setBuildConfiguration("Debug");
    }

    public File getInputFile() {
        return null;
    }

    protected XcodeSchemeFile create() {
        return new XcodeSchemeFile(this.getXmlTransformer());
    }

    private XcodeSchemeFile.BuildableReference toBuildableReference(SchemeFileSpec spec, TargetSpec target) {
        XcodeSchemeFile.BuildableReference buildableReference = new XcodeSchemeFile.BuildableReference();
        buildableReference.setBuildableIdentifier("primary");
        buildableReference.setBlueprintIdentifier(target.id);
        buildableReference.setBuildableName(target.productName);
        buildableReference.setBlueprintName(target.name);
        buildableReference.setContainerRelativePath(spec.projectName + ".xcodeproj");
        return buildableReference;
    }

    private static class SchemeFileSpec {
        final String projectName;
        final List<TargetSpec> targets;

        public SchemeFileSpec(String projectName, List<TargetSpec> targets) {
            this.projectName = projectName;
            this.targets = targets;
        }
    }

    private static class TargetSpec {
        final String name;
        final boolean runnable;
        final boolean unitTest;
        final String id;
        final String productName;
        final Provider<String> defaultConfigurationName;

        public TargetSpec(String name, String id, String productName, boolean runnable, boolean unitTest, Provider<String> defaultConfigurationName) {
            this.name = name;
            this.runnable = runnable;
            this.unitTest = unitTest;
            this.id = id;
            this.productName = productName;
            this.defaultConfigurationName = defaultConfigurationName;
        }
    }
}

