/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflictFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.capabilities.CapabilityInternal;

public class DefaultCapabilitiesConflictHandler
implements CapabilitiesConflictHandler {
    private final List<CapabilitiesConflictHandler.Resolver> resolvers;
    private final Map<String, ConflictedNodesTracker> capabilityWithoutVersionToTracker = new HashMap<String, ConflictedNodesTracker>();
    private final Deque<String> conflicts = new ArrayDeque<String>();

    public DefaultCapabilitiesConflictHandler(List<CapabilitiesConflictHandler.Resolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public PotentialConflict registerCandidate(CapabilitiesConflictHandler.Candidate candidate) {
        CapabilityInternal capability = candidate.getCapability();
        ConflictedNodesTracker tracker = this.capabilityWithoutVersionToTracker.computeIfAbsent(capability.getCapabilityId(), k -> new ConflictedNodesTracker(capability));
        tracker.removeIf(n -> !n.isSelected());
        tracker.addAll(candidate.getImplicitCapabilityProviders());
        NodeState node = candidate.getNode();
        if (tracker.add(node) && tracker.hasConflictedNodes()) {
            ModuleIdentifier rootId = null;
            for (NodeState ns : tracker) {
                if (!ns.isRoot()) continue;
                rootId = ns.getComponent().getId().getModule();
            }
            final Set candidatesForConflict = tracker.getConflictedNodesCopy();
            if (rootId != null && candidatesForConflict.size() > 1) {
                ModuleIdentifier rootModuleId = rootId;
                candidatesForConflict.removeIf(n -> !n.isRoot() && n.getComponent().getId().getModule().equals(rootModuleId));
            }
            if (candidatesForConflict.size() > 1 && !candidatesForConflict.stream().allMatch(n -> n.getComponent().isRejected())) {
                if (tracker.createOrUpdateConflict(candidatesForConflict)) {
                    this.conflicts.add(tracker.capabilityId);
                }
                return new PotentialConflict(){

                    @Override
                    public void withParticipatingModules(Action<ModuleIdentifier> action) {
                        for (NodeState node : candidatesForConflict) {
                            action.execute((Object)node.getComponent().getId().getModule());
                        }
                    }

                    @Override
                    public boolean conflictExists() {
                        return true;
                    }
                };
            }
        }
        return PotentialConflictFactory.noConflict();
    }

    @Override
    public boolean hasConflicts() {
        return !this.conflicts.isEmpty();
    }

    @Override
    public void resolveNextConflict(Action<ConflictResolutionResult> resolutionAction) {
        String capabilityInConflict = this.conflicts.remove();
        ConflictedNodesTracker conflictTracker = this.capabilityWithoutVersionToTracker.get(capabilityInConflict);
        CapabilityConflict conflict = conflictTracker.updateClearAndReturnConflict();
        if (!conflict.isValidConflict()) {
            return;
        }
        Details details = new Details(conflict);
        for (CapabilitiesConflictHandler.Resolver resolver : this.resolvers) {
            resolver.resolve(details);
            if (!details.hasResult()) continue;
            resolutionAction.execute((Object)details);
            if (conflict.nodes.size() > 1) {
                assert (details.reason != null);
                details.getSelected().addCause(ComponentSelectionReasons.CONFLICT_RESOLUTION.withDescription(details.reason));
            }
            return;
        }
        Collection<? extends Capability> capabilityVersions = details.getCapabilityVersions();
        for (Capability capability : capabilityVersions) {
            Collection<? extends CapabilitiesConflictHandler.CandidateDetails> candidates = details.getCandidates(capability);
            if (candidates.isEmpty()) continue;
            for (CapabilitiesConflictHandler.CandidateDetails candidateDetails : candidates) {
                candidateDetails.reject();
            }
        }
    }

    @Override
    public boolean hasSeenNonDefaultCapabilityExplicitly(CapabilityInternal capability) {
        return this.capabilityWithoutVersionToTracker.containsKey(capability.getCapabilityId());
    }

    public static CapabilitiesConflictHandler.Candidate candidate(NodeState node, CapabilityInternal capability, Collection<NodeState> implicitCapabilityProviders) {
        return new Candidate(node, capability, implicitCapabilityProviders);
    }

    private static class ConflictedNodesTracker
    implements Iterable<NodeState> {
        private final String group;
        private final String name;
        private final String capabilityId;
        private final List<Set<NodeState>> previousConflictedNodes = new ArrayList<Set<NodeState>>();
        private Set<NodeState> currentConflictedNodes = new LinkedHashSet<NodeState>();
        private CapabilityConflict pendingConflict;

        private ConflictedNodesTracker(CapabilityInternal capability) {
            this.group = capability.getGroup();
            this.name = capability.getName();
            this.capabilityId = capability.getCapabilityId();
        }

        private CapabilityConflict updateClearAndReturnConflict() {
            CapabilityConflict currentConflict = this.pendingConflict;
            this.pendingConflict = null;
            LinkedHashSet<NodeState> selectedNodes = new LinkedHashSet<NodeState>();
            boolean didFilter = false;
            for (NodeState node : currentConflict.nodes) {
                if (node.isSelected() || !currentConflict.nodeToDependentNodes.isEmpty() && currentConflict.nodeToDependentNodes.getOrDefault(node, Collections.emptySet()).stream().anyMatch(NodeState::isSelected)) {
                    selectedNodes.add(node);
                    continue;
                }
                didFilter = true;
            }
            if (didFilter) {
                this.previousConflictedNodes.add(this.currentConflictedNodes);
                this.currentConflictedNodes = selectedNodes;
                return currentConflict.withDifferentNodes(selectedNodes);
            }
            return currentConflict;
        }

        private boolean removeIf(Predicate<? super NodeState> pre) {
            return this.currentConflictedNodes.removeIf(pre);
        }

        private void addAll(Collection<NodeState> extraNodes) {
            this.currentConflictedNodes.addAll(extraNodes);
        }

        private boolean add(NodeState node) {
            return this.currentConflictedNodes.add(node);
        }

        @Override
        public Iterator<NodeState> iterator() {
            return this.currentConflictedNodes.iterator();
        }

        private boolean hasConflictedNodes() {
            return this.currentConflictedNodes.size() > 1;
        }

        private Set<NodeState> getConflictedNodesCopy() {
            return new LinkedHashSet<NodeState>(this.currentConflictedNodes);
        }

        private boolean createOrUpdateConflict(Set<NodeState> candidatesForConflict) {
            boolean newConflict = this.pendingConflict == null;
            this.pendingConflict = new CapabilityConflict(this.group, this.name, candidatesForConflict, this.previousConflictedNodes.contains(candidatesForConflict));
            return newConflict;
        }
    }

    private static class CapabilityConflict {
        private final String group;
        private final String name;
        private final Set<NodeState> nodes;
        private final Set<Capability> descriptors;
        private final Map<NodeState, Set<NodeState>> nodeToDependentNodes;

        private CapabilityConflict(String group, String name, Set<NodeState> nodes, boolean alreadySeen) {
            this(group, name, nodes, alreadySeen ? CapabilityConflict.buildDependentRelationships(nodes) : Collections.emptyMap());
        }

        private CapabilityConflict(String group, String name, Set<NodeState> nodes, Map<NodeState, Set<NodeState>> nodeToDependentNodes) {
            this.group = group;
            this.name = name;
            this.nodes = nodes;
            this.nodeToDependentNodes = nodeToDependentNodes;
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (NodeState node : nodes) {
                Capability capability = node.findCapability(group, name);
                if (capability == null) continue;
                builder.add((Object)capability);
            }
            this.descriptors = builder.build();
        }

        private CapabilityConflict withDifferentNodes(Set<NodeState> selectedNodes) {
            return new CapabilityConflict(this.group, this.name, selectedNodes, this.nodeToDependentNodes);
        }

        private boolean isValidConflict() {
            return !this.nodes.isEmpty() && this.nodes.stream().anyMatch(node -> !node.getComponent().isRejected());
        }

        private static Map<NodeState, Set<NodeState>> buildDependentRelationships(Set<NodeState> nodes) {
            HashMap<NodeState, Set<NodeState>> nodeToDependents = new HashMap<NodeState, Set<NodeState>>();
            for (NodeState node : nodes) {
                Set<NodeState> reachableNodes = node.getReachableNodes();
                for (NodeState possibleDependency : nodes) {
                    if (node == possibleDependency || !reachableNodes.contains(possibleDependency)) continue;
                    nodeToDependents.computeIfAbsent(possibleDependency, k -> new HashSet()).add(node);
                }
            }
            return nodeToDependents;
        }
    }

    private static class Details
    implements CapabilitiesConflictHandler.ResolutionDetails {
        private final CapabilityConflict conflict;
        private final Set<NodeState> evicted = new HashSet<NodeState>();
        private NodeState selected;
        private Describable reason;

        private Details(CapabilityConflict conflict) {
            this.conflict = conflict;
        }

        @Override
        public Collection<? extends Capability> getCapabilityVersions() {
            return this.conflict.descriptors;
        }

        @Override
        public Collection<? extends CapabilitiesConflictHandler.CandidateDetails> getCandidates(final Capability capability) {
            ImmutableList.Builder candidates = new ImmutableList.Builder();
            String group = capability.getGroup();
            String name = capability.getName();
            String version = capability.getVersion();
            for (final NodeState node : this.conflict.nodes) {
                Capability componentCapability;
                if (this.evicted.contains(node) || (componentCapability = node.findCapability(group, name)) == null || !componentCapability.getVersion().equals(version)) continue;
                candidates.add((Object)new CapabilitiesConflictHandler.CandidateDetails(){

                    @Override
                    public ComponentIdentifier getId() {
                        return node.getComponent().getComponentId();
                    }

                    @Override
                    public String getVariantName() {
                        return node.getMetadata().getName();
                    }

                    @Override
                    public void evict() {
                        node.evict();
                        evicted.add(node);
                    }

                    @Override
                    public void select() {
                        selected = node;
                    }

                    @Override
                    public void reject() {
                        ComponentState component = node.getComponent();
                        component.rejectForCapabilityConflict(capability, this.conflictedNodes(node, conflict.nodes));
                        component.selectAndRestartModule();
                    }

                    @Override
                    public void byReason(Describable description) {
                        reason = description;
                    }
                });
            }
            return candidates.build();
        }

        private Collection<NodeState> conflictedNodes(NodeState node, Collection<NodeState> nodes) {
            ArrayList<NodeState> conflictedNodes = new ArrayList<NodeState>(nodes);
            conflictedNodes.remove(node);
            return conflictedNodes;
        }

        @Override
        public void withParticipatingModules(Action<? super ModuleIdentifier> action) {
            HashSet<ModuleIdentifier> seen = new HashSet<ModuleIdentifier>();
            for (NodeState node : this.conflict.nodes) {
                ModuleIdentifier module = node.getComponent().getId().getModule();
                if (!seen.add(module)) continue;
                action.execute((Object)module);
            }
        }

        @Override
        public boolean hasResult() {
            return this.selected != null;
        }

        @Override
        public ComponentState getSelected() {
            return this.selected.getComponent();
        }
    }

    private static class Candidate
    implements CapabilitiesConflictHandler.Candidate {
        private final NodeState node;
        private final CapabilityInternal capability;
        private final Collection<NodeState> implicitCapabilityProviders;

        public Candidate(NodeState node, CapabilityInternal capability, Collection<NodeState> implicitCapabilityProviders) {
            this.node = node;
            this.capability = capability;
            this.implicitCapabilityProviders = implicitCapabilityProviders;
        }

        @Override
        public NodeState getNode() {
            return this.node;
        }

        @Override
        public CapabilityInternal getCapability() {
            return this.capability;
        }

        @Override
        public Collection<NodeState> getImplicitCapabilityProviders() {
            return this.implicitCapabilityProviders;
        }
    }
}

