/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.CrossProjectModelAccess;
import org.gradle.api.internal.project.LifecycleAwareProject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.tasks.TaskDependencyUsageTracker;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.invocation.GradleLifecycleActionExecutor;

public class DefaultCrossProjectModelAccess
implements CrossProjectModelAccess {
    private final ProjectRegistry<ProjectInternal> projectRegistry;
    private final Instantiator instantiator;
    private final GradleLifecycleActionExecutor gradleLifecycleActionExecutor;

    public DefaultCrossProjectModelAccess(ProjectRegistry<ProjectInternal> projectRegistry, Instantiator instantiator, GradleLifecycleActionExecutor gradleLifecycleActionExecutor) {
        this.projectRegistry = projectRegistry;
        this.instantiator = instantiator;
        this.gradleLifecycleActionExecutor = gradleLifecycleActionExecutor;
    }

    @Override
    public ProjectInternal access(ProjectInternal referrer, ProjectInternal project) {
        return LifecycleAwareProject.from(project, referrer, this.gradleLifecycleActionExecutor, this.instantiator);
    }

    @Override
    public ProjectInternal findProject(ProjectInternal referrer, ProjectInternal relativeTo, String path) {
        ProjectInternal project = this.projectRegistry.getProject(relativeTo.absoluteProjectPath(path));
        return project != null ? LifecycleAwareProject.from(project, referrer, this.gradleLifecycleActionExecutor, this.instantiator) : null;
    }

    @Override
    public Map<String, Project> getChildProjects(ProjectInternal referrer, ProjectInternal relativeTo) {
        return relativeTo.getChildProjectsUnchecked().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> LifecycleAwareProject.from((ProjectInternal)entry.getValue(), referrer, this.gradleLifecycleActionExecutor, this.instantiator)));
    }

    @Override
    public Set<? extends ProjectInternal> getSubprojects(ProjectInternal referrer, ProjectInternal relativeTo) {
        return this.projectRegistry.getSubProjects(relativeTo.getPath()).stream().map(project -> LifecycleAwareProject.from(project, referrer, this.gradleLifecycleActionExecutor, this.instantiator)).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public Set<? extends ProjectInternal> getAllprojects(ProjectInternal referrer, ProjectInternal relativeTo) {
        return this.projectRegistry.getAllProjects(relativeTo.getPath()).stream().map(project -> LifecycleAwareProject.from(project, referrer, this.gradleLifecycleActionExecutor, this.instantiator)).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public GradleInternal gradleInstanceForProject(ProjectInternal referrerProject, GradleInternal gradle) {
        return gradle;
    }

    @Override
    public TaskDependencyUsageTracker taskDependencyUsageTracker(ProjectInternal referrerProject) {
        return null;
    }

    @Override
    public TaskExecutionGraphInternal taskGraphForProject(ProjectInternal referrerProject, TaskExecutionGraphInternal taskGraph) {
        return taskGraph;
    }

    @Override
    public DynamicObject parentProjectDynamicInheritedScope(ProjectInternal referrerProject) {
        ProjectInternal parent = referrerProject.getParent();
        return parent != null ? parent.getInheritedScope() : null;
    }
}

