/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public class PatternParser {
    private static final TokenSet PATTERN_MODIFIERS = TokenSet.create(JavaTokenType.FINAL_KEYWORD);
    private final JavaParser myParser;

    public PatternParser(JavaParser javaParser) {
        this.myParser = javaParser;
    }

    @Contract(pure=true)
    public boolean isPattern(PsiBuilder builder2) {
        PsiBuilder.Marker patternStart = builder2.mark();
        while (builder2.getTokenType() == JavaTokenType.LPARENTH) {
            builder2.advanceLexer();
        }
        this.myParser.getDeclarationParser().parseModifierList(builder2, PATTERN_MODIFIERS);
        PsiBuilder.Marker type2 = this.myParser.getReferenceParser().parseType(builder2, 5);
        boolean isPattern = type2 != null && builder2.getTokenType() == JavaTokenType.IDENTIFIER;
        patternStart.rollbackTo();
        return isPattern;
    }

    @NotNull PsiBuilder.Marker parsePattern(PsiBuilder builder2) {
        PsiBuilder.Marker guardPattern = builder2.mark();
        PsiBuilder.Marker primaryPattern = this.parsePrimaryPattern(builder2);
        if (builder2.getTokenType() != JavaTokenType.ANDAND) {
            guardPattern.drop();
            PsiBuilder.Marker marker = primaryPattern;
            if (marker == null) {
                PatternParser.$$$reportNull$$$0(0);
            }
            return marker;
        }
        builder2.advanceLexer();
        PsiBuilder.Marker guardingExpression = this.myParser.getExpressionParser().parseConditionalAnd(builder2, 1);
        if (guardingExpression == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        JavaParserUtil.done(guardPattern, JavaElementType.GUARDED_PATTERN);
        PsiBuilder.Marker marker = guardPattern;
        if (marker == null) {
            PatternParser.$$$reportNull$$$0(1);
        }
        return marker;
    }

    @NotNull PsiBuilder.Marker parsePrimaryPattern(PsiBuilder builder2) {
        if (builder2.getTokenType() == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker parenPattern = builder2.mark();
            builder2.advanceLexer();
            this.parsePattern(builder2);
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
            }
            JavaParserUtil.done(parenPattern, JavaElementType.PARENTHESIZED_PATTERN);
            PsiBuilder.Marker marker = parenPattern;
            if (marker == null) {
                PatternParser.$$$reportNull$$$0(2);
            }
            return marker;
        }
        return this.parseTypePattern(builder2);
    }

    private @NotNull PsiBuilder.Marker parseTypePattern(PsiBuilder builder2) {
        PsiBuilder.Marker pattern = builder2.mark();
        PsiBuilder.Marker patternVariable = builder2.mark();
        this.myParser.getDeclarationParser().parseModifierList(builder2, PATTERN_MODIFIERS);
        PsiBuilder.Marker type2 = this.myParser.getReferenceParser().parseType(builder2, 5);
        assert (type2 != null);
        boolean hasIdentifier = PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER);
        assert (hasIdentifier) : "identifier expected";
        JavaParserUtil.done(patternVariable, JavaElementType.PATTERN_VARIABLE);
        JavaParserUtil.done(pattern, JavaElementType.TYPE_TEST_PATTERN);
        PsiBuilder.Marker marker = pattern;
        if (marker == null) {
            PatternParser.$$$reportNull$$$0(3);
        }
        return marker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/PatternParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePrimaryPattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

