/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.extensions.helpers;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.Map;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.sftp.client.RawSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.extensions.FilenameTranslationControlExtension;
import org.apache.sshd.sftp.client.extensions.helpers.AbstractSftpClientExtension;

public class FilenameTranslationControlExtensionImpl
extends AbstractSftpClientExtension
implements FilenameTranslationControlExtension {
    public FilenameTranslationControlExtensionImpl(SftpClient client, RawSftpClient raw, Collection<String> extras) {
        super("filename-translation-control", client, raw, GenericUtils.isNotEmpty(extras) && extras.contains("filename-charset"));
    }

    public FilenameTranslationControlExtensionImpl(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions) {
        super("filename-translation-control", client, raw, MapEntryUtils.isNotEmpty(extensions) && extensions.containsKey("filename-charset"));
    }

    @Override
    public void setFilenameTranslationControl(boolean doTranslate) throws IOException {
        Buffer request = this.getCommandBuffer(8);
        request.putBoolean(doTranslate);
        if (this.log.isDebugEnabled()) {
            this.log.debug("setFilenameTranslationControl({}) doTranslate={}", (Object)this.getName(), (Object)doTranslate);
        }
        int id = this.sendExtendedCommand(request);
        Buffer response = this.receive(id);
        if ((response = this.checkExtendedReplyBuffer(response)) != null) {
            throw new StreamCorruptedException("Unexpected extended reply data");
        }
    }
}

