/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.kotlin.dsl.concurrent.EventLoop;
import org.gradle.kotlin.dsl.resolver.DefaultResolverEventLogger;
import org.gradle.kotlin.dsl.resolver.ResolverEvent;
import org.gradle.kotlin.dsl.resolver.ResolverEventLogger;
import org.gradle.kotlin.dsl.support.IOKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\b0\b2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\n \u0019*\u0004\u0018\u00010\b0\bH\u0002J\b\u0010\u001f\u001a\u00020\fH\u0002J\u001e\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0002J\u0010\u0010#\u001a\n \u0019*\u0004\u0018\u00010$0$H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/gradle/kotlin/dsl/resolver/DefaultResolverEventLogger;", "Lorg/gradle/kotlin/dsl/resolver/ResolverEventLogger;", "()V", "cleanupAfterDays", "", "eventLoop", "Lorg/gradle/kotlin/dsl/concurrent/EventLoop;", "Lkotlin/Pair;", "Ljava/util/Date;", "Lorg/gradle/kotlin/dsl/resolver/ResolverEvent;", "logFilesExpireAfterDays", "outputFile", "Ljava/io/File;", "getOutputFile", "()Ljava/io/File;", "outputFile$delegate", "Lkotlin/Lazy;", "resolverLogFilenameRegex", "Lkotlin/text/Regex;", "bufferedAppendWriter", "Ljava/io/BufferedWriter;", "cleanupLogDirectory", "", "logDir", "daysAgo", "kotlin.jvm.PlatformType", "days", "log", "event", "logDirForOperatingSystem", "now", "outputDir", "readyForCleanup", "cleanup", "Lkotlin/Function0;", "timestampForFileName", "", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nResolverEventLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolverEventLogger.kt\norg/gradle/kotlin/dsl/resolver/DefaultResolverEventLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public final class DefaultResolverEventLogger
implements ResolverEventLogger {
    @NotNull
    public static final DefaultResolverEventLogger INSTANCE = new DefaultResolverEventLogger();
    @NotNull
    private static final EventLoop<Pair<Date, ResolverEvent>> eventLoop = new EventLoop(null, eventLoop.1.INSTANCE, 1, null);
    @NotNull
    private static final Lazy outputFile$delegate = LazyKt.lazy((Function0)outputFile.2.INSTANCE);
    private static final int cleanupAfterDays = 1;
    private static final int logFilesExpireAfterDays = 7;
    @NotNull
    private static final Regex resolverLogFilenameRegex = new Regex("resolver-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{3}\\.log");

    private DefaultResolverEventLogger() {
    }

    @Override
    public void log(@NotNull ResolverEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        eventLoop.accept((Pair<Date, ResolverEvent>)TuplesKt.to((Object)this.now(), (Object)event));
    }

    private final File getOutputFile() {
        Lazy lazy = outputFile$delegate;
        return (File)lazy.getValue();
    }

    private final BufferedWriter bufferedAppendWriter() {
        return new BufferedWriter(new FileWriter(this.getOutputFile(), true));
    }

    private final String timestampForFileName() {
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS").format(this.now());
    }

    private final File outputDir() {
        File file;
        File $this$outputDir_u24lambda_u240 = file = this.logDirForOperatingSystem();
        boolean bl = false;
        $this$outputDir_u24lambda_u240.mkdirs();
        return file;
    }

    private final File logDirForOperatingSystem() {
        File file;
        OperatingSystem $this$logDirForOperatingSystem_u24lambda_u242 = OperatingSystem.current();
        boolean bl = false;
        if ($this$logDirForOperatingSystem_u24lambda_u242.isMacOsX()) {
            file = FilesKt.resolve((File)IOKt.userHome(), (String)"Library/Logs/gradle-kotlin-dsl");
        } else if ($this$logDirForOperatingSystem_u24lambda_u242.isWindows()) {
            String string2 = System.getenv("LOCALAPPDATA");
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                file = new File(it + "/gradle-kotlin-dsl/log");
            } else {
                file = FilesKt.resolve((File)IOKt.userHome(), (String)"AppData/Local/gradle-kotlin-dsl/log");
            }
        } else {
            file = FilesKt.resolve((File)IOKt.userHome(), (String)".gradle-kotlin-dsl/log");
        }
        return file;
    }

    private final Date now() {
        return GregorianCalendar.getInstance().getTime();
    }

    private final void cleanupLogDirectory(File logDir) {
        this.readyForCleanup(logDir, (Function0<Unit>)((Function0)new Function0<Unit>(logDir){
            final /* synthetic */ File $logDir;
            {
                this.$logDir = $logDir;
                super(0);
            }

            public final void invoke() {
                Date expiration = DefaultResolverEventLogger.access$daysAgo(DefaultResolverEventLogger.INSTANCE, 7);
                File[] fileArray = this.$logDir.listFiles(new FileFilter(expiration){
                    final /* synthetic */ Date $expiration;
                    {
                        this.$expiration = $expiration;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean accept(File file) {
                        if (!file.isFile()) return false;
                        String string2 = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
                        CharSequence charSequence = string2;
                        if (!DefaultResolverEventLogger.access$getResolverLogFilenameRegex$p().matches(charSequence)) return false;
                        if (!new Date(file.lastModified()).before(this.$expiration)) return false;
                        return true;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"expiration = daysAgo(log\u2026expiration)\n            }");
                Object[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    it.delete();
                }
            }
        }));
    }

    private final void readyForCleanup(File logDir, Function0<Unit> cleanup) {
        File $this$readyForCleanup_u24lambda_u243 = FilesKt.resolve((File)logDir, (String)".cleanup");
        boolean bl = false;
        if (!$this$readyForCleanup_u24lambda_u243.isFile() || $this$readyForCleanup_u24lambda_u243.isFile() && new Date($this$readyForCleanup_u24lambda_u243.lastModified()).before(INSTANCE.daysAgo(1))) {
            cleanup.invoke();
            FilesKt.writeBytes((File)$this$readyForCleanup_u24lambda_u243, (byte[])new byte[0]);
        }
    }

    private final Date daysAgo(int days) {
        Calendar calendar;
        Calendar $this$daysAgo_u24lambda_u244 = calendar = GregorianCalendar.getInstance();
        boolean bl = false;
        $this$daysAgo_u24lambda_u244.add(5, -days);
        return calendar.getTime();
    }

    public static final /* synthetic */ Date access$daysAgo(DefaultResolverEventLogger $this, int days) {
        return $this.daysAgo(days);
    }

    public static final /* synthetic */ Regex access$getResolverLogFilenameRegex$p() {
        return resolverLogFilenameRegex;
    }

    public static final /* synthetic */ BufferedWriter access$bufferedAppendWriter(DefaultResolverEventLogger $this) {
        return $this.bufferedAppendWriter();
    }

    public static final /* synthetic */ File access$outputDir(DefaultResolverEventLogger $this) {
        return $this.outputDir();
    }

    public static final /* synthetic */ void access$cleanupLogDirectory(DefaultResolverEventLogger $this, File logDir) {
        $this.cleanupLogDirectory(logDir);
    }

    public static final /* synthetic */ String access$timestampForFileName(DefaultResolverEventLogger $this) {
        return $this.timestampForFileName();
    }
}

