/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.file.Directory;
import org.gradle.buildinit.InsecureProtocolOption;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public class InitSettings {
    private final BuildInitDsl dsl;
    private final boolean useIncubatingAPIs;
    private final String packageName;
    private final BuildInitTestFramework testFramework;
    private final String projectName;
    private final List<String> subprojects;
    private final ModularizationOption modularizationOption;
    private final Directory target;
    private final InsecureProtocolOption insecureProtocolOption;
    private final Optional<JavaLanguageVersion> toolchainVersion;

    public InitSettings(String projectName, List<String> subprojects, ModularizationOption modularizationOption, BuildInitDsl dsl, String packageName, BuildInitTestFramework testFramework, Directory target) {
        this(projectName, false, subprojects, modularizationOption, dsl, packageName, testFramework, InsecureProtocolOption.WARN, target, Optional.empty());
    }

    public InitSettings(String projectName, boolean useIncubatingAPIs, List<String> subprojects, ModularizationOption modularizationOption, BuildInitDsl dsl, String packageName, BuildInitTestFramework testFramework, Directory target) {
        this(projectName, useIncubatingAPIs, subprojects, modularizationOption, dsl, packageName, testFramework, InsecureProtocolOption.WARN, target, Optional.empty());
    }

    public InitSettings(String projectName, boolean useIncubatingAPIs, List<String> subprojects, ModularizationOption modularizationOption, BuildInitDsl dsl, String packageName, BuildInitTestFramework testFramework, InsecureProtocolOption insecureProtocolOption, Directory target, Optional<JavaLanguageVersion> toolchainVersion) {
        this.projectName = projectName;
        this.useIncubatingAPIs = useIncubatingAPIs;
        this.subprojects = InitSettings.getSubprojects(subprojects, modularizationOption);
        this.modularizationOption = modularizationOption;
        this.dsl = dsl;
        this.packageName = packageName;
        this.testFramework = testFramework;
        this.insecureProtocolOption = insecureProtocolOption;
        this.target = target;
        this.toolchainVersion = toolchainVersion;
    }

    private static List<String> getSubprojects(List<String> subprojects, ModularizationOption modularizationOption) {
        if (!subprojects.isEmpty() && modularizationOption == ModularizationOption.SINGLE_PROJECT) {
            return Collections.singletonList(subprojects.get(0));
        }
        return subprojects;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<String> getSubprojects() {
        return this.subprojects;
    }

    public ModularizationOption getModularizationOption() {
        return this.modularizationOption;
    }

    public BuildInitDsl getDsl() {
        return this.dsl;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public BuildInitTestFramework getTestFramework() {
        return this.testFramework;
    }

    public Directory getTarget() {
        return this.target;
    }

    @Nullable
    public InsecureProtocolOption getInsecureProtocolOption() {
        return this.insecureProtocolOption;
    }

    @Incubating
    public boolean isUseIncubatingAPIs() {
        return this.useIncubatingAPIs;
    }

    @Incubating
    public boolean isUseTestSuites() {
        return this.useIncubatingAPIs;
    }

    @Incubating
    public Optional<JavaLanguageVersion> getJavaLanguageVersion() {
        return this.toolchainVersion;
    }
}

