/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.tasks;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.buildinit.InsecureProtocolOption;
import org.gradle.buildinit.plugins.internal.BuildConverter;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.PackageNameBuilder;
import org.gradle.buildinit.plugins.internal.ProjectLayoutSetupRegistry;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class InitBuild
extends DefaultTask {
    private static final int MINIMUM_VERSION_SUPPORTED_BY_FOOJAY_API = 7;
    private final Directory projectDir = this.getProject().getLayout().getProjectDirectory();
    private String type;
    private final Property<Boolean> splitProject = this.getProject().getObjects().property(Boolean.class);
    private String dsl;
    private final Property<Boolean> useIncubatingAPIs = this.getProject().getObjects().property(Boolean.class);
    private String testFramework;
    private String projectName;
    private String packageName;
    private final Property<InsecureProtocolOption> insecureProtocol = this.getProject().getObjects().property(InsecureProtocolOption.class);
    @Internal
    private ProjectLayoutSetupRegistry projectLayoutRegistry;

    @Input
    public String getType() {
        return Strings.isNullOrEmpty((String)this.type) ? this.detectType() : this.type;
    }

    @Input
    @Optional
    @Option(option="split-project", description="Split functionality across multiple subprojects?")
    public Property<Boolean> getSplitProject() {
        return this.splitProject;
    }

    @Optional
    @Input
    public String getDsl() {
        return Strings.isNullOrEmpty((String)this.dsl) ? BuildInitDsl.GROOVY.getId() : this.dsl;
    }

    @Input
    @Optional
    @Option(option="incubating", description="Allow the generated build to use new features and APIs")
    public Property<Boolean> getUseIncubating() {
        return this.useIncubatingAPIs;
    }

    @Input
    public String getProjectName() {
        return this.projectName == null ? this.projectDir.getAsFile().getName() : this.projectName;
    }

    @Input
    public String getPackageName() {
        return this.packageName == null ? "" : this.packageName;
    }

    @Nullable
    @Optional
    @Input
    public String getTestFramework() {
        return this.testFramework;
    }

    @Input
    @Option(option="insecure-protocol", description="How to handle insecure URLs used for Maven Repositories.")
    public Property<InsecureProtocolOption> getInsecureProtocol() {
        return this.insecureProtocol;
    }

    public ProjectLayoutSetupRegistry getProjectLayoutRegistry() {
        if (this.projectLayoutRegistry == null) {
            this.projectLayoutRegistry = (ProjectLayoutSetupRegistry)this.getServices().get(ProjectLayoutSetupRegistry.class);
        }
        return this.projectLayoutRegistry;
    }

    @TaskAction
    public void setupProjectLayout() {
        UserInputHandler inputHandler = (UserInputHandler)this.getServices().get(UserInputHandler.class);
        ProjectLayoutSetupRegistry projectLayoutRegistry = this.getProjectLayoutRegistry();
        BuildInitializer initDescriptor = this.getBuildInitializer(inputHandler, projectLayoutRegistry);
        ModularizationOption modularizationOption = this.getModularizationOption(inputHandler, initDescriptor);
        BuildInitDsl dsl = this.getBuildInitDsl(inputHandler, initDescriptor);
        BuildInitTestFramework testFramework = this.getBuildInitTestFramework(inputHandler, initDescriptor, modularizationOption);
        String projectName = this.getProjectName(inputHandler, initDescriptor);
        String packageName = this.getPackageName(inputHandler, initDescriptor, projectName);
        InitBuild.validatePackageName(packageName);
        java.util.Optional<JavaLanguageVersion> toolChainVersion = this.getJavaLanguageVersion(inputHandler, initDescriptor);
        boolean useIncubatingAPIs = this.shouldUseIncubatingAPIs(inputHandler);
        List<String> subprojectNames = initDescriptor.getComponentType().getDefaultProjectNames();
        InitSettings settings = new InitSettings(projectName, useIncubatingAPIs, subprojectNames, modularizationOption, dsl, packageName, testFramework, (InsecureProtocolOption)((Object)this.insecureProtocol.get()), this.projectDir, toolChainVersion);
        initDescriptor.generate(settings);
        initDescriptor.getFurtherReading(settings).ifPresent(link -> this.getLogger().lifecycle("Get more help with your project: {}", new Object[]{link}));
    }

    private static void validatePackageName(String packageName) {
        if (!Strings.isNullOrEmpty((String)packageName) && !SourceVersion.isName(packageName)) {
            throw new GradleException("Package name: '" + packageName + "' is not valid - it may contain invalid characters or reserved words.");
        }
    }

    java.util.Optional<JavaLanguageVersion> getJavaLanguageVersion(UserInputHandler inputHandler, BuildInitializer initDescriptor) {
        if (!initDescriptor.supportsJavaTargets()) {
            return java.util.Optional.empty();
        }
        JavaLanguageVersion current = JavaLanguageVersion.of((String)Jvm.current().getJavaVersion().getMajorVersion());
        String version = inputHandler.askQuestion("Enter target version of Java (min. 7)", current.toString());
        try {
            int parsedVersion = Integer.parseInt(version);
            if (parsedVersion < 7) {
                throw new GradleException("Java target version: '" + version + "' is not a supported target version. It must be equal to or greater than " + 7);
            }
            return java.util.Optional.of(JavaLanguageVersion.of((int)parsedVersion));
        }
        catch (NumberFormatException e) {
            throw new GradleException("Invalid Java target version '" + version + "'. The version must be an integer.", (Throwable)e);
        }
    }

    private BuildInitDsl getBuildInitDsl(UserInputHandler inputHandler, BuildInitializer initDescriptor) {
        BuildInitDsl dsl;
        if (Strings.isNullOrEmpty((String)this.dsl)) {
            dsl = initDescriptor.getDefaultDsl();
            if (initDescriptor.getDsls().size() > 1) {
                dsl = (BuildInitDsl)inputHandler.selectOption("Select build script DSL", initDescriptor.getDsls(), (Object)dsl);
            }
        } else {
            dsl = BuildInitDsl.fromName(this.getDsl());
            if (!initDescriptor.getDsls().contains(dsl)) {
                throw new GradleException("The requested DSL '" + this.getDsl() + "' is not supported for '" + initDescriptor.getId() + "' build type");
            }
        }
        return dsl;
    }

    private ModularizationOption getModularizationOption(UserInputHandler inputHandler, BuildInitializer initDescriptor) {
        if (this.splitProject.isPresent()) {
            return (Boolean)this.splitProject.get() != false ? ModularizationOption.WITH_LIBRARY_PROJECTS : ModularizationOption.SINGLE_PROJECT;
        }
        if (initDescriptor.getModularizationOptions().size() == 1) {
            return initDescriptor.getModularizationOptions().iterator().next();
        }
        if (!Strings.isNullOrEmpty((String)this.type)) {
            return ModularizationOption.SINGLE_PROJECT;
        }
        boolean multipleSubprojects = inputHandler.askYesNoQuestion("Generate multiple subprojects for application?", false);
        return multipleSubprojects ? ModularizationOption.WITH_LIBRARY_PROJECTS : ModularizationOption.SINGLE_PROJECT;
    }

    private boolean shouldUseIncubatingAPIs(UserInputHandler inputHandler) {
        if (this.useIncubatingAPIs.isPresent()) {
            return (Boolean)this.useIncubatingAPIs.get();
        }
        return inputHandler.askYesNoQuestion("Generate build using new APIs and behavior (some features may change in the next minor release)?", false);
    }

    private BuildInitTestFramework getBuildInitTestFramework(UserInputHandler inputHandler, BuildInitializer initDescriptor, ModularizationOption modularizationOption) {
        if (modularizationOption == ModularizationOption.WITH_LIBRARY_PROJECTS) {
            return BuildInitTestFramework.JUNIT_JUPITER;
        }
        if (!Strings.isNullOrEmpty((String)this.testFramework)) {
            return initDescriptor.getTestFrameworks().stream().filter(candidate -> this.testFramework.equals(candidate.getId())).findFirst().orElseThrow(() -> this.createNotSupportedTestFrameWorkException(initDescriptor));
        }
        BuildInitTestFramework testFramework = initDescriptor.getDefaultTestFramework();
        if (initDescriptor.getTestFrameworks().size() > 1) {
            return (BuildInitTestFramework)inputHandler.selectOption("Select test framework", initDescriptor.getTestFrameworks(), (Object)testFramework);
        }
        return testFramework;
    }

    private GradleException createNotSupportedTestFrameWorkException(BuildInitializer initDescriptor) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("The requested test framework '" + this.getTestFramework() + "' is not supported for '" + initDescriptor.getId() + "' build type. Supported frameworks");
        formatter.startChildren();
        for (BuildInitTestFramework framework : initDescriptor.getTestFrameworks()) {
            formatter.node("'" + framework.getId() + "'");
        }
        formatter.endChildren();
        return new GradleException(formatter.toString());
    }

    String getProjectName(UserInputHandler inputHandler, BuildInitializer initDescriptor) {
        String projectName = this.projectName;
        if (initDescriptor.supportsProjectName()) {
            if (Strings.isNullOrEmpty((String)projectName)) {
                return inputHandler.askQuestion("Project name", this.getProjectName());
            }
        } else if (!Strings.isNullOrEmpty((String)projectName)) {
            throw new GradleException("Project name is not supported for '" + initDescriptor.getId() + "' build type.");
        }
        return projectName;
    }

    String getPackageName(UserInputHandler inputHandler, BuildInitializer initDescriptor, String projectName) {
        String packageName = this.packageName;
        if (initDescriptor.supportsPackage()) {
            if (Strings.isNullOrEmpty((String)packageName)) {
                return inputHandler.askQuestion("Source package", PackageNameBuilder.toPackageName(projectName).toLowerCase(Locale.US));
            }
        } else if (!Strings.isNullOrEmpty((String)packageName)) {
            throw new GradleException("Package name is not supported for '" + initDescriptor.getId() + "' build type.");
        }
        return packageName;
    }

    private BuildInitializer getBuildInitializer(UserInputHandler inputHandler, ProjectLayoutSetupRegistry projectLayoutRegistry) {
        if (!Strings.isNullOrEmpty((String)this.type)) {
            return projectLayoutRegistry.get(this.type);
        }
        BuildConverter converter = projectLayoutRegistry.getBuildConverter();
        if (converter.canApplyToCurrentDirectory(this.projectDir) && inputHandler.askYesNoQuestion("Found a " + converter.getSourceBuildDescription() + " build. Generate a Gradle build from this?", true)) {
            return converter;
        }
        return InitBuild.selectTypeOfProject(inputHandler, projectLayoutRegistry);
    }

    private static BuildInitializer selectTypeOfProject(UserInputHandler inputHandler, ProjectLayoutSetupRegistry projectLayoutRegistry) {
        ComponentType componentType = (ComponentType)((Object)inputHandler.selectOption("Select type of project to generate", projectLayoutRegistry.getComponentTypes(), (Object)projectLayoutRegistry.getDefault().getComponentType()));
        List<Language> languages = projectLayoutRegistry.getLanguagesFor(componentType);
        if (languages.size() == 1) {
            return projectLayoutRegistry.get(componentType, languages.get(0));
        }
        if (!languages.contains((Object)Language.JAVA)) {
            throw new UnsupportedOperationException();
        }
        Language language = (Language)((Object)inputHandler.selectOption("Select implementation language", languages, (Object)Language.JAVA));
        return projectLayoutRegistry.get(componentType, language);
    }

    @Option(option="type", description="Set the type of project to generate.")
    public void setType(String type) {
        this.type = type;
    }

    @OptionValues(value={"type"})
    public List<String> getAvailableBuildTypes() {
        return this.getProjectLayoutRegistry().getAllTypes();
    }

    @Option(option="dsl", description="Set the build script DSL to be used in generated scripts.")
    public void setDsl(String dsl) {
        this.dsl = dsl;
    }

    @OptionValues(value={"dsl"})
    public List<String> getAvailableDSLs() {
        return BuildInitDsl.listSupported();
    }

    @Option(option="test-framework", description="Set the test framework to be used.")
    public void setTestFramework(@Nullable String testFramework) {
        this.testFramework = testFramework;
    }

    @OptionValues(value={"test-framework"})
    public List<String> getAvailableTestFrameworks() {
        return BuildInitTestFramework.listSupported();
    }

    @Option(option="project-name", description="Set the project name.")
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Option(option="package", description="Set the package for source files.")
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    void setProjectLayoutRegistry(ProjectLayoutSetupRegistry projectLayoutRegistry) {
        this.projectLayoutRegistry = projectLayoutRegistry;
    }

    private String detectType() {
        ProjectLayoutSetupRegistry projectLayoutRegistry = this.getProjectLayoutRegistry();
        BuildConverter buildConverter = projectLayoutRegistry.getBuildConverter();
        if (buildConverter.canApplyToCurrentDirectory(this.projectDir)) {
            return buildConverter.getId();
        }
        return projectLayoutRegistry.getDefault().getId();
    }
}

