/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.GroovyMethods;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.RuleInput;
import org.gradle.model.RuleSource;
import org.gradle.model.RuleTarget;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.DefaultMethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.DefaultMethodRuleDefinition;
import org.gradle.model.internal.inspect.DefaultModelRuleInvoker;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.ExtractedRuleSource;
import org.gradle.model.internal.inspect.FormattingValidationProblemCollector;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleAction;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.RuleSourceValidationProblemCollector;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.instance.GeneratedViewState;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ScalarValueSchema;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.registry.RuleContext;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.internal.CollectionUtils;

@ThreadSafe
public class ModelRuleExtractor {
    private final LoadingCache<Class<?>, CachedRuleSource> cache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, CachedRuleSource>(){

        public CachedRuleSource load(Class<?> source) {
            return ModelRuleExtractor.this.doExtract(source);
        }
    });
    private final Iterable<MethodModelRuleExtractor> handlers;
    private final ManagedProxyFactory proxyFactory;
    private final ModelSchemaStore schemaStore;
    private final StructBindingsStore structBindingsStore;

    public ModelRuleExtractor(Iterable<MethodModelRuleExtractor> handlers, ManagedProxyFactory proxyFactory, ModelSchemaStore schemaStore, StructBindingsStore structBindingsStore) {
        this.handlers = handlers;
        this.proxyFactory = proxyFactory;
        this.schemaStore = schemaStore;
        this.structBindingsStore = structBindingsStore;
    }

    private String describeHandlers() {
        String desc = Joiner.on((String)", ").join((Iterable)CollectionUtils.collect(this.handlers, (InternalTransformer)new InternalTransformer<String, MethodModelRuleExtractor>(){

            public String transform(MethodModelRuleExtractor original) {
                return original.getDescription();
            }
        }));
        return "[" + desc + "]";
    }

    public <T> ExtractedRuleSource<T> extract(Class<T> source) throws InvalidModelRuleDeclarationException {
        try {
            return ((CachedRuleSource)this.cache.get(source)).newInstance(source);
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (UncheckedExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
    }

    private <T> CachedRuleSource doExtract(Class<T> source) {
        ModelType type = ModelType.of(source);
        FormattingValidationProblemCollector problems = new FormattingValidationProblemCollector("rule source", type);
        DefaultMethodModelRuleExtractionContext context = new DefaultMethodModelRuleExtractionContext(this, problems);
        StructSchema<T> schema = this.getSchema(source, context);
        if (schema == null) {
            throw new InvalidModelRuleDeclarationException(problems.format());
        }
        TreeSet<Method> methods = new TreeSet<Method>((Comparator<Method>)Ordering.usingToString());
        methods.addAll(Arrays.asList(source.getDeclaredMethods()));
        ImmutableList.Builder implicitInputs = ImmutableList.builder();
        ModelProperty<?> target = null;
        for (ModelProperty<?> property : schema.getProperties()) {
            if (property.isAnnotationPresent(RuleTarget.class)) {
                target = property;
            } else if (property.isAnnotationPresent(RuleInput.class) && !(property.getSchema() instanceof ScalarValueSchema)) {
                implicitInputs.add((Object)property);
            }
            for (WeaklyTypeReferencingMethod<?, ?> method : property.getAccessors()) {
                methods.remove(method.getMethod());
            }
        }
        ImmutableList.Builder rules = ImmutableList.builder();
        for (Method method : methods) {
            MethodRuleDefinition<?, ?> ruleDefinition = DefaultMethodRuleDefinition.create(source, method);
            ExtractedModelRule rule = this.getMethodHandler(ruleDefinition, method, context);
            if (rule == null) continue;
            rules.add((Object)new ExtractedRuleDetails(ruleDefinition, rule));
        }
        if (context.hasProblems()) {
            throw new InvalidModelRuleDeclarationException(problems.format());
        }
        StructBindings bindings = this.structBindingsStore.getBindings(schema.getType());
        if (schema.getProperties().isEmpty()) {
            return new StatelessRuleSource((List<ExtractedRuleDetails>)rules.build(), Modifier.isAbstract(source.getModifiers()) ? new AbstractRuleSourceFactory<T>(schema, bindings, this.proxyFactory) : new ConcreteRuleSourceFactory(type));
        }
        return new ParameterizedRuleSource((List<ExtractedRuleDetails>)rules.build(), target, (List<ModelProperty<?>>)implicitInputs.build(), schema, bindings, this.proxyFactory);
    }

    private <T> StructSchema<T> getSchema(Class<T> source, RuleSourceValidationProblemCollector problems) {
        ModelSchema<T> schema;
        if (!RuleSource.class.isAssignableFrom(source) || !source.getSuperclass().equals(RuleSource.class)) {
            problems.add("Rule source classes must directly extend " + RuleSource.class.getName());
        }
        if (!((schema = this.schemaStore.getSchema(source)) instanceof StructSchema)) {
            return null;
        }
        this.validateClass(source, problems);
        return (StructSchema)schema;
    }

    @Nullable
    private ExtractedModelRule getMethodHandler(MethodRuleDefinition<?, ?> ruleDefinition, Method method, MethodModelRuleExtractionContext context) {
        MethodModelRuleExtractor handler = null;
        for (MethodModelRuleExtractor candidateHandler : this.handlers) {
            if (!candidateHandler.isSatisfiedBy(ruleDefinition)) continue;
            if (handler == null) {
                handler = candidateHandler;
                continue;
            }
            context.add(method, "Can only be one of " + this.describeHandlers());
            this.validateRuleMethod(ruleDefinition, method, context);
            return null;
        }
        if (handler != null) {
            this.validateRuleMethod(ruleDefinition, method, context);
            return handler.registration(ruleDefinition, context);
        }
        this.validateNonRuleMethod(method, context);
        return null;
    }

    private void validateClass(Class<?> source, RuleSourceValidationProblemCollector problems) {
        Field[] fields;
        Constructor<?>[] constructors;
        int modifiers = source.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            problems.add("Must be a class, not an interface");
        }
        if (source.getEnclosingClass() != null) {
            if (Modifier.isStatic(modifiers)) {
                if (Modifier.isPrivate(modifiers)) {
                    problems.add("Class cannot be private");
                }
            } else {
                problems.add("Enclosed classes must be static and non private");
            }
        }
        for (Constructor<?> constructor : constructors = source.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length <= 0) continue;
            problems.add("Cannot declare a constructor that takes arguments");
            break;
        }
        for (Field field : fields = source.getDeclaredFields()) {
            int fieldModifiers = field.getModifiers();
            if (field.isSynthetic() || Modifier.isStatic(fieldModifiers) && Modifier.isFinal(fieldModifiers)) continue;
            problems.add(field, "Fields must be static final.");
        }
    }

    private void validateRuleMethod(MethodRuleDefinition<?, ?> ruleDefinition, Method ruleMethod, RuleSourceValidationProblemCollector problems) {
        ModelType returnType;
        if (Modifier.isPrivate(ruleMethod.getModifiers())) {
            problems.add(ruleMethod, "A rule method cannot be private");
        }
        if (Modifier.isAbstract(ruleMethod.getModifiers())) {
            problems.add(ruleMethod, "A rule method cannot be abstract");
        }
        if (ruleMethod.getTypeParameters().length > 0) {
            problems.add(ruleMethod, "Cannot have type variables (i.e. cannot be a generic method)");
        }
        if ((returnType = ModelType.returnType((Method)ruleMethod)).isRawClassOfParameterizedType()) {
            problems.add(ruleMethod, "Raw type " + returnType + " used for return type (all type parameters must be specified of parameterized type)");
        }
        for (int i = 0; i < ruleDefinition.getReferences().size(); ++i) {
            ModelReference<?> reference = ruleDefinition.getReferences().get(i);
            if (reference.getType().isRawClassOfParameterizedType()) {
                problems.add(ruleMethod, "Raw type " + reference.getType() + " used for parameter " + (i + 1) + " (all type parameters must be specified of parameterized type)");
            }
            if (reference.getPath() == null) continue;
            try {
                ModelPath.validatePath(reference.getPath().getPath());
                continue;
            }
            catch (Exception e) {
                problems.add(ruleDefinition, "The declared model element path '" + reference.getPath().getPath() + "' used for parameter " + (i + 1) + " is not a valid path", e);
            }
        }
    }

    private void validateNonRuleMethod(Method method, RuleSourceValidationProblemCollector problems) {
        if (!(Modifier.isPrivate(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.isSynthetic() || GroovyMethods.isObjectMethod(method))) {
            problems.add(method, "A method that is not annotated as a rule must be private");
        }
    }

    private static class ParameterizedExtractedRuleSource<T>
    extends DefaultExtractedRuleSource<T>
    implements GeneratedViewState,
    Factory<T> {
        @Nullable
        private final ModelProperty<?> targetProperty;
        private final List<ModelProperty<?>> implicitInputs;
        private final StructSchema<T> schema;
        private final StructBindings<?> bindings;
        private final ManagedProxyFactory proxyFactory;
        private final Map<String, Object> values = new HashMap<String, Object>();

        public ParameterizedExtractedRuleSource(List<ExtractedRuleDetails> rules, @Nullable ModelProperty<?> targetProperty, List<ModelProperty<?>> implicitInputs, StructSchema<T> schema, StructBindings<?> bindings, ManagedProxyFactory proxyFactory) {
            super(rules);
            this.targetProperty = targetProperty;
            this.implicitInputs = implicitInputs;
            this.schema = schema;
            this.bindings = bindings;
            this.proxyFactory = proxyFactory;
        }

        @Override
        public Factory<? extends T> getFactory() {
            return this;
        }

        public T create() {
            return this.proxyFactory.createProxy(this, this.schema, this.bindings);
        }

        @Override
        public String getDisplayName() {
            return "rule source " + this.schema.getType().getDisplayName();
        }

        @Override
        public Object get(String name) {
            ModelProperty<?> property = this.schema.getProperty(name);
            if (property.getSchema() instanceof ScalarValueSchema) {
                return this.values.get(name);
            }
            MutableModelNode node = (MutableModelNode)this.values.get(name);
            if (node == null) {
                return null;
            }
            return node.asImmutable(property.getType(), RuleContext.get()).getInstance();
        }

        @Override
        public void set(String name, Object value) {
            ModelProperty<?> property = this.schema.getProperty(name);
            if (property.getSchema() instanceof ScalarValueSchema) {
                this.values.put(name, value);
            } else {
                MutableModelNode backingNode = ((ManagedInstance)value).getBackingNode();
                this.values.put(name, backingNode);
            }
        }

        @Override
        protected ModelPath calculateTarget(MutableModelNode target) {
            if (this.targetProperty != null) {
                return ((MutableModelNode)this.values.get(this.targetProperty.getName())).getPath();
            }
            return target.getPath();
        }

        @Override
        protected List<ModelReference<?>> withImplicitInputs(List<? extends ModelReference<?>> inputs) {
            ArrayList allInputs = new ArrayList(inputs.size() + this.implicitInputs.size());
            allInputs.addAll(inputs);
            for (ModelProperty<?> property : this.implicitInputs) {
                MutableModelNode backingNode = (MutableModelNode)this.values.get(property.getName());
                allInputs.add(ModelReference.of(backingNode.getPath()));
            }
            return allInputs;
        }
    }

    private static class StatelessExtractedRuleSource<T>
    extends DefaultExtractedRuleSource<T> {
        private final Factory<T> factory;

        public StatelessExtractedRuleSource(List<ExtractedRuleDetails> rules, Factory<T> factory) {
            super(rules);
            this.factory = factory;
        }

        @Override
        public Factory<? extends T> getFactory() {
            return this.factory;
        }
    }

    private static abstract class DefaultExtractedRuleSource<T>
    implements ExtractedRuleSource<T> {
        private final List<ExtractedRuleDetails> rules;

        public DefaultExtractedRuleSource(List<ExtractedRuleDetails> rules) {
            this.rules = rules;
        }

        public List<ExtractedModelRule> getRules() {
            return CollectionUtils.collect(this.rules, (InternalTransformer)new InternalTransformer<ExtractedModelRule, ExtractedRuleDetails>(){

                public ExtractedModelRule transform(ExtractedRuleDetails extractedRuleDetails) {
                    return extractedRuleDetails.rule;
                }
            });
        }

        @Override
        public void apply(final ModelRegistry modelRegistry, MutableModelNode target) {
            final ModelPath targetPath = this.calculateTarget(target);
            for (final ExtractedRuleDetails details : this.rules) {
                details.rule.apply(new MethodModelRuleApplicationContext(){

                    @Override
                    public ModelRegistry getRegistry() {
                        return modelRegistry;
                    }

                    @Override
                    public ModelPath getScope() {
                        return targetPath;
                    }

                    @Override
                    public ModelAction contextualize(MethodRuleAction action) {
                        List<ModelReference<?>> inputs = this.withImplicitInputs(action.getInputs());
                        ModelReference mappedSubject = this.mapSubject(action.getSubject(), targetPath);
                        this.mapInputs(inputs.subList(0, action.getInputs().size()), targetPath);
                        MethodRuleDefinition<?, ?> methodRuleDefinition = details.method;
                        Factory factory = this.getFactory();
                        return new ContextualizedModelAction(methodRuleDefinition, mappedSubject, inputs, action, factory);
                    }
                }, target);
            }
        }

        protected ModelPath calculateTarget(MutableModelNode target) {
            return target.getPath();
        }

        private void mapInputs(List<ModelReference<?>> inputs, ModelPath targetPath) {
            for (int i = 0; i < inputs.size(); ++i) {
                ModelReference<?> input = inputs.get(i);
                if (input.getPath() != null) {
                    inputs.set(i, input.withPath(targetPath.descendant(input.getPath())));
                    continue;
                }
                inputs.set(i, input.inScope(ModelPath.ROOT));
            }
        }

        private ModelReference<?> mapSubject(ModelReference<?> subject, ModelPath targetPath) {
            if (subject.getPath() == null) {
                return subject.inScope(targetPath);
            }
            return subject.withPath(targetPath.descendant(subject.getPath()));
        }

        protected List<ModelReference<?>> withImplicitInputs(List<? extends ModelReference<?>> inputs) {
            return new ArrayList(inputs);
        }

        @Override
        public List<? extends Class<?>> getRequiredPlugins() {
            ArrayList plugins = new ArrayList();
            for (ExtractedRuleDetails details : this.rules) {
                plugins.addAll(details.rule.getRuleDependencies());
            }
            return plugins;
        }

        @Override
        public void assertNoPlugins() {
            for (ExtractedRuleDetails details : this.rules) {
                if (details.rule.getRuleDependencies().isEmpty()) continue;
                StringBuilder message = new StringBuilder();
                details.method.getDescriptor().describeTo(message);
                message.append(" has dependencies on plugins: ");
                message.append(details.rule.getRuleDependencies());
                message.append(". Plugin dependencies are not supported in this context.");
                throw new UnsupportedOperationException(message.toString());
            }
        }

        private static class ContextualizedModelAction<T>
        implements ModelAction {
            private final MethodRuleDefinition<?, ?> methodRuleDefinition;
            private final ModelReference<?> mappedSubject;
            private final List<ModelReference<?>> inputs;
            private final MethodRuleAction action;
            private final Factory<? extends T> factory;

            public ContextualizedModelAction(MethodRuleDefinition<?, ?> methodRuleDefinition, ModelReference<?> mappedSubject, List<ModelReference<?>> inputs, MethodRuleAction action, Factory<? extends T> factory) {
                this.methodRuleDefinition = methodRuleDefinition;
                this.mappedSubject = mappedSubject;
                this.inputs = inputs;
                this.action = action;
                this.factory = factory;
            }

            @Override
            public ModelRuleDescriptor getDescriptor() {
                return this.methodRuleDefinition.getDescriptor();
            }

            @Override
            public ModelReference<?> getSubject() {
                return this.mappedSubject;
            }

            @Override
            public List<? extends ModelReference<?>> getInputs() {
                return this.inputs;
            }

            @Override
            public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
                WeaklyTypeReferencingMethod method = (WeaklyTypeReferencingMethod)Cast.uncheckedCast(this.methodRuleDefinition.getMethod());
                DefaultModelRuleInvoker invoker = new DefaultModelRuleInvoker(method, this.factory);
                this.action.execute(invoker, modelNode, inputs.subList(0, this.action.getInputs().size()));
            }
        }
    }

    private static class ExtractedRuleDetails {
        final MethodRuleDefinition<?, ?> method;
        final ExtractedModelRule rule;

        public ExtractedRuleDetails(MethodRuleDefinition<?, ?> method, ExtractedModelRule rule) {
            this.method = method;
            this.rule = rule;
        }
    }

    private static class ParameterizedRuleSource
    implements CachedRuleSource {
        private final List<ExtractedRuleDetails> rules;
        @Nullable
        private final ModelProperty<?> target;
        private final List<ModelProperty<?>> implicitInputs;
        private final StructSchema<?> schema;
        private final StructBindings<?> bindings;
        private final ManagedProxyFactory proxyFactory;

        public <T> ParameterizedRuleSource(List<ExtractedRuleDetails> rules, @Nullable ModelProperty<?> target, List<ModelProperty<?>> implicitInputs, StructSchema<T> schema, StructBindings<?> bindings, ManagedProxyFactory proxyFactory) {
            this.rules = rules;
            this.target = target;
            this.implicitInputs = implicitInputs;
            this.schema = schema;
            this.bindings = bindings;
            this.proxyFactory = proxyFactory;
        }

        @Override
        public <T> ExtractedRuleSource<T> newInstance(Class<T> source) {
            StructSchema schema = (StructSchema)Cast.uncheckedCast(this.schema);
            return new ParameterizedExtractedRuleSource(this.rules, this.target, this.implicitInputs, schema, this.bindings, this.proxyFactory);
        }
    }

    private static class StatelessRuleSource
    implements CachedRuleSource {
        private final DefaultExtractedRuleSource<?> ruleSource;

        public <T> StatelessRuleSource(List<ExtractedRuleDetails> rules, Factory<T> factory) {
            this.ruleSource = new StatelessExtractedRuleSource(rules, factory);
        }

        @Override
        public <T> ExtractedRuleSource<T> newInstance(Class<T> source) {
            return (ExtractedRuleSource)Cast.uncheckedCast(this.ruleSource);
        }
    }

    static interface CachedRuleSource {
        public <T> ExtractedRuleSource<T> newInstance(Class<T> var1);
    }

    private static class AbstractRuleSourceFactory<T>
    implements Factory<T>,
    GeneratedViewState {
        private final StructSchema<T> schema;
        private final StructBindings<?> bindings;
        private final ManagedProxyFactory proxyFactory;

        public AbstractRuleSourceFactory(StructSchema<T> schema, StructBindings<?> bindings, ManagedProxyFactory proxyFactory) {
            this.schema = schema;
            this.bindings = bindings;
            this.proxyFactory = proxyFactory;
        }

        @Override
        public String getDisplayName() {
            return "rule source " + this.schema.getType().getDisplayName();
        }

        @Override
        public Object get(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public T create() {
            return this.proxyFactory.createProxy(this, this.schema, this.bindings);
        }
    }

    private static class ConcreteRuleSourceFactory<T>
    implements Factory<T> {
        private final ModelType<T> type;

        public ConcreteRuleSourceFactory(ModelType<T> type) {
            this.type = type;
        }

        public T create() {
            Class concreteClass = this.type.getConcreteClass();
            try {
                Constructor declaredConstructor = concreteClass.getDeclaredConstructor(new Class[0]);
                declaredConstructor.setAccessible(true);
                return declaredConstructor.newInstance(new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e.getTargetException());
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }
}

