/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.DefaultImmutableAttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

class UsageCompatibilityHandler {
    private final IsolatableFactory isolatableFactory;
    private final NamedObjectInstantiator instantiator;

    UsageCompatibilityHandler(IsolatableFactory isolatableFactory, NamedObjectInstantiator instantiator) {
        this.isolatableFactory = isolatableFactory;
        this.instantiator = instantiator;
    }

    public <T> ImmutableAttributes doConcat(DefaultImmutableAttributesFactory factory, ImmutableAttributes node, Attribute<T> key, Isolatable<T> value) {
        String val;
        assert (key.getName().equals(Usage.USAGE_ATTRIBUTE.getName())) : "Should only be invoked for 'org.gradle.usage', got '" + key.getName() + "'";
        boolean typedUsage = false;
        if (value instanceof CoercingStringValueSnapshot) {
            val = (String)((CoercingStringValueSnapshot)value).getValue();
        } else {
            typedUsage = true;
            val = value.isolate().toString();
        }
        if (val.endsWith("-jars")) {
            return this.doConcatWithReplacement(factory, node, key, typedUsage, val.replace("-jars", ""), "jar");
        }
        if (val.endsWith("-classes")) {
            return this.doConcatWithReplacement(factory, node, key, typedUsage, val.replace("-classes", ""), "classes");
        }
        if (val.endsWith("-resources")) {
            return this.doConcatWithReplacement(factory, node, key, typedUsage, val.replace("-resources", ""), "resources");
        }
        return factory.doConcatIsolatable(node, key, value);
    }

    private <T> ImmutableAttributes doConcatWithReplacement(DefaultImmutableAttributesFactory factory, ImmutableAttributes node, Attribute<T> key, boolean typedUsage, String usage, String libraryElements) {
        if (typedUsage) {
            ImmutableAttributes usageNode = factory.doConcatIsolatable(node, key, this.isolatableFactory.isolate((Object)((Usage)this.instantiator.named(Usage.class, usage))));
            return factory.doConcatIsolatable(usageNode, LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.isolatableFactory.isolate((Object)((LibraryElements)this.instantiator.named(LibraryElements.class, libraryElements))));
        }
        ImmutableAttributes usageNode = factory.doConcatIsolatable(node, key, (Isolatable<?>)new CoercingStringValueSnapshot(usage, this.instantiator));
        return factory.doConcatIsolatable(usageNode, (Attribute<?>)Attribute.of((String)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE.getName(), String.class), (Isolatable<?>)new CoercingStringValueSnapshot(libraryElements, this.instantiator));
    }
}

