/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import com.google.common.io.CountingInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.AbstractExternalResource;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceReadResult;
import org.gradle.internal.resource.ExternalResourceWriteResult;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;

public class AccessorBackedExternalResource
extends AbstractExternalResource {
    private final ExternalResourceName name;
    private final ExternalResourceAccessor accessor;
    private final ExternalResourceUploader uploader;
    private final ExternalResourceLister lister;
    private final boolean revalidate;

    public AccessorBackedExternalResource(ExternalResourceName name, ExternalResourceAccessor accessor, ExternalResourceUploader uploader, ExternalResourceLister lister, boolean revalidate) {
        this.name = name;
        this.accessor = accessor;
        this.uploader = uploader;
        this.lister = lister;
        this.revalidate = revalidate;
    }

    @Override
    public URI getURI() {
        return this.name.getUri();
    }

    @Override
    public String getDisplayName() {
        return this.name.getDisplayName();
    }

    @Override
    @Nullable
    public ExternalResourceReadResult<Void> writeToIfPresent(File destination) throws ResourceException {
        return this.accessor.withContent(this.name, this.revalidate, inputStream -> {
            try (CountingInputStream input = new CountingInputStream(inputStream);){
                ExternalResourceReadResult<Void> externalResourceReadResult;
                try (FileOutputStream output = new FileOutputStream(destination);){
                    IOUtils.copyLarge((InputStream)input, (OutputStream)output);
                    externalResourceReadResult = ExternalResourceReadResult.of(input.getCount());
                }
                return externalResourceReadResult;
            }
        });
    }

    @Override
    public ExternalResourceReadResult<Void> writeTo(OutputStream destination) throws ResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public <T> ExternalResourceReadResult<T> withContentIfPresent(ExternalResource.ContentAction<? extends T> readAction) throws ResourceException {
        return this.accessor.withContent(this.name, this.revalidate, inputStream -> {
            try (CountingInputStream input = new CountingInputStream((InputStream)new BufferedInputStream(inputStream));){
                Object value = readAction.execute((InputStream)input);
                ExternalResourceReadResult externalResourceReadResult = ExternalResourceReadResult.of(input.getCount(), value);
                return externalResourceReadResult;
            }
        });
    }

    @Override
    @Nullable
    public <T> ExternalResourceReadResult<T> withContentIfPresent(ExternalResource.ContentAndMetadataAction<? extends T> readAction) throws ResourceException {
        return this.accessor.withContent(this.name, this.revalidate, (inputStream, metadata) -> {
            try (CountingInputStream stream = new CountingInputStream((InputStream)new BufferedInputStream(inputStream));){
                Object value = readAction.execute((InputStream)stream, metadata);
                ExternalResourceReadResult externalResourceReadResult = ExternalResourceReadResult.of(stream.getCount(), value);
                return externalResourceReadResult;
            }
        });
    }

    @Override
    public ExternalResourceReadResult<Void> withContent(Action<? super InputStream> readAction) throws ResourceException {
        ExternalResourceReadResult result = this.accessor.withContent(this.name, this.revalidate, inputStream -> {
            CountingInputStream input = new CountingInputStream(inputStream);
            readAction.execute((Object)input);
            return ExternalResourceReadResult.of(input.getCount());
        });
        if (result == null) {
            throw ResourceExceptions.getMissing(this.name.getUri());
        }
        return result;
    }

    @Override
    public <T> ExternalResourceReadResult<T> withContent(ExternalResource.ContentAndMetadataAction<? extends T> readAction) throws ResourceException {
        ExternalResourceReadResult<? extends T> result = this.withContentIfPresent(readAction);
        if (result == null) {
            throw ResourceExceptions.getMissing(this.getURI());
        }
        return result;
    }

    @Override
    public ExternalResourceWriteResult put(ReadableContent source) throws ResourceException {
        try {
            CountingReadableContent countingResource = new CountingReadableContent(source);
            this.uploader.upload(countingResource, this.name);
            return new ExternalResourceWriteResult(countingResource.getCount());
        }
        catch (IOException e) {
            throw ResourceExceptions.putFailed(this.getURI(), e);
        }
    }

    @Override
    @Nullable
    public List<String> list() throws ResourceException {
        try {
            return this.lister.list(this.name);
        }
        catch (Exception e) {
            throw ResourceExceptions.getFailed(this.getURI(), e);
        }
    }

    @Override
    public ExternalResourceMetaData getMetaData() {
        return this.accessor.getMetaData(this.name, this.revalidate);
    }

    private static class CountingReadableContent
    implements ReadableContent {
        private final ReadableContent source;
        private CountingInputStream instr;
        private long count;

        CountingReadableContent(ReadableContent source) {
            this.source = source;
        }

        @Override
        public InputStream open() throws ResourceException {
            if (this.instr != null) {
                this.count += this.instr.getCount();
            }
            this.instr = new CountingInputStream(this.source.open());
            return this.instr;
        }

        @Override
        public long getContentLength() {
            return this.source.getContentLength();
        }

        public long getCount() {
            return this.instr != null ? this.count + this.instr.getCount() : this.count;
        }
    }
}

