/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.internal.InternalBuildFinishedListener;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.build.BuildToolingModelControllerFactory;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.build.DefaultBuildLifecycleController;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;
import org.gradle.internal.model.StateTransitionControllerFactory;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.service.scopes.BuildScopeListenerManagerAction;
import org.gradle.internal.service.scopes.BuildScopeServices;

public class DefaultBuildLifecycleControllerFactory
implements BuildLifecycleControllerFactory {
    private final StateTransitionControllerFactory stateTransitionControllerFactory;
    private final BuildToolingModelControllerFactory buildToolingModelControllerFactory;
    private final ExceptionAnalyser exceptionAnalyser;

    public DefaultBuildLifecycleControllerFactory(StateTransitionControllerFactory stateTransitionControllerFactory, BuildToolingModelControllerFactory buildToolingModelControllerFactory, ExceptionAnalyser exceptionAnalyser) {
        this.stateTransitionControllerFactory = stateTransitionControllerFactory;
        this.buildToolingModelControllerFactory = buildToolingModelControllerFactory;
        this.exceptionAnalyser = exceptionAnalyser;
    }

    @Override
    public BuildLifecycleController newInstance(BuildDefinition buildDefinition, BuildScopeServices buildScopeServices) {
        File customBuildFile;
        StartParameterInternal startParameter = buildDefinition.getStartParameter();
        ListenerManager listenerManager = (ListenerManager)buildScopeServices.get(ListenerManager.class);
        for (Action action : buildScopeServices.getAll(BuildScopeListenerManagerAction.class)) {
            action.execute((Object)listenerManager);
        }
        ScriptUsageLocationReporter usageLocationReporter = new ScriptUsageLocationReporter();
        listenerManager.addListener((Object)usageLocationReporter);
        ShowStacktrace showStacktrace = startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((boolean)true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((boolean)false);
            }
        }
        DeprecationLogger.init((UsageLocationReporter)usageLocationReporter, (WarningMode)startParameter.getWarningMode(), (BuildOperationProgressEventEmitter)((BuildOperationProgressEventEmitter)buildScopeServices.get(BuildOperationProgressEventEmitter.class)));
        File customSettingsFile = startParameter.getSettingsFile();
        if (customSettingsFile != null) {
            DefaultBuildLifecycleControllerFactory.logFileDeprecationWarning(DeprecationLogger.deprecateAction((String)"Specifying custom settings file location"));
        }
        if ((customBuildFile = startParameter.getBuildFile()) != null) {
            DefaultBuildLifecycleControllerFactory.logFileDeprecationWarning(DeprecationLogger.deprecateAction((String)"Specifying custom build file location"));
        }
        GradleInternal gradle = (GradleInternal)buildScopeServices.get(GradleInternal.class);
        BuildModelController buildModelController = (BuildModelController)buildScopeServices.get(BuildModelController.class);
        return new DefaultBuildLifecycleController(gradle, buildModelController, this.exceptionAnalyser, gradle.getBuildListenerBroadcaster(), (InternalBuildFinishedListener)listenerManager.getBroadcaster(InternalBuildFinishedListener.class), (BuildWorkPreparer)gradle.getServices().get(BuildWorkPreparer.class), (BuildWorkExecutor)gradle.getServices().get(BuildWorkExecutor.class), this.buildToolingModelControllerFactory, this.stateTransitionControllerFactory);
    }

    private static void logFileDeprecationWarning(DeprecationMessageBuilder<?> specifyingCustomfileLocation) {
        ((DeprecationMessageBuilder.WithDocumentation)specifyingCustomfileLocation.willBeRemovedInGradle9().withUpgradeGuideSection(7, "configuring_custom_build_layout")).nagUser();
    }
}

