/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.dependency;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;

public class DefaultIvyDependency
implements IvyDependencyInternal {
    private final String organisation;
    private final String module;
    private final String revision;
    private final String confMapping;
    private final boolean transitive;
    private final List<DependencyArtifact> artifacts = new ArrayList<DependencyArtifact>();
    private final List<ExcludeRule> excludeRules = new ArrayList<ExcludeRule>();
    private final ImmutableAttributes attributes;

    public DefaultIvyDependency(String organisation, String module, String revision, String confMapping, boolean transitive) {
        this.organisation = organisation;
        this.module = module;
        this.revision = Strings.nullToEmpty((String)revision);
        this.confMapping = confMapping;
        this.transitive = transitive;
        this.attributes = ImmutableAttributes.EMPTY;
    }

    public DefaultIvyDependency(String organisation, String module, String revision, String confMapping, boolean transitive, Collection<DependencyArtifact> artifacts) {
        this(organisation, module, revision, confMapping, transitive);
        this.artifacts.addAll(artifacts);
    }

    public DefaultIvyDependency(String organisation, String module, String revision, String confMapping, boolean transitive, Collection<DependencyArtifact> artifacts, Collection<ExcludeRule> excludeRules) {
        this(organisation, module, revision, confMapping, transitive, artifacts);
        this.excludeRules.addAll(excludeRules);
    }

    public DefaultIvyDependency(ExternalDependency dependency, String confMapping, ImmutableAttributes attributes) {
        this.organisation = dependency.getGroup();
        this.module = dependency.getName();
        this.revision = Strings.nullToEmpty((String)dependency.getVersion());
        this.confMapping = confMapping;
        this.transitive = dependency.isTransitive();
        this.artifacts.addAll(dependency.getArtifacts());
        this.excludeRules.addAll(dependency.getExcludeRules());
        this.attributes = attributes;
    }

    @Override
    public String getOrganisation() {
        return this.organisation;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public String getConfMapping() {
        return this.confMapping;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public Iterable<DependencyArtifact> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public Iterable<ExcludeRule> getExcludeRules() {
        return this.excludeRules;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public String getProjectPath() {
        return null;
    }
}

