/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.deployment.internal;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.deployment.internal.ContinuousExecutionGate;
import org.gradle.internal.UncheckedException;

public class DefaultContinuousExecutionGate
implements ContinuousExecutionGate {
    private final Lock lock = new ReentrantLock();
    private final Condition opened = this.lock.newCondition();
    private final List<ContinuousExecutionGate.GateKeeper> gatekeepers = Lists.newArrayList();
    private ContinuousExecutionGate.GateKeeper openedBy;

    @Override
    public ContinuousExecutionGate.GateKeeper createGateKeeper() {
        this.lock.lock();
        try {
            DefaultExecutionGateKeeper gatekeeper = new DefaultExecutionGateKeeper(this);
            this.gatekeepers.add(gatekeeper);
            DefaultExecutionGateKeeper defaultExecutionGateKeeper = gatekeeper;
            return defaultExecutionGateKeeper;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void open(ContinuousExecutionGate.GateKeeper gatekeeper) {
        this.lock.lock();
        try {
            if (this.isClosed()) {
                this.openedBy = gatekeeper;
                this.opened.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isClosed() {
        return this.openedBy == null;
    }

    private void close(ContinuousExecutionGate.GateKeeper gatekeeper) {
        this.lock.lock();
        try {
            if (gatekeeper.equals(this.openedBy)) {
                this.openedBy = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void waitForOpen() {
        this.lock.lock();
        try {
            if (!this.gatekeepers.isEmpty()) {
                while (this.isClosed()) {
                    this.opened.await();
                }
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "Gate is " + (!this.isClosed() ? "open" : "closed");
    }

    private static class DefaultExecutionGateKeeper
    implements ContinuousExecutionGate.GateKeeper {
        private final DefaultContinuousExecutionGate continuousExecutionGate;

        private DefaultExecutionGateKeeper(DefaultContinuousExecutionGate continuousExecutionGate) {
            this.continuousExecutionGate = continuousExecutionGate;
        }

        @Override
        public void open() {
            this.continuousExecutionGate.open(this);
        }

        @Override
        public void close() {
            this.continuousExecutionGate.close(this);
        }
    }
}

