/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.local.model.DefaultProjectDependencyMetadata;
import org.gradle.internal.component.model.AttributeConfigurationSelector;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantSelectionResult;

public class ConfigurationBoundExternalDependencyMetadata
implements ModuleDependencyMetadata {
    private final ConfigurationMetadata configuration;
    private final ModuleComponentIdentifier componentId;
    private final ExternalDependencyDescriptor dependencyDescriptor;
    private final String reason;
    private final boolean isTransitive;
    private final boolean isConstraint;
    private final boolean isEndorsing;
    private final List<IvyArtifactName> artifacts;
    private boolean alwaysUseAttributeMatching;

    private ConfigurationBoundExternalDependencyMetadata(ConfigurationMetadata configuration, ModuleComponentIdentifier componentId, ExternalDependencyDescriptor dependencyDescriptor, boolean alwaysUseAttributeMatching, String reason, boolean endorsing) {
        this(configuration, componentId, dependencyDescriptor, alwaysUseAttributeMatching, reason, endorsing, dependencyDescriptor.getConfigurationArtifacts(configuration));
    }

    private ConfigurationBoundExternalDependencyMetadata(ConfigurationMetadata configuration, ModuleComponentIdentifier componentId, ExternalDependencyDescriptor dependencyDescriptor, boolean alwaysUseAttributeMatching, String reason, boolean endorsing, List<IvyArtifactName> artifacts) {
        this.configuration = configuration;
        this.componentId = componentId;
        this.dependencyDescriptor = dependencyDescriptor;
        this.alwaysUseAttributeMatching = alwaysUseAttributeMatching;
        this.reason = reason;
        this.isTransitive = dependencyDescriptor.isTransitive();
        this.isConstraint = dependencyDescriptor.isConstraint();
        this.isEndorsing = endorsing;
        this.artifacts = artifacts;
    }

    private ConfigurationBoundExternalDependencyMetadata(ConfigurationMetadata configuration, ModuleComponentIdentifier componentId, ExternalDependencyDescriptor dependencyDescriptor, boolean alwaysUseAttributeMatching, String reason) {
        this(configuration, componentId, dependencyDescriptor, alwaysUseAttributeMatching, reason, false);
    }

    private ConfigurationBoundExternalDependencyMetadata(ConfigurationMetadata configuration, ModuleComponentIdentifier componentId, ExternalDependencyDescriptor dependencyDescriptor, boolean alwaysUseAttributeMatching) {
        this(configuration, componentId, dependencyDescriptor, alwaysUseAttributeMatching, null);
    }

    public ConfigurationBoundExternalDependencyMetadata(ConfigurationMetadata configuration, ModuleComponentIdentifier componentId, ExternalDependencyDescriptor dependencyDescriptor) {
        this(configuration, componentId, dependencyDescriptor, false, null);
    }

    public ConfigurationBoundExternalDependencyMetadata alwaysUseAttributeMatching() {
        this.alwaysUseAttributeMatching = true;
        return this;
    }

    public ExternalDependencyDescriptor getDependencyDescriptor() {
        return this.dependencyDescriptor;
    }

    @Override
    public VariantSelectionResult selectVariants(ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, Collection<? extends Capability> explicitRequestedCapabilities) {
        if (this.alwaysUseAttributeMatching || this.hasVariants(targetComponentState.getMetadata())) {
            return AttributeConfigurationSelector.selectVariantsUsingAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, this.getArtifacts());
        }
        return this.dependencyDescriptor.selectLegacyConfigurations((ComponentIdentifier)this.componentId, this.configuration, targetComponentState);
    }

    private boolean hasVariants(ComponentGraphResolveMetadata targetComponent) {
        return targetComponent.getVariantsForGraphTraversal().isPresent();
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.dependencyDescriptor.getConfigurationExcludes((Collection<String>)this.configuration.getHierarchy());
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(moduleTarget.getModuleIdentifier(), moduleTarget.getVersionConstraint(), moduleTarget.getAttributes(), moduleTarget.getRequestedCapabilities());
            if (newSelector.equals(this.getSelector())) {
                return this;
            }
            return this.withRequested(newSelector);
        }
        if (target instanceof ProjectComponentSelector) {
            ProjectComponentSelector projectTarget = (ProjectComponentSelector)target;
            return new DefaultProjectDependencyMetadata(projectTarget, this);
        }
        throw new IllegalArgumentException("Unexpected selector provided: " + target);
    }

    @Override
    public DependencyMetadata withTargetAndArtifacts(ComponentSelector target, List<IvyArtifactName> artifacts) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(moduleTarget.getModuleIdentifier(), moduleTarget.getVersionConstraint(), moduleTarget.getAttributes(), moduleTarget.getRequestedCapabilities());
            if (newSelector.equals(this.getSelector()) && this.getArtifacts().equals(artifacts)) {
                return this;
            }
            return this.withRequestedAndArtifacts(newSelector, artifacts);
        }
        if (target instanceof ProjectComponentSelector) {
            ProjectComponentSelector projectTarget = (ProjectComponentSelector)target;
            return new DefaultProjectDependencyMetadata(projectTarget, this);
        }
        throw new IllegalArgumentException("Unexpected selector provided: " + target);
    }

    @Override
    public ModuleDependencyMetadata withRequestedVersion(VersionConstraint requestedVersion) {
        ModuleComponentSelector selector = this.getSelector();
        if (requestedVersion.equals(selector.getVersionConstraint())) {
            return this;
        }
        ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getModuleIdentifier(), requestedVersion, selector.getAttributes(), selector.getRequestedCapabilities());
        return this.withRequested(newSelector);
    }

    @Override
    public ModuleDependencyMetadata withReason(String reason) {
        if (Objects.equal((Object)reason, (Object)this.getReason())) {
            return this;
        }
        return new ConfigurationBoundExternalDependencyMetadata(this.configuration, this.componentId, this.dependencyDescriptor, this.alwaysUseAttributeMatching, reason);
    }

    @Override
    public ModuleDependencyMetadata withEndorseStrictVersions(boolean endorse) {
        if (this.isEndorsing == endorse) {
            return this;
        }
        return new ConfigurationBoundExternalDependencyMetadata(this.configuration, this.componentId, this.dependencyDescriptor, this.alwaysUseAttributeMatching, this.reason, endorse);
    }

    public ConfigurationBoundExternalDependencyMetadata withDescriptor(ExternalDependencyDescriptor descriptor) {
        return new ConfigurationBoundExternalDependencyMetadata(this.configuration, this.componentId, descriptor, this.alwaysUseAttributeMatching);
    }

    private ModuleDependencyMetadata withRequested(ModuleComponentSelector newSelector) {
        ExternalDependencyDescriptor newDelegate = this.dependencyDescriptor.withRequested(newSelector);
        return new ConfigurationBoundExternalDependencyMetadata(this.configuration, this.componentId, newDelegate, this.alwaysUseAttributeMatching);
    }

    private ModuleDependencyMetadata withRequestedAndArtifacts(ModuleComponentSelector newSelector, List<IvyArtifactName> artifacts) {
        ExternalDependencyDescriptor newDelegate = this.dependencyDescriptor.withRequested(newSelector);
        return new ConfigurationBoundExternalDependencyMetadata(this.configuration, this.componentId, newDelegate, this.alwaysUseAttributeMatching, this.reason, this.isEndorsing, artifacts);
    }

    @Override
    public ModuleComponentSelector getSelector() {
        return this.dependencyDescriptor.getSelector();
    }

    @Override
    public boolean isChanging() {
        return this.dependencyDescriptor.isChanging();
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive;
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    @Override
    public boolean isEndorsingStrictVersions() {
        return this.isEndorsing;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return this.dependencyDescriptor.toString();
    }
}

