/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationDetails;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.ReportGenerator;
import org.gradle.api.tasks.diagnostics.internal.dependencies.AsciiDependencyReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.serialization.Cached;

@UntrackedTask(because="Produces only non-cacheable console output")
public class BuildEnvironmentReportTask
extends DefaultTask {
    public static final String TASK_NAME = "buildEnvironment";
    private DependencyReportRenderer renderer = new AsciiDependencyReportRenderer();
    final Cached<BuildEnvironmentReportModel> reportModel = Cached.of(this::calculateReportModel);

    private BuildEnvironmentReportModel calculateReportModel() {
        return new BuildEnvironmentReportModel(ProjectDetails.of(this.getProject()), ConfigurationDetails.of(this.classpathConfiguration()));
    }

    private Configuration classpathConfiguration() {
        return this.getProject().getBuildscript().getConfigurations().getByName("classpath");
    }

    @Inject
    protected BuildClientMetaData getClientMetaData() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void generate() {
        this.reportGenerator().generateReport(Collections.singleton((BuildEnvironmentReportModel)this.reportModel.get()), model -> ((BuildEnvironmentReportModel)model).project, model -> {
            this.renderer.startConfiguration(((BuildEnvironmentReportModel)model).configuration);
            this.renderer.render(((BuildEnvironmentReportModel)model).configuration);
            this.renderer.completeConfiguration(((BuildEnvironmentReportModel)model).configuration);
        });
    }

    private ReportGenerator reportGenerator() {
        return new ReportGenerator(this.renderer, this.getClientMetaData(), null, this.getTextOutputFactory());
    }

    @VisibleForTesting
    protected void setRenderer(DependencyReportRenderer dependencyReportRenderer) {
        this.renderer = dependencyReportRenderer;
    }

    private static final class BuildEnvironmentReportModel {
        private final ProjectDetails project;
        private final ConfigurationDetails configuration;

        public BuildEnvironmentReportModel(ProjectDetails project, ConfigurationDetails configuration) {
            this.project = project;
            this.configuration = configuration;
        }
    }
}

