/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.validation;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.validation.PublicationWithProject;

public class DuplicatePublicationTracker {
    private static final Logger LOG = Logging.getLogger(DuplicatePublicationTracker.class);
    private final Multimap<String, PublicationWithProject> published = LinkedHashMultimap.create();

    public synchronized void checkCanPublish(Project project, PublicationInternal<?> publication, @Nullable URI repositoryLocation, String repositoryName) {
        if (repositoryLocation == null) {
            return;
        }
        String repositoryKey = this.normalizeLocation(repositoryLocation);
        PublicationWithProject publicationWithProject = new PublicationWithProject(project.getDisplayName(), publication);
        if (this.published.get((Object)repositoryKey).contains(publicationWithProject)) {
            LOG.warn("Publication '" + publication.getCoordinates() + "' is published multiple times to the same location. It is likely that repository '" + repositoryName + "' is duplicated.");
            return;
        }
        ModuleVersionIdentifier projectIdentity = publication.getCoordinates();
        for (PublicationWithProject previousPublicationWithProject : this.published.get((Object)repositoryKey)) {
            if (!previousPublicationWithProject.getPublication().getCoordinates().equals(projectIdentity)) continue;
            String firstPublication = previousPublicationWithProject.toString();
            String secondPublication = publicationWithProject.toString();
            if (secondPublication.compareTo(firstPublication) < 0) {
                String temp = firstPublication;
                firstPublication = secondPublication;
                secondPublication = temp;
            }
            LOG.warn("Multiple publications with coordinates '" + publication.getCoordinates() + "' are published to repository '" + repositoryName + "'. The publications " + firstPublication + " and " + secondPublication + " will overwrite each other!");
        }
        this.published.put((Object)repositoryKey, (Object)publicationWithProject);
    }

    private String normalizeLocation(URI location) {
        String repoUrl = location.toString();
        if (!repoUrl.endsWith("/")) {
            return repoUrl + "/";
        }
        return repoUrl;
    }
}

