/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.internal.TaskInternal;
import org.gradle.execution.plan.FinalizerGroup;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeGroup;
import org.gradle.execution.plan.TaskInAnotherBuild;
import org.gradle.internal.deprecation.DeprecationLogger;

public abstract class TaskNode
extends Node {
    private final NavigableSet<Node> mustSuccessors = Sets.newTreeSet();
    private final Set<Node> mustPredecessors = Sets.newHashSet();
    private final NavigableSet<Node> shouldSuccessors = Sets.newTreeSet();
    private final NavigableSet<Node> finalizers = Sets.newTreeSet();
    private final NavigableSet<Node> finalizingSuccessors = Sets.newTreeSet();

    @Override
    public Node.DependenciesState doCheckDependenciesComplete() {
        Node.DependenciesState state = super.doCheckDependenciesComplete();
        if (state != Node.DependenciesState.COMPLETE_AND_SUCCESSFUL) {
            return state;
        }
        for (Node dependency : this.mustSuccessors) {
            if (dependency.isComplete()) continue;
            return Node.DependenciesState.NOT_COMPLETE;
        }
        return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
    }

    public Set<Node> getMustSuccessors() {
        return this.mustSuccessors;
    }

    public abstract Set<Node> getLifecycleSuccessors();

    public abstract void setLifecycleSuccessors(Set<Node> var1);

    @Override
    public Set<Node> getFinalizers() {
        return this.finalizers;
    }

    @Override
    public void addFinalizer(Node finalizer) {
        this.finalizers.add(finalizer);
    }

    @Override
    public Set<Node> getFinalizingSuccessors() {
        return this.finalizingSuccessors;
    }

    public Set<Node> getShouldSuccessors() {
        return this.shouldSuccessors;
    }

    public void addMustSuccessor(TaskNode toNode) {
        this.deprecateLifecycleHookReferencingNonLocalTask("mustRunAfter", toNode);
        this.mustSuccessors.add(toNode);
        toNode.mustPredecessors.add(this);
    }

    public void addFinalizingSuccessor(Node finalized) {
        this.finalizingSuccessors.add(finalized);
        finalized.addFinalizer(this);
    }

    public void addShouldSuccessor(Node toNode) {
        this.deprecateLifecycleHookReferencingNonLocalTask("shouldRunAfter", toNode);
        this.shouldSuccessors.add(toNode);
    }

    public void removeShouldSuccessor(TaskNode toNode) {
        this.shouldSuccessors.remove(toNode);
    }

    @Override
    public Iterable<Node> getAllSuccessors() {
        return Iterables.concat(this.shouldSuccessors, this.getGroup().getSuccessorsFor(this), this.mustSuccessors, super.getAllSuccessors());
    }

    @Override
    public Iterable<Node> getHardSuccessors() {
        return Iterables.concat(this.getGroup().getSuccessorsFor(this), this.mustSuccessors, super.getHardSuccessors());
    }

    @Override
    public Iterable<Node> getAllSuccessorsInReverseOrder() {
        return Iterables.concat(super.getAllSuccessorsInReverseOrder(), this.mustSuccessors.descendingSet(), this.getGroup().getSuccessorsInReverseOrderFor(this), this.shouldSuccessors.descendingSet());
    }

    @Override
    protected void visitAllNodesWaitingForThisNode(Consumer<Node> visitor) {
        super.visitAllNodesWaitingForThisNode(visitor);
        for (Node node : this.mustPredecessors) {
            visitor.accept(node);
        }
        for (Node node : this.finalizers) {
            node.getFinalizerGroup().visitAllMembers(visitor);
        }
    }

    public abstract TaskInternal getTask();

    protected void deprecateLifecycleHookReferencingNonLocalTask(String hookName, Node taskNode) {
        if (taskNode instanceof TaskInAnotherBuild) {
            DeprecationLogger.deprecateAction((String)("Using " + hookName + " to reference tasks from another build")).willBecomeAnErrorInGradle8().withUpgradeGuideSection(6, "referencing_tasks_from_included_builds").nagUser();
        }
    }

    @Override
    public void updateGroupOfFinalizer() {
        super.updateGroupOfFinalizer();
        if (!this.getFinalizingSuccessors().isEmpty()) {
            NodeGroup oldGroup = this.getGroup();
            FinalizerGroup finalizerGroup = new FinalizerGroup(this, oldGroup);
            this.setGroup(finalizerGroup);
        }
    }
}

