/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.AutoDetectingInstallationSupplier;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class WindowsInstallationSupplier
extends AutoDetectingInstallationSupplier {
    private final WindowsRegistry windowsRegistry;
    private final OperatingSystem os;

    public WindowsInstallationSupplier(WindowsRegistry registry, OperatingSystem os, ProviderFactory providerFactory) {
        super(providerFactory);
        this.windowsRegistry = registry;
        this.os = os;
    }

    @Override
    protected Set<InstallationLocation> findCandidates() {
        if (this.os.isWindows()) {
            return this.findInstallationsInRegistry();
        }
        return Collections.emptySet();
    }

    private Set<InstallationLocation> findInstallationsInRegistry() {
        Stream openJdkInstallations = this.findAdoptOpenJdk().stream();
        Stream jvms = Lists.newArrayList((Object[])new String[]{"SOFTWARE\\JavaSoft\\JDK", "SOFTWARE\\JavaSoft\\Java Development Kit", "SOFTWARE\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Development Kit", "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Runtime Environment"}).stream().map(this::findJvms).flatMap(Collection::stream);
        return Stream.concat(openJdkInstallations, jvms).map(javaHome -> new InstallationLocation(new File((String)javaHome), "Windows Registry")).collect(Collectors.toSet());
    }

    private List<String> find(String sdkSubkey, String path, String value) {
        try {
            return this.getVersions(sdkSubkey).stream().map(version -> this.getValue(sdkSubkey, path, value, (String)version)).collect(Collectors.toList());
        }
        catch (MissingRegistryEntryException e) {
            return Collections.emptyList();
        }
    }

    private List<String> getVersions(String sdkSubkey) {
        return this.windowsRegistry.getSubkeys(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, sdkSubkey);
    }

    private String getValue(String sdkSubkey, String path, String value, String version) {
        return this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, sdkSubkey + '\\' + version + path, value);
    }

    private List<String> findAdoptOpenJdk() {
        return this.find("SOFTWARE\\AdoptOpenJDK\\JDK", "\\hotspot\\MSI", "Path");
    }

    private List<String> findJvms(String sdkSubkey) {
        return this.find(sdkSubkey, "", "JavaHome");
    }
}

