/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.artifacts.DownloadArtifactBuildOperationType;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class ArtifactBackedResolvedVariant
implements ResolvedVariant {
    private final VariantResolveMetadata.Identifier identifier;
    private final DisplayName displayName;
    private final AttributeContainerInternal attributes;
    private final CapabilitiesMetadata capabilities;
    private final ResolvedArtifactSet artifacts;

    private ArtifactBackedResolvedVariant(@Nullable VariantResolveMetadata.Identifier identifier, DisplayName displayName, AttributeContainerInternal attributes, CapabilitiesMetadata capabilities, ResolvedArtifactSet artifacts) {
        this.identifier = identifier;
        this.displayName = displayName;
        this.attributes = attributes;
        this.capabilities = capabilities;
        this.artifacts = artifacts;
    }

    public static ResolvedVariant create(@Nullable VariantResolveMetadata.Identifier identifier, DisplayName displayName, AttributeContainerInternal attributes, CapabilitiesMetadata capabilities, Collection<? extends ResolvableArtifact> artifacts) {
        if (artifacts.isEmpty()) {
            return new ArtifactBackedResolvedVariant(identifier, displayName, attributes, capabilities, ResolvedArtifactSet.EMPTY);
        }
        if (artifacts.size() == 1) {
            return new ArtifactBackedResolvedVariant(identifier, displayName, attributes, capabilities, new SingleArtifactSet(displayName, (AttributeContainer)attributes, capabilities, artifacts.iterator().next()));
        }
        ArrayList<SingleArtifactSet> artifactSets = new ArrayList<SingleArtifactSet>(artifacts.size());
        for (ResolvableArtifact resolvableArtifact : artifacts) {
            artifactSets.add(new SingleArtifactSet(displayName, (AttributeContainer)attributes, capabilities, resolvableArtifact));
        }
        return new ArtifactBackedResolvedVariant(identifier, displayName, attributes, capabilities, CompositeResolvedArtifactSet.of(artifactSets));
    }

    @Override
    public VariantResolveMetadata.Identifier getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.displayName.getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return this.displayName;
    }

    @Override
    public ResolvedArtifactSet getArtifacts() {
        return this.artifacts;
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.attributes;
    }

    @Override
    public CapabilitiesMetadata getCapabilities() {
        return this.capabilities;
    }

    private static class DownloadArtifactFile
    implements RunnableBuildOperation {
        private final ResolvableArtifact artifact;

        DownloadArtifactFile(ResolvableArtifact artifact) {
            this.artifact = artifact;
        }

        public void run(BuildOperationContext context) {
            this.artifact.getFileSource().finalizeIfNotAlready();
            context.setResult((Object)DownloadArtifactBuildOperationType.RESULT);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Resolve " + this.artifact)).details((Object)new DownloadArtifactBuildOperationType.DetailsImpl(this.artifact.getId().getDisplayName()));
        }
    }

    private static class SingleArtifactSet
    implements ResolvedArtifactSet,
    ResolvedArtifactSet.Artifacts {
        private final DisplayName variantName;
        private final AttributeContainer variantAttributes;
        private final CapabilitiesMetadata capabilities;
        private final ResolvableArtifact artifact;

        SingleArtifactSet(DisplayName variantName, AttributeContainer variantAttributes, CapabilitiesMetadata capabilities, ResolvableArtifact artifact) {
            this.variantName = variantName;
            this.variantAttributes = variantAttributes;
            this.capabilities = capabilities;
            this.artifact = artifact;
        }

        @Override
        public void visit(ResolvedArtifactSet.Visitor visitor) {
            visitor.visitArtifacts(this);
        }

        @Override
        public void startFinalization(BuildOperationQueue<RunnableBuildOperation> actions, boolean requireFiles) {
            if (requireFiles) {
                if (this.artifact.isResolveSynchronously()) {
                    this.artifact.getFileSource().finalizeIfNotAlready();
                } else {
                    actions.add((BuildOperation)new DownloadArtifactFile(this.artifact));
                }
            }
        }

        @Override
        public void finalizeNow(boolean requireFiles) {
            if (requireFiles) {
                this.artifact.getFileSource().finalizeIfNotAlready();
            }
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            if (visitor.requireArtifactFiles() && !this.artifact.getFileSource().getValue().isSuccessful()) {
                visitor.visitFailure((Throwable)this.artifact.getFileSource().getValue().getFailure().get());
            } else {
                visitor.visitArtifact(this.variantName, this.variantAttributes, this.capabilities.getCapabilities(), this.artifact);
                visitor.endVisitCollection(FileCollectionInternal.OTHER);
            }
        }

        @Override
        public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
            if (this.artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) {
                visitor.visitArtifact(this.artifact);
            }
        }

        @Override
        public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
            if (!(this.artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier)) {
                visitor.execute((Object)this.artifact);
            }
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add((Object)this.artifact);
        }

        public String toString() {
            return this.artifact.getId().getDisplayName();
        }
    }
}

