/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.PathUtil;

public class VfsRelativePath {
    private final String absolutePath;
    private final int offset;

    public static VfsRelativePath of(String absolutePath) {
        String normalizedRoot = VfsRelativePath.normalizeRoot(absolutePath);
        return VfsRelativePath.of(normalizedRoot, VfsRelativePath.determineOffset(normalizedRoot));
    }

    @VisibleForTesting
    static VfsRelativePath of(String absolutePath, int offset) {
        return new VfsRelativePath(absolutePath, offset);
    }

    private static String normalizeRoot(String absolutePath) {
        if (absolutePath.isEmpty() || absolutePath.equals("/")) {
            return absolutePath;
        }
        return PathUtil.isFileSeparator(absolutePath.charAt(absolutePath.length() - 1)) ? absolutePath.substring(0, absolutePath.length() - 1) : absolutePath;
    }

    private static int determineOffset(String absolutePath) {
        for (int i = 0; i < absolutePath.length(); ++i) {
            if (PathUtil.isFileSeparator(absolutePath.charAt(i))) continue;
            return i;
        }
        return absolutePath.length();
    }

    private VfsRelativePath(String absolutePath, int offset) {
        this.absolutePath = absolutePath;
        this.offset = offset;
    }

    public VfsRelativePath suffixStartingFrom(int startIndex) {
        return new VfsRelativePath(this.absolutePath, this.offset + startIndex);
    }

    public VfsRelativePath fromChild(String relativeChildPath) {
        return relativeChildPath.isEmpty() ? this : this.suffixStartingFrom(relativeChildPath.length() + 1);
    }

    public int length() {
        return this.absolutePath.length() - this.offset;
    }

    public String getAsString() {
        return this.absolutePath.substring(this.offset);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public int lengthOfCommonPrefix(String relativePath, CaseSensitivity caseSensitivity) {
        char charInPath2;
        char charInPath1;
        int pos;
        int lastSeparator = 0;
        int maxPos = Math.min(relativePath.length(), this.absolutePath.length() - this.offset);
        for (pos = 0; pos < maxPos && PathUtil.equalChars(charInPath1 = relativePath.charAt(pos), charInPath2 = this.absolutePath.charAt(pos + this.offset), caseSensitivity); ++pos) {
            if (!PathUtil.isFileSeparator(charInPath1)) continue;
            lastSeparator = pos;
        }
        if (pos == maxPos) {
            if (relativePath.length() == this.absolutePath.length() - this.offset) {
                return pos;
            }
            if (pos < relativePath.length() && PathUtil.isFileSeparator(relativePath.charAt(pos))) {
                return pos;
            }
            if (pos < this.absolutePath.length() - this.offset && PathUtil.isFileSeparator(this.absolutePath.charAt(pos + this.offset))) {
                return pos;
            }
        }
        return lastSeparator;
    }

    public int compareToFirstSegment(String relativePath, CaseSensitivity caseSensitivity) {
        int maxPos = Math.min(relativePath.length(), this.absolutePath.length() - this.offset);
        int accumulatedValue = 0;
        for (int pos = 0; pos < maxPos; ++pos) {
            char charInPath2;
            char charInPath1 = this.absolutePath.charAt(pos + this.offset);
            int comparedChars = PathUtil.compareCharsIgnoringCase(charInPath1, charInPath2 = relativePath.charAt(pos));
            if (comparedChars != 0) {
                return comparedChars;
            }
            accumulatedValue = VfsRelativePath.computeCombinedCompare(accumulatedValue, charInPath1, charInPath2, caseSensitivity == CaseSensitivity.CASE_SENSITIVE);
            if (!PathUtil.isFileSeparator(charInPath1) || pos <= 0) continue;
            return accumulatedValue;
        }
        if (this.absolutePath.length() - this.offset == relativePath.length()) {
            return accumulatedValue;
        }
        if (this.absolutePath.length() - this.offset > relativePath.length()) {
            return PathUtil.isFileSeparator(this.absolutePath.charAt(maxPos + this.offset)) ? accumulatedValue : 1;
        }
        return PathUtil.isFileSeparator(relativePath.charAt(maxPos)) ? accumulatedValue : -1;
    }

    public boolean hasPrefix(String prefix, CaseSensitivity caseSensitivity) {
        int endOfThisSegment;
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            return true;
        }
        int pathLength = this.absolutePath.length();
        if (pathLength < (endOfThisSegment = prefixLength + this.offset)) {
            return false;
        }
        int i = prefixLength - 1;
        int j = endOfThisSegment - 1;
        while (i >= 0) {
            if (!PathUtil.equalChars(prefix.charAt(i), this.absolutePath.charAt(j), caseSensitivity)) {
                return false;
            }
            --i;
            --j;
        }
        return endOfThisSegment == pathLength || PathUtil.isFileSeparator(this.absolutePath.charAt(endOfThisSegment));
    }

    public boolean isPrefixOf(String otherPath, CaseSensitivity caseSensitivity) {
        int prefixLength = this.length();
        if (prefixLength == 0) {
            return true;
        }
        int endOfThisSegment = prefixLength + this.offset;
        int pathLength = otherPath.length();
        if (pathLength < prefixLength) {
            return false;
        }
        int i = prefixLength - 1;
        int j = endOfThisSegment - 1;
        while (i >= 0) {
            if (!PathUtil.equalChars(otherPath.charAt(i), this.absolutePath.charAt(j), caseSensitivity)) {
                return false;
            }
            --i;
            --j;
        }
        return prefixLength == pathLength || PathUtil.isFileSeparator(otherPath.charAt(prefixLength));
    }

    private static int computeCombinedCompare(int previousCombinedValue, char charInPath1, char charInPath2, boolean caseSensitive) {
        if (!caseSensitive) {
            return 0;
        }
        return previousCombinedValue == 0 ? PathUtil.compareChars(charInPath1, charInPath2) : previousCombinedValue;
    }

    public String toString() {
        return this.getAsString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VfsRelativePath that = (VfsRelativePath)o;
        if (this.offset != that.offset) {
            return false;
        }
        return this.absolutePath.equals(that.absolutePath);
    }

    public int hashCode() {
        int result = this.absolutePath.hashCode();
        result = 31 * result + this.offset;
        return result;
    }
}

