/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.internal.MutableReference;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.ValidationFinishedContext;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.internal.reflect.validation.ValidationProblemBuilder;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.model.internal.type.ModelType;
import org.gradle.problems.BaseProblem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateStep<C extends BeforeExecutionContext, R extends Result>
implements Step<C, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateStep.class);
    private static final String MAX_NB_OF_ERRORS = "org.gradle.internal.max.validation.errors";
    private final VirtualFileSystem virtualFileSystem;
    private final ValidationWarningRecorder warningReporter;
    private final Step<? super ValidationFinishedContext, ? extends R> delegate;

    public ValidateStep(VirtualFileSystem virtualFileSystem, ValidationWarningRecorder warningReporter, Step<? super ValidationFinishedContext, ? extends R> delegate) {
        this.virtualFileSystem = virtualFileSystem;
        this.warningReporter = warningReporter;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        WorkValidationContext validationContext = context.getValidationContext();
        work.validate(validationContext);
        context.getBeforeExecutionState().ifPresent(beforeExecutionState -> this.validateImplementations(work, (BeforeExecutionState)beforeExecutionState, validationContext));
        Map problems = validationContext.getProblems().stream().collect(Collectors.groupingBy(BaseProblem::getSeverity, Collectors.mapping(ValidateStep::renderedMessage, Collectors.toList())));
        ImmutableList warnings = ImmutableList.copyOf((Collection)((Collection)problems.getOrDefault(Severity.WARNING, ImmutableList.of())));
        ImmutableList errors = ImmutableList.copyOf((Collection)((Collection)problems.getOrDefault(Severity.ERROR, ImmutableList.of())));
        if (!warnings.isEmpty()) {
            this.warningReporter.recordValidationWarnings(work, (Collection<String>)warnings);
        }
        if (!errors.isEmpty()) {
            int maxErrCount = Integer.getInteger(MAX_NB_OF_ERRORS, 5);
            ImmutableSortedSet uniqueSortedErrors = ImmutableSortedSet.copyOf((Collection)errors);
            throw WorkValidationException.forProblems((Collection<String>)uniqueSortedErrors).limitTo(maxErrCount).withSummary(helper -> String.format("%s found with the configuration of %s (%s).", helper.size() == 1 ? "A problem was" : "Some problems were", work.getDisplayName(), ValidateStep.describeTypesChecked(validationContext.getValidatedTypes()))).get();
        }
        if (!warnings.isEmpty()) {
            LOGGER.info("Invalidating VFS because {} failed validation", (Object)work.getDisplayName());
            this.virtualFileSystem.invalidateAll();
        }
        return this.delegate.execute(work, new ValidationFinishedContext((BeforeExecutionContext)context, (ImmutableCollection)warnings){
            final /* synthetic */ BeforeExecutionContext val$context;
            final /* synthetic */ ImmutableCollection val$warnings;
            {
                this.val$context = beforeExecutionContext;
                this.val$warnings = immutableCollection;
            }

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return this.val$context.getBeforeExecutionState();
            }

            @Override
            public Optional<ValidationFinishedContext.ValidationResult> getValidationProblems() {
                return this.val$warnings.isEmpty() ? Optional.empty() : Optional.of(() -> this.val$warnings);
            }

            @Override
            public Optional<PreviousExecutionState> getPreviousExecutionState() {
                return this.val$context.getPreviousExecutionState();
            }

            @Override
            public File getWorkspace() {
                return this.val$context.getWorkspace();
            }

            @Override
            public Optional<ExecutionHistoryStore> getHistory() {
                return this.val$context.getHistory();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return this.val$context.getInputProperties();
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return this.val$context.getInputFileProperties();
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return this.val$context.getIdentity();
            }

            @Override
            public Optional<String> getNonIncrementalReason() {
                return this.val$context.getNonIncrementalReason();
            }

            @Override
            public WorkValidationContext getValidationContext() {
                return this.val$context.getValidationContext();
            }
        });
    }

    private void validateImplementations(UnitOfWork work, BeforeExecutionState beforeExecutionState, WorkValidationContext validationContext) {
        final MutableReference workClass = MutableReference.empty();
        work.visitImplementations(new UnitOfWork.ImplementationVisitor(){

            @Override
            public void visitImplementation(Class<?> implementation) {
                workClass.set((Object)GeneratedSubclasses.unpack(implementation));
            }

            @Override
            public void visitImplementation(ImplementationSnapshot implementation) {
            }
        });
        Class workType = (Class)workClass.get();
        TypeValidationContext workValidationContext = validationContext.forType(workType, true);
        this.validateImplementation(workValidationContext, beforeExecutionState.getImplementation(), "Implementation of ", work);
        beforeExecutionState.getAdditionalImplementations().forEach(additionalImplementation -> this.validateImplementation(workValidationContext, (ImplementationSnapshot)additionalImplementation, "Additional action of ", work));
        beforeExecutionState.getInputProperties().forEach((propertyName, valueSnapshot) -> {
            if (valueSnapshot instanceof ImplementationSnapshot) {
                ImplementationSnapshot implementationSnapshot = (ImplementationSnapshot)valueSnapshot;
                this.validateNestedInput(workValidationContext, (String)propertyName, implementationSnapshot);
            }
        });
    }

    private void validateNestedInput(TypeValidationContext workValidationContext, String propertyName, ImplementationSnapshot implementationSnapshot) {
        if (implementationSnapshot.isUnknown()) {
            workValidationContext.visitPropertyProblem(problem -> {
                ImplementationSnapshot.UnknownReason unknownReason = implementationSnapshot.getUnknownReason();
                ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)this.configureImplementationValidationProblem((ValidationProblemBuilder)problem)).forProperty(propertyName).withDescription(() -> unknownReason.descriptionFor(implementationSnapshot))).happensBecause(unknownReason.getReason())).addPossibleSolution(unknownReason.getSolution());
            });
        }
    }

    private void validateImplementation(TypeValidationContext workValidationContext, ImplementationSnapshot implementation, String descriptionPrefix, UnitOfWork work) {
        if (implementation.isUnknown()) {
            workValidationContext.visitPropertyProblem(problem -> {
                ImplementationSnapshot.UnknownReason unknownReason = implementation.getUnknownReason();
                ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)this.configureImplementationValidationProblem((ValidationProblemBuilder)problem)).withDescription(() -> descriptionPrefix + work + " " + unknownReason.descriptionFor(implementation))).happensBecause(unknownReason.getReason())).addPossibleSolution(unknownReason.getSolution());
            });
        }
    }

    private <T extends ValidationProblemBuilder<T>> T configureImplementationValidationProblem(ValidationProblemBuilder<T> problem) {
        return (T)problem.typeIsIrrelevantInErrorMessage().withId(ValidationProblemId.UNKNOWN_IMPLEMENTATION).reportAs(Severity.WARNING).documentedAt("validation_problems", "implementation_unknown");
    }

    private static String renderedMessage(TypeValidationProblem p) {
        if (((Severity)p.getSeverity()).isWarning()) {
            return TypeValidationProblemRenderer.convertToSingleLine((String)TypeValidationProblemRenderer.renderMinimalInformationAbout((TypeValidationProblem)p, (boolean)true, (boolean)false));
        }
        return TypeValidationProblemRenderer.renderMinimalInformationAbout((TypeValidationProblem)p);
    }

    private static String describeTypesChecked(ImmutableCollection<Class<?>> types) {
        return types.size() == 1 ? "type '" + ValidateStep.getTypeDisplayName((Class)types.iterator().next()) + "'" : "types '" + types.stream().map(ValidateStep::getTypeDisplayName).collect(Collectors.joining("', '")) + "'";
    }

    private static String getTypeDisplayName(Class<?> type) {
        return ModelType.of(type).getDisplayName();
    }

    public static interface ValidationWarningRecorder {
        public void recordValidationWarnings(UnitOfWork var1, Collection<String> var2);
    }
}

