/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.provider.runner.BuildOperationTracker;

class TestTaskExecutionTracker
implements BuildOperationTracker {
    private final BuildOperationAncestryTracker ancestryTracker;
    private final Map<Object, String> runningTasks = new ConcurrentHashMap<Object, String>();

    TestTaskExecutionTracker(BuildOperationAncestryTracker ancestryTracker) {
        this.ancestryTracker = ancestryTracker;
    }

    public String getTaskPath(OperationIdentifier buildOperationId) {
        return (String)this.ancestryTracker.findClosestExistingAncestor(buildOperationId, this.runningTasks::get).get();
    }

    @Override
    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        Object details = buildOperation.getDetails();
        if (details instanceof ExecuteTaskBuildOperationDetails) {
            TaskInternal task = ((ExecuteTaskBuildOperationDetails)details).getTask();
            if (!(task instanceof Test)) {
                return;
            }
            String previous = this.runningTasks.put(buildOperation.getId(), ((Test)task).getIdentityPath().getPath());
            if (previous != null) {
                throw new IllegalStateException("Build operation " + buildOperation.getId() + " already started.");
            }
        }
    }

    @Override
    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        if (buildOperation.getDetails() instanceof ExecuteTaskBuildOperationDetails) {
            this.runningTasks.remove(buildOperation.getId());
        }
    }
}

