/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.NestedBuildState;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;

public class DefaultBuildTreeFinishExecutor
implements BuildTreeFinishExecutor {
    private final BuildStateRegistry buildStateRegistry;
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildLifecycleController buildLifecycleController;

    public DefaultBuildTreeFinishExecutor(BuildStateRegistry buildStateRegistry, ExceptionAnalyser exceptionAnalyser, BuildLifecycleController buildLifecycleController) {
        this.buildStateRegistry = buildStateRegistry;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildLifecycleController = buildLifecycleController;
    }

    @Override
    @Nullable
    public RuntimeException finishBuildTree(List<Throwable> failures) {
        ArrayList<Throwable> allFailures = new ArrayList<Throwable>(failures);
        this.buildStateRegistry.visitBuilds(buildState -> {
            if (buildState instanceof NestedBuildState) {
                ExecutionResult<Void> result = ((NestedBuildState)buildState).finishBuild();
                allFailures.addAll(result.getFailures());
            }
        });
        RuntimeException reportableFailure = this.exceptionAnalyser.transform(allFailures);
        ExecutionResult<Void> finishResult = this.buildLifecycleController.finishBuild(reportableFailure);
        return this.exceptionAnalyser.transform(ExecutionResult.maybeFailed(reportableFailure).withFailures(finishResult).getFailures());
    }
}

