/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.SourceRangeInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J-\u0010\u0015\u001a\u0004\u0018\u0001H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u000fH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bH\u0016J\b\u0010%\u001a\u00020\u000fH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/PsiIrFileEntry;", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "psiFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "fileViewProvider", "Lorg/jetbrains/kotlin/com/intellij/psi/FileViewProvider;", "Lorg/jetbrains/annotations/NotNull;", "lineStartOffsets", "", "maxOffset", "", "getMaxOffset", "()I", "name", "", "getName", "()Ljava/lang/String;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "psiFileName", "findPsiElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "E", "psiElementClass", "Lkotlin/reflect/KClass;", "(Lorg/jetbrains/kotlin/ir/IrElement;Lkotlin/reflect/KClass;)Lcom/intellij/psi/PsiElement;", "getColumnNumber", "offset", "getLineNumber", "getRecognizableName", "getSourceRangeInfo", "Lorg/jetbrains/kotlin/ir/SourceRangeInfo;", "beginOffset", "endOffset", "toString", "ir.tree"})
public final class PsiIrFileEntry
implements IrFileEntry {
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final String psiFileName;
    private final int maxOffset;
    @NotNull
    private final int[] lineStartOffsets;
    @NotNull
    private final FileViewProvider fileViewProvider;

    public PsiIrFileEntry(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.psiFile = psiFile;
        UserDataHolder userDataHolder = this.psiFile.getVirtualFile();
        Object object = userDataHolder == null ? null : userDataHolder.getPath();
        Object object2 = object == null ? this.psiFile.getName() : object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"psiFile.virtualFile?.path ?: psiFile.name");
        this.psiFileName = object2;
        object2 = this.psiFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"psiFile.viewProvider");
        this.fileViewProvider = object2;
        userDataHolder = this.fileViewProvider.getDocument();
        if (userDataHolder == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"No document for ", (Object)this.psiFile));
        }
        Object document = object = userDataHolder;
        this.maxOffset = document.getTextLength();
        int n = 0;
        int n2 = document.getLineCount();
        int[] nArray = new int[n2];
        PsiIrFileEntry psiIrFileEntry = this;
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = document.getLineStartOffset(n3);
        }
        psiIrFileEntry.lineStartOffsets = nArray;
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    @Override
    public int getMaxOffset() {
        return this.maxOffset;
    }

    @Override
    public int getLineNumber(int offset2) {
        if (offset2 < 0) {
            return -1;
        }
        int index2 = ArraysKt.binarySearch$default((int[])this.lineStartOffsets, (int)offset2, (int)0, (int)0, (int)6, null);
        return index2 >= 0 ? index2 : -index2 - 2;
    }

    @Override
    public int getColumnNumber(int offset2) {
        if (offset2 < 0) {
            return -1;
        }
        int lineNumber = this.getLineNumber(offset2);
        if (lineNumber < 0) {
            return -1;
        }
        return offset2 - this.lineStartOffsets[lineNumber];
    }

    @Override
    @NotNull
    public SourceRangeInfo getSourceRangeInfo(int beginOffset, int endOffset) {
        return new SourceRangeInfo(this.getRecognizableName(), beginOffset, this.getLineNumber(beginOffset), this.getColumnNumber(beginOffset), endOffset, this.getLineNumber(endOffset), this.getColumnNumber(endOffset));
    }

    private final String getRecognizableName() {
        return this.psiFileName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getRecognizableName();
    }

    @NotNull
    public String toString() {
        return this.getRecognizableName();
    }

    @Nullable
    public final PsiElement findPsiElement(@NotNull IrElement irElement) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        for (psiElement = this.fileViewProvider.findElementAt(irElement.getStartOffset()); psiElement != null; psiElement = psiElement.getParent()) {
            int n = irElement.getEndOffset();
            TextRange textRange = psiElement.getTextRange();
            if (textRange == null ? false : n == textRange.getEndOffset()) break;
        }
        return psiElement;
    }

    @Nullable
    public final <E extends PsiElement> E findPsiElement(@NotNull IrElement irElement, @NotNull KClass<E> psiElementClass) {
        E e;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter(psiElementClass, (String)"psiElementClass");
        PsiElement psiElement = this.findPsiElement(irElement);
        if (psiElement == null) {
            e = null;
        } else {
            PsiElement psiElement2 = psiElement;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement2;
            boolean bl3 = false;
            e = (E)PsiTreeUtil.getParentOfType(it, JvmClassMappingKt.getJavaClass(psiElementClass), false);
        }
        return e;
    }
}

