/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

public interface JvmVendor {
    public String getRawVendor();

    public KnownJvmVendor getKnownVendor();

    public String getDisplayName();

    public static JvmVendor fromString(final String vendor) {
        return new JvmVendor(){

            @Override
            public String getRawVendor() {
                return vendor;
            }

            @Override
            public KnownJvmVendor getKnownVendor() {
                return KnownJvmVendor.parse(vendor);
            }

            @Override
            public String getDisplayName() {
                KnownJvmVendor knownVendor = this.getKnownVendor();
                if (knownVendor != KnownJvmVendor.UNKNOWN) {
                    return knownVendor.getDisplayName();
                }
                return this.getRawVendor();
            }
        };
    }

    public static enum KnownJvmVendor {
        ADOPTOPENJDK("adoptopenjdk", "AdoptOpenJDK"),
        AMAZON("amazon", "Amazon Corretto"),
        APPLE("apple", "Apple"),
        AZUL("azul systems", "Zulu"),
        BELLSOFT("bellsoft", "BellSoft Liberica"),
        GRAAL_VM("graalvm community", "GraalVM Community"),
        HEWLETT_PACKARD("hewlett-packard", "HP-UX"),
        IBM("ibm", "IBM"),
        MICROSOFT("microsoft", "Microsoft"),
        ORACLE("oracle", "Oracle"),
        SAP("sap se", "SAP SapMachine"),
        UNKNOWN("gradle", "Unknown Vendor");

        private final String indicatorString;
        private final String displayName;

        private KnownJvmVendor(String indicatorString, String displayName) {
            this.indicatorString = indicatorString;
            this.displayName = displayName;
        }

        private String getDisplayName() {
            return this.displayName;
        }

        static KnownJvmVendor parse(String rawVendor) {
            if (rawVendor == null) {
                return UNKNOWN;
            }
            rawVendor = rawVendor.toLowerCase();
            for (KnownJvmVendor jvmVendor : KnownJvmVendor.values()) {
                if (!rawVendor.contains(jvmVendor.indicatorString)) continue;
                return jvmVendor;
            }
            return UNKNOWN;
        }
    }
}

