/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.internal.build.BuildToolingModelAction;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.provider.action.BuildModelAction;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;

public class BuildModelActionRunner
implements BuildActionRunner {
    private final PayloadSerializer payloadSerializer;

    public BuildModelActionRunner(PayloadSerializer payloadSerializer) {
        this.payloadSerializer = payloadSerializer;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        if (!(action instanceof BuildModelAction)) {
            return BuildActionRunner.Result.nothing();
        }
        BuildModelAction buildModelAction = (BuildModelAction)action;
        ModelCreateAction createAction = new ModelCreateAction(buildModelAction);
        try {
            if (buildModelAction.isCreateModel()) {
                Object result = buildController.fromBuildModel(buildModelAction.isRunTasks(), (BuildToolingModelAction)createAction);
                SerializedPayload serializedResult = this.payloadSerializer.serialize(result);
                return BuildActionRunner.Result.of((Object)serializedResult);
            }
            buildController.scheduleAndRunTasks();
            return BuildActionRunner.Result.of(null);
        }
        catch (RuntimeException e) {
            RuntimeException clientFailure = e;
            if (createAction.modelLookupFailure != null) {
                clientFailure = (RuntimeException)new InternalUnsupportedModelException().initCause((Throwable)createAction.modelLookupFailure);
            }
            return BuildActionRunner.Result.failed((Throwable)e, (RuntimeException)clientFailure);
        }
    }

    private static class ModelCreateAction
    implements BuildToolingModelAction<Object> {
        private final BuildModelAction buildModelAction;
        private UnknownModelException modelLookupFailure;

        public ModelCreateAction(BuildModelAction buildModelAction) {
            this.buildModelAction = buildModelAction;
        }

        public void beforeTasks(BuildToolingModelController controller) {
        }

        public Object fromBuildModel(BuildToolingModelController controller) {
            ToolingModelBuilderLookup.Builder builder;
            String modelName = this.buildModelAction.getModelName();
            try {
                builder = controller.locateBuilderForDefaultTarget(modelName, false);
            }
            catch (UnknownModelException e) {
                this.modelLookupFailure = e;
                throw e;
            }
            return builder.build(null);
        }
    }
}

