/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedArrayType;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedType;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnsignedTypes {
    @NotNull
    public static final UnsignedTypes INSTANCE;
    @NotNull
    private static final Set<Name> unsignedTypeNames;
    @NotNull
    private static final Set<Name> unsignedArrayTypeNames;
    @NotNull
    private static final HashMap<ClassId, ClassId> arrayClassIdToUnsignedClassId;
    @NotNull
    private static final HashMap<ClassId, ClassId> unsignedClassIdToArrayClassId;
    @NotNull
    private static final HashMap<UnsignedArrayType, Name> unsignedArrayTypeToArrayCall;
    @NotNull
    private static final Set<Name> arrayClassesShortNames;

    private UnsignedTypes() {
    }

    public final boolean isShortNameOfUnsignedArray(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return arrayClassesShortNames.contains(name);
    }

    @Nullable
    public final ClassId getUnsignedClassIdByArrayClassId(@NotNull ClassId arrayClassId) {
        Intrinsics.checkNotNullParameter((Object)arrayClassId, (String)"arrayClassId");
        return arrayClassIdToUnsignedClassId.get(arrayClassId);
    }

    @JvmStatic
    public static final boolean isUnsignedType(@NotNull KotlinType type2) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (TypeUtils.noExpectedType(type2)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor2 == null) {
            return false;
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor = classifierDescriptor2;
        return INSTANCE.isUnsignedClass(descriptor2);
    }

    public final boolean isUnsignedClass(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        return container instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)container).getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && unsignedTypeNames.contains(descriptor2.getName());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_4;
        void $this$mapTo$iv;
        int n;
        Name name;
        Enum it;
        Collection collection;
        Enum[] $this$mapTo$iv$iv;
        INSTANCE = new UnsignedTypes();
        Enum[] $this$map$iv = UnsignedType.values();
        boolean $i$f$map = false;
        UnsignedType[] unsignedTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Enum item$iv$iv : $this$mapTo$iv$iv) {
            void var9_21 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            name = ((UnsignedType)it).getTypeName();
            collection.add(name);
        }
        unsignedTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = UnsignedArrayType.values();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        Enum[] enumArray = $this$mapTo$iv$iv;
        int n2 = enumArray.length;
        for (n = 0; n < n2; ++n) {
            Enum item$iv$iv;
            it = item$iv$iv = enumArray[n];
            collection = destination$iv$iv;
            boolean bl = false;
            name = ((UnsignedArrayType)it).getTypeName();
            collection.add(name);
        }
        unsignedArrayTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $this$map$iv32 = false;
        arrayClassIdToUnsignedClassId = new HashMap();
        $this$map$iv32 = false;
        unsignedClassIdToArrayClassId = new HashMap();
        Object[] $this$map$iv32 = new Pair[]{TuplesKt.to((Object)((Object)UnsignedArrayType.UBYTEARRAY), (Object)Name.identifier("ubyteArrayOf")), TuplesKt.to((Object)((Object)UnsignedArrayType.USHORTARRAY), (Object)Name.identifier("ushortArrayOf")), TuplesKt.to((Object)((Object)UnsignedArrayType.UINTARRAY), (Object)Name.identifier("uintArrayOf")), TuplesKt.to((Object)((Object)UnsignedArrayType.ULONGARRAY), (Object)Name.identifier("ulongArrayOf"))};
        unsignedArrayTypeToArrayCall = MapsKt.hashMapOf((Pair[])$this$map$iv32);
        $this$map$iv32 = UnsignedType.values();
        $i$f$map = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo2 = false;
        destination$iv$iv = $this$mapTo$iv;
        int n3 = ((Collection)destination$iv$iv).length;
        for (int i = 0; i < n3; ++i) {
            void it2;
            Collection item$iv;
            Collection collection2 = item$iv = destination$iv$iv[i];
            collection = destination$iv;
            boolean bl = false;
            name = it2.getArrayClassId().getShortClassName();
            collection.add(name);
        }
        arrayClassesShortNames = (Set)var1_4;
        for (UnsignedType unsignedType : UnsignedType.values()) {
            Map map = arrayClassIdToUnsignedClassId;
            ClassId classId = unsignedType.getArrayClassId();
            ClassId classId2 = unsignedType.getClassId();
            n = 0;
            map.put(classId, classId2);
            map = unsignedClassIdToArrayClassId;
            classId = unsignedType.getClassId();
            classId2 = unsignedType.getArrayClassId();
            n = 0;
            map.put(classId, classId2);
        }
    }
}

