/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import net.rubygrapefruit.platform.file.PosixFiles;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.file.StatStatistics;
import org.gradle.internal.nativeintegration.filesystem.FileCanonicalizer;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Symlink;
import org.gradle.internal.nativeintegration.filesystem.jdk7.Jdk7Symlink;
import org.gradle.internal.nativeintegration.filesystem.jdk7.WindowsJdk7Symlink;
import org.gradle.internal.nativeintegration.filesystem.services.EmptyChmod;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackFileCanonicalizer;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackStat;
import org.gradle.internal.nativeintegration.filesystem.services.GenericFileSystem;
import org.gradle.internal.nativeintegration.filesystem.services.JdkFallbackHelper;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedChmod;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedStat;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedSymlink;
import org.gradle.internal.nativeintegration.filesystem.services.UnavailablePosixFiles;
import org.gradle.internal.nativeintegration.filesystem.services.UnsupportedFilePermissions;
import org.gradle.internal.nativeintegration.filesystem.services.UnsupportedSymlink;
import org.gradle.internal.nativeintegration.filesystem.services.WindowsSymlink;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemServices.class);

    public void configure(ServiceRegistration registration) {
        registration.add(GenericFileSystem.Factory.class);
        registration.add(StatStatistics.Collector.class);
    }

    public FileCanonicalizer createFileCanonicalizer() {
        return JdkFallbackHelper.newInstanceOrFallback("org.gradle.internal.nativeintegration.filesystem.jdk7.Jdk7FileCanonicalizer", FileSystemServices.class.getClassLoader(), FallbackFileCanonicalizer.class);
    }

    private static Symlink createWindowsJdkSymlink() {
        if (JavaVersion.current().isJava7Compatible()) {
            return new WindowsJdk7Symlink();
        }
        return new WindowsSymlink();
    }

    private static Symlink createJdkSymlink(TemporaryFileProvider temporaryFileProvider) {
        if (JavaVersion.current().isJava7Compatible()) {
            return new Jdk7Symlink(temporaryFileProvider);
        }
        return new UnsupportedSymlink();
    }

    public FileSystem createFileSystem(GenericFileSystem.Factory genericFileSystemFactory, OperatingSystem operatingSystem, PosixFiles posixFiles, FileMetadataAccessor metadataAccessor, TemporaryFileProvider temporaryFileProvider) {
        if (operatingSystem.isWindows()) {
            Symlink symlink = FileSystemServices.createWindowsJdkSymlink();
            return genericFileSystemFactory.create(new EmptyChmod(), new FallbackStat(), symlink);
        }
        if (!(posixFiles instanceof UnavailablePosixFiles)) {
            NativePlatformBackedSymlink symlink = new NativePlatformBackedSymlink(posixFiles);
            NativePlatformBackedChmod chmod = new NativePlatformBackedChmod(posixFiles);
            NativePlatformBackedStat stat = new NativePlatformBackedStat(posixFiles);
            return genericFileSystemFactory.create(chmod, stat, symlink);
        }
        LOGGER.debug("Native-platform file system integration is not available. Continuing with fallback.");
        Symlink symlink = FileSystemServices.createJdkSymlink(temporaryFileProvider);
        LOGGER.debug("Using {} implementation as symlink.", (Object)symlink.getClass().getSimpleName());
        UnsupportedFilePermissions handler = JdkFallbackHelper.newInstanceOrFallback("org.gradle.internal.nativeintegration.filesystem.jdk7.PosixJdk7FilePermissionHandler", FileSystemServices.class.getClassLoader(), UnsupportedFilePermissions.class);
        return genericFileSystemFactory.create(handler, handler, symlink);
    }
}

