/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;

public class CachingJvmMetadataDetector
implements JvmMetadataDetector {
    private final Map<File, JvmInstallationMetadata> javaMetadata = new ConcurrentHashMap<File, JvmInstallationMetadata>();
    private final JvmMetadataDetector delegate;

    public CachingJvmMetadataDetector(JvmMetadataDetector delegate) {
        this.delegate = delegate;
        this.getMetadata(Jvm.current().getJavaHome());
    }

    @Override
    public JvmInstallationMetadata getMetadata(File javaHome) {
        javaHome = this.resolveSymlink(javaHome);
        return this.javaMetadata.computeIfAbsent(javaHome, this.delegate::getMetadata);
    }

    private File resolveSymlink(File jdkPath) {
        try {
            return jdkPath.getCanonicalFile();
        }
        catch (IOException e) {
            return jdkPath;
        }
    }
}

