/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;

public class StaticLockingMavenPublisher
implements MavenPublisher {
    private static final Lock STATIC_LOCK = new ReentrantLock();
    private final MavenPublisher delegate;

    public StaticLockingMavenPublisher(MavenPublisher delegate) {
        this.delegate = delegate;
    }

    @Override
    public void publish(MavenNormalizedPublication publication, MavenArtifactRepository artifactRepository) {
        STATIC_LOCK.lock();
        try {
            this.delegate.publish(publication, artifactRepository);
        }
        finally {
            STATIC_LOCK.unlock();
        }
    }
}

