/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.action;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.artifacts.verification.DependencyVerificationMode;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.initialization.StartParameterBuildOptions;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.internal.watch.vfs.WatchMode;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalDebugOptions;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.provider.action.BuildModelAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedPhasedAction;
import org.gradle.tooling.internal.provider.action.ExecuteBuildAction;
import org.gradle.tooling.internal.provider.action.TestExecutionRequestAction;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.internal.provider.serialization.SerializedPayloadSerializer;

public class BuildActionSerializer {
    public static Serializer<BuildAction> create() {
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(ExecuteBuildAction.class, (Serializer)new ExecuteBuildActionSerializer());
        registry.register(BuildModelAction.class, (Serializer)new BuildModelActionSerializer());
        registry.register(ClientProvidedBuildAction.class, (Serializer)new ClientProvidedBuildActionSerializer());
        registry.register(ClientProvidedPhasedAction.class, (Serializer)new ClientProvidedPhasedActionSerializer());
        registry.register(TestExecutionRequestAction.class, (Serializer)new TestExecutionRequestActionSerializer());
        return registry.build(BuildAction.class);
    }

    private static class NullableFileSerializer
    implements Serializer<File> {
        private NullableFileSerializer() {
        }

        public void write(Encoder encoder, File value) throws Exception {
            if (value == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                encoder.writeString((CharSequence)value.getPath());
            }
        }

        public File read(Decoder decoder) throws Exception {
            if (decoder.readBoolean()) {
                return new File(decoder.readString());
            }
            return null;
        }
    }

    private static class ValueSerializer
    implements Serializer<BuildOption.Value<Boolean>> {
        private static final byte EXPLICIT_TRUE = 1;
        private static final byte EXPLICIT_FALSE = 2;
        public static final byte IMPLICIT_TRUE = 3;
        public static final byte IMPLICIT_FALSE = 4;

        private ValueSerializer() {
        }

        public BuildOption.Value<Boolean> read(Decoder decoder) throws Exception {
            switch (decoder.readByte()) {
                case 1: {
                    return BuildOption.Value.value((Object)true);
                }
                case 2: {
                    return BuildOption.Value.value((Object)false);
                }
                case 3: {
                    return BuildOption.Value.defaultValue((Object)true);
                }
                case 4: {
                    return BuildOption.Value.defaultValue((Object)false);
                }
            }
            throw new IllegalStateException();
        }

        public void write(Encoder encoder, BuildOption.Value<Boolean> value) throws Exception {
            if (value.isExplicit() && ((Boolean)value.get()).booleanValue()) {
                encoder.writeByte((byte)1);
            } else if (value.isExplicit()) {
                encoder.writeByte((byte)2);
            } else if (((Boolean)value.get()).booleanValue()) {
                encoder.writeByte((byte)3);
            } else {
                encoder.writeByte((byte)4);
            }
        }
    }

    private static class BuildEventSubscriptionsSerializer
    implements Serializer<BuildEventSubscriptions> {
        private final Serializer<Set<OperationType>> setSerializer;

        public BuildEventSubscriptionsSerializer() {
            BaseSerializerFactory serializerFactory = new BaseSerializerFactory();
            this.setSerializer = new SetSerializer(serializerFactory.getSerializerFor(OperationType.class));
        }

        public void write(Encoder encoder, BuildEventSubscriptions value) throws Exception {
            this.setSerializer.write(encoder, (Object)value.getOperationTypes());
        }

        public BuildEventSubscriptions read(Decoder decoder) throws Exception {
            return new BuildEventSubscriptions((Set)this.setSerializer.read(decoder));
        }
    }

    private static class TestExecutionRequestActionSerializer
    implements Serializer<TestExecutionRequestAction> {
        private final Serializer<StartParameterInternal> startParameterSerializer = new StartParameterSerializer();
        private final Serializer<BuildEventSubscriptions> buildEventSubscriptionsSerializer = new BuildEventSubscriptionsSerializer();
        private final Serializer<TestExecutionRequestPayload> payloadSerializer = new DefaultSerializer();

        private TestExecutionRequestActionSerializer() {
        }

        public void write(Encoder encoder, TestExecutionRequestAction value) throws Exception {
            this.startParameterSerializer.write(encoder, (Object)value.getStartParameter());
            this.buildEventSubscriptionsSerializer.write(encoder, (Object)value.getClientSubscriptions());
            this.payloadSerializer.write(encoder, (Object)new TestExecutionRequestPayload(value.getTestExecutionDescriptors(), value.getTestClassNames(), value.getInternalJvmTestRequests(), value.getDebugOptions(), value.getTaskAndTests()));
        }

        public TestExecutionRequestAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = (StartParameterInternal)this.startParameterSerializer.read(decoder);
            BuildEventSubscriptions buildEventSubscriptions = (BuildEventSubscriptions)this.buildEventSubscriptionsSerializer.read(decoder);
            TestExecutionRequestPayload payload = (TestExecutionRequestPayload)this.payloadSerializer.read(decoder);
            return new TestExecutionRequestAction(buildEventSubscriptions, startParameter, payload.testDescriptors, payload.classNames, payload.internalJvmTestRequests, payload.debugOptions, payload.taskAndTests);
        }
    }

    private static class TestExecutionRequestPayload
    implements Serializable {
        final Set<InternalTestDescriptor> testDescriptors;
        final Set<String> classNames;
        final Set<InternalJvmTestRequest> internalJvmTestRequests;
        final InternalDebugOptions debugOptions;
        final Map<String, List<InternalJvmTestRequest>> taskAndTests;

        public TestExecutionRequestPayload(Set<InternalTestDescriptor> testDescriptors, Set<String> classNames, Set<InternalJvmTestRequest> internalJvmTestRequests, InternalDebugOptions debugOptions, Map<String, List<InternalJvmTestRequest>> taskAndTests) {
            this.testDescriptors = testDescriptors;
            this.classNames = classNames;
            this.internalJvmTestRequests = internalJvmTestRequests;
            this.debugOptions = debugOptions;
            this.taskAndTests = taskAndTests;
        }
    }

    private static class ClientProvidedPhasedActionSerializer
    implements Serializer<ClientProvidedPhasedAction> {
        private final Serializer<StartParameterInternal> startParameterSerializer = new StartParameterSerializer();
        private final Serializer<SerializedPayload> payloadSerializer = new SerializedPayloadSerializer();
        private final Serializer<BuildEventSubscriptions> buildEventSubscriptionsSerializer = new BuildEventSubscriptionsSerializer();

        private ClientProvidedPhasedActionSerializer() {
        }

        public void write(Encoder encoder, ClientProvidedPhasedAction value) throws Exception {
            this.startParameterSerializer.write(encoder, (Object)value.getStartParameter());
            this.payloadSerializer.write(encoder, (Object)value.getPhasedAction());
            encoder.writeBoolean(value.isRunTasks());
            this.buildEventSubscriptionsSerializer.write(encoder, (Object)value.getClientSubscriptions());
        }

        public ClientProvidedPhasedAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = (StartParameterInternal)this.startParameterSerializer.read(decoder);
            SerializedPayload action = (SerializedPayload)this.payloadSerializer.read(decoder);
            boolean runTasks = decoder.readBoolean();
            BuildEventSubscriptions buildEventSubscriptions = (BuildEventSubscriptions)this.buildEventSubscriptionsSerializer.read(decoder);
            return new ClientProvidedPhasedAction(startParameter, action, runTasks, buildEventSubscriptions);
        }
    }

    private static class ClientProvidedBuildActionSerializer
    implements Serializer<ClientProvidedBuildAction> {
        private final Serializer<StartParameterInternal> startParameterSerializer = new StartParameterSerializer();
        private final Serializer<SerializedPayload> payloadSerializer = new SerializedPayloadSerializer();
        private final Serializer<BuildEventSubscriptions> buildEventSubscriptionsSerializer = new BuildEventSubscriptionsSerializer();

        private ClientProvidedBuildActionSerializer() {
        }

        public void write(Encoder encoder, ClientProvidedBuildAction value) throws Exception {
            this.startParameterSerializer.write(encoder, (Object)value.getStartParameter());
            this.payloadSerializer.write(encoder, (Object)value.getAction());
            encoder.writeBoolean(value.isRunTasks());
            this.buildEventSubscriptionsSerializer.write(encoder, (Object)value.getClientSubscriptions());
        }

        public ClientProvidedBuildAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = (StartParameterInternal)this.startParameterSerializer.read(decoder);
            SerializedPayload action = (SerializedPayload)this.payloadSerializer.read(decoder);
            boolean runTasks = decoder.readBoolean();
            BuildEventSubscriptions buildEventSubscriptions = (BuildEventSubscriptions)this.buildEventSubscriptionsSerializer.read(decoder);
            return new ClientProvidedBuildAction(startParameter, action, runTasks, buildEventSubscriptions);
        }
    }

    private static class BuildModelActionSerializer
    implements Serializer<BuildModelAction> {
        private final Serializer<StartParameterInternal> startParameterSerializer = new StartParameterSerializer();
        private final Serializer<BuildEventSubscriptions> buildEventSubscriptionsSerializer = new BuildEventSubscriptionsSerializer();

        private BuildModelActionSerializer() {
        }

        public void write(Encoder encoder, BuildModelAction value) throws Exception {
            this.startParameterSerializer.write(encoder, (Object)value.getStartParameter());
            encoder.writeString((CharSequence)value.getModelName());
            encoder.writeBoolean(value.isRunTasks());
            this.buildEventSubscriptionsSerializer.write(encoder, (Object)value.getClientSubscriptions());
        }

        public BuildModelAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = (StartParameterInternal)this.startParameterSerializer.read(decoder);
            String modelName = decoder.readString();
            boolean runTasks = decoder.readBoolean();
            BuildEventSubscriptions buildEventSubscriptions = (BuildEventSubscriptions)this.buildEventSubscriptionsSerializer.read(decoder);
            return new BuildModelAction(startParameter, modelName, runTasks, buildEventSubscriptions);
        }
    }

    private static class ExecuteBuildActionSerializer
    implements Serializer<ExecuteBuildAction> {
        private final Serializer<StartParameterInternal> startParameterSerializer = new StartParameterSerializer();

        private ExecuteBuildActionSerializer() {
        }

        public void write(Encoder encoder, ExecuteBuildAction action) throws Exception {
            StartParameterInternal startParameter = action.getStartParameter();
            this.startParameterSerializer.write(encoder, (Object)startParameter);
        }

        public ExecuteBuildAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = (StartParameterInternal)this.startParameterSerializer.read(decoder);
            return new ExecuteBuildAction(startParameter);
        }
    }

    private static class StartParameterSerializer
    implements Serializer<StartParameterInternal> {
        private final Serializer<LogLevel> logLevelSerializer;
        private final Serializer<ShowStacktrace> showStacktraceSerializer;
        private final Serializer<ConsoleOutput> consoleOutputSerializer;
        private final Serializer<WarningMode> warningModeSerializer;
        private final Serializer<File> nullableFileSerializer = new NullableFileSerializer();
        private final Serializer<List<String>> stringListSerializer = new ListSerializer(BaseSerializerFactory.STRING_SERIALIZER);
        private final Serializer<List<File>> fileListSerializer = new ListSerializer(BaseSerializerFactory.FILE_SERIALIZER);
        private final Serializer<Set<String>> stringSetSerializer = new SetSerializer(BaseSerializerFactory.STRING_SERIALIZER);
        private final Serializer<BuildOption.Value<Boolean>> valueSerializer = new ValueSerializer();

        StartParameterSerializer() {
            BaseSerializerFactory serializerFactory = new BaseSerializerFactory();
            this.logLevelSerializer = serializerFactory.getSerializerFor(LogLevel.class);
            this.showStacktraceSerializer = serializerFactory.getSerializerFor(ShowStacktrace.class);
            this.consoleOutputSerializer = serializerFactory.getSerializerFor(ConsoleOutput.class);
            this.warningModeSerializer = serializerFactory.getSerializerFor(WarningMode.class);
        }

        public void write(Encoder encoder, StartParameterInternal startParameter) throws Exception {
            this.logLevelSerializer.write(encoder, (Object)startParameter.getLogLevel());
            this.showStacktraceSerializer.write(encoder, (Object)startParameter.getShowStacktrace());
            this.consoleOutputSerializer.write(encoder, (Object)startParameter.getConsoleOutput());
            this.warningModeSerializer.write(encoder, (Object)startParameter.getWarningMode());
            encoder.writeBoolean(startParameter.isParallelProjectExecutionEnabled());
            encoder.writeSmallInt(startParameter.getMaxWorkerCount());
            this.writeTaskRequests(encoder, startParameter.getTaskRequests());
            this.stringSetSerializer.write(encoder, (Object)startParameter.getExcludedTaskNames());
            File customBuildFile = startParameter.getBuildFile();
            this.nullableFileSerializer.write(encoder, (Object)customBuildFile);
            this.nullableFileSerializer.write(encoder, (Object)startParameter.getProjectDir());
            File customSettingsFile = startParameter.getSettingsFile();
            this.nullableFileSerializer.write(encoder, (Object)customSettingsFile);
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, (Object)startParameter.getCurrentDir());
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, (Object)startParameter.getGradleUserHomeDir());
            this.nullableFileSerializer.write(encoder, (Object)startParameter.getGradleHomeDir());
            this.nullableFileSerializer.write(encoder, (Object)startParameter.getProjectCacheDir());
            this.fileListSerializer.write(encoder, (Object)startParameter.getIncludedBuilds());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, (Object)startParameter.getProjectProperties());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, (Object)startParameter.getSystemPropertiesArgs());
            this.fileListSerializer.write(encoder, (Object)startParameter.getInitScripts());
            this.stringListSerializer.write(encoder, (Object)startParameter.getLockedDependenciesToUpdate());
            encoder.writeBoolean(startParameter.isBuildProjectDependencies());
            encoder.writeBoolean(startParameter.isDryRun());
            encoder.writeBoolean(startParameter.isRerunTasks());
            encoder.writeBoolean(startParameter.isProfile());
            encoder.writeBoolean(startParameter.isContinueOnFailure());
            encoder.writeBoolean(startParameter.isOffline());
            encoder.writeBoolean(startParameter.isRefreshDependencies());
            encoder.writeBoolean(startParameter.isBuildCacheEnabled());
            encoder.writeBoolean(startParameter.isBuildCacheDebugLogging());
            encoder.writeString((CharSequence)startParameter.getWatchFileSystemMode().name());
            encoder.writeBoolean(startParameter.isWatchFileSystemDebugLogging());
            encoder.writeBoolean(startParameter.isVfsVerboseLogging());
            this.valueSerializer.write(encoder, (Object)startParameter.getConfigurationCache());
            this.valueSerializer.write(encoder, (Object)startParameter.getIsolatedProjects());
            encoder.writeString((CharSequence)startParameter.getConfigurationCacheProblems().name());
            encoder.writeSmallInt(startParameter.getConfigurationCacheMaxProblems());
            encoder.writeBoolean(startParameter.isConfigurationCacheRecreateCache());
            encoder.writeBoolean(startParameter.isConfigurationCacheQuiet());
            encoder.writeBoolean(startParameter.isConfigureOnDemand());
            encoder.writeBoolean(startParameter.isContinuous());
            encoder.writeBoolean(startParameter.isBuildScan());
            encoder.writeBoolean(startParameter.isNoBuildScan());
            encoder.writeBoolean(startParameter.isWriteDependencyLocks());
            this.stringListSerializer.write(encoder, (Object)startParameter.getWriteDependencyVerifications());
            encoder.writeString((CharSequence)startParameter.getDependencyVerificationMode().name());
            encoder.writeBoolean(startParameter.isRefreshKeys());
            encoder.writeBoolean(startParameter.isExportKeys());
        }

        private void writeTaskRequests(Encoder encoder, List<TaskExecutionRequest> taskRequests) throws Exception {
            encoder.writeSmallInt(taskRequests.size());
            for (TaskExecutionRequest taskRequest : taskRequests) {
                if (!(taskRequest instanceof DefaultTaskExecutionRequest)) {
                    throw new UnsupportedOperationException();
                }
                DefaultTaskExecutionRequest request = (DefaultTaskExecutionRequest)taskRequest;
                encoder.writeNullableString((CharSequence)request.getProjectPath());
                this.nullableFileSerializer.write(encoder, (Object)request.getRootDir());
                this.stringListSerializer.write(encoder, (Object)request.getArgs());
            }
        }

        public StartParameterInternal read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = new StartParameterInternal();
            startParameter.setLogLevel((LogLevel)this.logLevelSerializer.read(decoder));
            startParameter.setShowStacktrace((ShowStacktrace)this.showStacktraceSerializer.read(decoder));
            startParameter.setConsoleOutput((ConsoleOutput)this.consoleOutputSerializer.read(decoder));
            startParameter.setWarningMode((WarningMode)this.warningModeSerializer.read(decoder));
            startParameter.setParallelProjectExecutionEnabled(decoder.readBoolean());
            startParameter.setMaxWorkerCount(decoder.readSmallInt());
            startParameter.setTaskRequests(this.readTaskRequests(decoder));
            startParameter.setExcludedTaskNames((Iterable)this.stringSetSerializer.read(decoder));
            startParameter.setBuildFile((File)this.nullableFileSerializer.read(decoder));
            startParameter.setProjectDir((File)this.nullableFileSerializer.read(decoder));
            startParameter.setSettingsFile((File)this.nullableFileSerializer.read(decoder));
            startParameter.setCurrentDir((File)BaseSerializerFactory.FILE_SERIALIZER.read(decoder));
            startParameter.setGradleUserHomeDir((File)BaseSerializerFactory.FILE_SERIALIZER.read(decoder));
            startParameter.setGradleHomeDir((File)this.nullableFileSerializer.read(decoder));
            startParameter.setProjectCacheDir((File)this.nullableFileSerializer.read(decoder));
            startParameter.setIncludedBuilds((List)this.fileListSerializer.read(decoder));
            startParameter.setProjectProperties((Map)BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder));
            startParameter.setSystemPropertiesArgs((Map)BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder));
            startParameter.setInitScripts((List)this.fileListSerializer.read(decoder));
            startParameter.setLockedDependenciesToUpdate((List)this.stringListSerializer.read(decoder));
            startParameter.setBuildProjectDependencies(decoder.readBoolean());
            startParameter.setDryRun(decoder.readBoolean());
            startParameter.setRerunTasks(decoder.readBoolean());
            startParameter.setProfile(decoder.readBoolean());
            startParameter.setContinueOnFailure(decoder.readBoolean());
            startParameter.setOffline(decoder.readBoolean());
            startParameter.setRefreshDependencies(decoder.readBoolean());
            startParameter.setBuildCacheEnabled(decoder.readBoolean());
            startParameter.setBuildCacheDebugLogging(decoder.readBoolean());
            startParameter.setWatchFileSystemMode(WatchMode.valueOf((String)decoder.readString()));
            startParameter.setWatchFileSystemDebugLogging(decoder.readBoolean());
            startParameter.setVfsVerboseLogging(decoder.readBoolean());
            startParameter.setConfigurationCache((BuildOption.Value)this.valueSerializer.read(decoder));
            startParameter.setIsolatedProjects((BuildOption.Value)this.valueSerializer.read(decoder));
            startParameter.setConfigurationCacheProblems(StartParameterBuildOptions.ConfigurationCacheProblemsOption.Value.valueOf((String)decoder.readString()));
            startParameter.setConfigurationCacheMaxProblems(decoder.readSmallInt());
            startParameter.setConfigurationCacheRecreateCache(decoder.readBoolean());
            startParameter.setConfigurationCacheQuiet(decoder.readBoolean());
            startParameter.setConfigureOnDemand(decoder.readBoolean());
            startParameter.setContinuous(decoder.readBoolean());
            startParameter.setBuildScan(decoder.readBoolean());
            startParameter.setNoBuildScan(decoder.readBoolean());
            startParameter.setWriteDependencyLocks(decoder.readBoolean());
            List checksums = (List)this.stringListSerializer.read(decoder);
            if (!checksums.isEmpty()) {
                startParameter.setWriteDependencyVerifications(checksums);
            }
            startParameter.setDependencyVerificationMode(DependencyVerificationMode.valueOf((String)decoder.readString()));
            startParameter.setRefreshKeys(decoder.readBoolean());
            startParameter.setExportKeys(decoder.readBoolean());
            return startParameter;
        }

        private List<TaskExecutionRequest> readTaskRequests(Decoder decoder) throws Exception {
            int requestCount = decoder.readSmallInt();
            ArrayList<TaskExecutionRequest> taskExecutionRequests = new ArrayList<TaskExecutionRequest>(requestCount);
            for (int i = 0; i < requestCount; ++i) {
                String projectPath = decoder.readNullableString();
                File rootDir = (File)this.nullableFileSerializer.read(decoder);
                List args = (List)this.stringListSerializer.read(decoder);
                taskExecutionRequests.add((TaskExecutionRequest)new DefaultTaskExecutionRequest((Iterable)args, projectPath, rootDir));
            }
            return taskExecutionRequests;
        }
    }
}

