/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;

public class RunPreviousFailedFirstTestClassProcessor
implements TestClassProcessor {
    private final Set<String> previousFailedTestClasses;
    private final TestClassProcessor delegate;
    private final LinkedHashSet<TestClassRunInfo> prioritizedTestClasses = new LinkedHashSet();
    private final LinkedHashSet<TestClassRunInfo> otherTestClasses = new LinkedHashSet();

    public RunPreviousFailedFirstTestClassProcessor(Set<String> previousFailedTestClasses, TestClassProcessor delegate) {
        this.previousFailedTestClasses = previousFailedTestClasses;
        this.delegate = delegate;
    }

    @Override
    public void startProcessing(TestResultProcessor resultProcessor) {
        this.delegate.startProcessing(resultProcessor);
    }

    @Override
    public void processTestClass(TestClassRunInfo testClass) {
        if (this.previousFailedTestClasses.contains(testClass.getTestClassName())) {
            this.prioritizedTestClasses.add(testClass);
        } else {
            this.otherTestClasses.add(testClass);
        }
    }

    @Override
    public void stop() {
        for (TestClassRunInfo test : this.prioritizedTestClasses) {
            this.delegate.processTestClass(test);
        }
        for (TestClassRunInfo test : this.otherTestClasses) {
            this.delegate.processTestClass(test);
        }
        this.delegate.stop();
    }

    @Override
    public void stopNow() {
        this.delegate.stopNow();
    }
}

