/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.scopes.FirCompositeScope;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J&\u0010\u000b\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J$\u0010\f\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ$\u0010\r\u001a\u00020\u000e2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;", "", "()V", "getNestedClassifierScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getStaticMemberScopeForCallables", "getStaticScope", "getUseSiteMemberScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "tree"})
public abstract class FirScopeProvider {
    @NotNull
    public abstract FirTypeScope getUseSiteMemberScope(@NotNull FirClass<?> var1, @NotNull FirSession var2, @NotNull ScopeSession var3);

    @Nullable
    public abstract FirScope getStaticMemberScopeForCallables(@NotNull FirClass<?> var1, @NotNull FirSession var2, @NotNull ScopeSession var3);

    @Nullable
    public abstract FirScope getNestedClassifierScope(@NotNull FirClass<?> var1, @NotNull FirSession var2, @NotNull ScopeSession var3);

    @Nullable
    public final FirScope getStaticScope(@NotNull FirClass<?> klass, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        FirScope firScope;
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        FirScope nestedClassifierScope = this.getNestedClassifierScope(klass, useSiteSession, scopeSession);
        FirScope callableScope = this.getStaticMemberScopeForCallables(klass, useSiteSession, scopeSession);
        if (nestedClassifierScope != null && callableScope != null) {
            Object[] objectArray = new FirScope[]{nestedClassifierScope, callableScope};
            firScope = new FirCompositeScope(CollectionsKt.listOf((Object[])objectArray));
        } else {
            FirScope firScope2 = nestedClassifierScope;
            firScope = firScope2 == null ? callableScope : firScope2;
        }
        return firScope;
    }
}

