/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;
import sun.misc.Unsafe;

public final class ByteBufferUtil {
    public static boolean cleanBuffer(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            ByteBufferUtil.$$$reportNull$$$0(0);
        }
        if (!buffer.isDirect()) {
            return true;
        }
        if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
            Unsafe unsafe = AtomicFieldUpdater.getUnsafe();
            try {
                MethodType type2 = MethodType.methodType(Void.TYPE, ByteBuffer.class);
                MethodHandle handle2 = MethodHandles.lookup().findVirtual(Unsafe.class, "invokeCleaner", type2);
                handle2.invokeExact(unsafe, buffer);
                return true;
            }
            catch (Throwable t) {
                Logger.getInstance(ByteBufferUtil.class).warn(t);
                return false;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/util/io/ByteBufferUtil", "cleanBuffer"));
    }
}

